<?php
// --- Meta for SEO ---
$page_title = "Instagram Money Calculator: Real Earnings Estimator for Creators & Influencers";
$page_description = "Discover your true Instagram earning potential with our advanced Instagram Money Calculator. Instantly estimate your monthly income from views, followers, and engagement—customized for every country and niche. Trusted by creators, brands, and marketers worldwide.";
$page_author = "Gwaa";
$page_keywords = "Instagram Money Calculator, Instagram earnings, Instagram influencer income, Instagram revenue estimator, Instagram engagement rate, Instagram sponsored post, Instagram brand deals, Instagram creator tools, Instagram RPM, Instagram CPM, Instagram country RPM, Instagram niche RPM, Instagram influencer calculator";


// --- All ISO 3166-1 countries (reuse from your template) ---
$countries = [
    "AF" => "Afghanistan",
    "AX" => "Åland Islands",
    "AL" => "Albania",
    "DZ" => "Algeria",
    "AS" => "American Samoa",
    "AD" => "Andorra",
    "AO" => "Angola",
    "AI" => "Anguilla",
    "AQ" => "Antarctica",
    "AG" => "Antigua and Barbuda",
    "AR" => "Argentina",
    "AM" => "Armenia",
    "AW" => "Aruba",
    "AU" => "Australia",
    "AT" => "Austria",
    "AZ" => "Azerbaijan",
    "BS" => "Bahamas (the)",
    "BH" => "Bahrain",
    "BD" => "Bangladesh",
    "BB" => "Barbados",
    "BY" => "Belarus",
    "BE" => "Belgium",
    "BZ" => "Belize",
    "BJ" => "Benin",
    "BM" => "Bermuda",
    "BT" => "Bhutan",
    "BO" => "Bolivia (Plurinational State of)",
    "BQ" => "Bonaire, Sint Eustatius and Saba",
    "BA" => "Bosnia and Herzegovina",
    "BW" => "Botswana",
    "BV" => "Bouvet Island",
    "BR" => "Brazil",
    "IO" => "British Indian Ocean Territory (the)",
    "BN" => "Brunei Darussalam",
    "BG" => "Bulgaria",
    "BF" => "Burkina Faso",
    "BI" => "Burundi",
    "CV" => "Cabo Verde",
    "KH" => "Cambodia",
    "CM" => "Cameroon",
    "CA" => "Canada",
    "KY" => "Cayman Islands (the)",
    "CF" => "Central African Republic (the)",
    "TD" => "Chad",
    "CL" => "Chile",
    "CN" => "China",
    "CX" => "Christmas Island",
    "CC" => "Cocos (Keeling) Islands (the)",
    "CO" => "Colombia",
    "KM" => "Comoros (the)",
    "CD" => "Congo (the Democratic Republic of the)",
    "CG" => "Congo (the)",
    "CK" => "Cook Islands (the)",
    "CR" => "Costa Rica",
    "CI" => "Côte d'Ivoire",
    "HR" => "Croatia",
    "CU" => "Cuba",
    "CW" => "Curaçao",
    "CY" => "Cyprus",
    "CZ" => "Czechia",
    "DK" => "Denmark",
    "DJ" => "Djibouti",
    "DM" => "Dominica",
    "DO" => "Dominican Republic (the)",
    "EC" => "Ecuador",
    "EG" => "Egypt",
    "SV" => "El Salvador",
    "GQ" => "Equatorial Guinea",
    "ER" => "Eritrea",
    "EE" => "Estonia",
    "SZ" => "Eswatini",
    "ET" => "Ethiopia",
    "FK" => "Falkland Islands (the) [Malvinas]",
    "FO" => "Faroe Islands (the)",
    "FJ" => "Fiji",
    "FI" => "Finland",
    "FR" => "France",
    "GF" => "French Guiana",
    "PF" => "French Polynesia",
    "TF" => "French Southern Territories (the)",
    "GA" => "Gabon",
    "GM" => "Gambia (the)",
    "GE" => "Georgia",
    "DE" => "Germany",
    "GH" => "Ghana",
    "GI" => "Gibraltar",
    "GR" => "Greece",
    "GL" => "Greenland",
    "GD" => "Grenada",
    "GP" => "Guadeloupe",
    "GU" => "Guam",
    "GT" => "Guatemala",
    "GG" => "Guernsey",
    "GN" => "Guinea",
    "GW" => "Guinea-Bissau",
    "GY" => "Guyana",
    "HT" => "Haiti",
    "HM" => "Heard Island and McDonald Islands",
    "VA" => "Holy See (the)",
    "HN" => "Honduras",
    "HK" => "Hong Kong",
    "HU" => "Hungary",
    "IS" => "Iceland",
    "IN" => "India",
    "ID" => "Indonesia",
    "IR" => "Iran (Islamic Republic of)",
    "IQ" => "Iraq",
    "IE" => "Ireland",
    "IM" => "Isle of Man",
    "IL" => "Israel",
    "IT" => "Italy",
    "JM" => "Jamaica",
    "JP" => "Japan",
    "JE" => "Jersey",
    "JO" => "Jordan",
    "KZ" => "Kazakhstan",
    "KE" => "Kenya",
    "KI" => "Kiribati",
    "KP" => "Korea (the Democratic People's Republic of)",
    "KR" => "Korea (the Republic of)",
    "KW" => "Kuwait",
    "KG" => "Kyrgyzstan",
    "LA" => "Lao People's Democratic Republic (the)",
    "LV" => "Latvia",
    "LB" => "Lebanon",
    "LS" => "Lesotho",
    "LR" => "Liberia",
    "LY" => "Libya",
    "LI" => "Liechtenstein",
    "LT" => "Lithuania",
    "LU" => "Luxembourg",
    "MO" => "Macao",
    "MK" => "Republic of North Macedonia",
    "MG" => "Madagascar",
    "MW" => "Malawi",
    "MY" => "Malaysia",
    "MV" => "Maldives",
    "ML" => "Mali",
    "MT" => "Malta",
    "MH" => "Marshall Islands (the)",
    "MQ" => "Martinique",
    "MR" => "Mauritania",
    "MU" => "Mauritius",
    "YT" => "Mayotte",
    "MX" => "Mexico",
    "FM" => "Micronesia (Federated States of)",
    "MD" => "Moldova (the Republic of)",
    "MC" => "Monaco",
    "MN" => "Mongolia",
    "ME" => "Montenegro",
    "MS" => "Montserrat",
    "MA" => "Morocco",
    "MZ" => "Mozambique",
    "MM" => "Myanmar",
    "NA" => "Namibia",
    "NR" => "Nauru",
    "NP" => "Nepal",
    "NL" => "Netherlands (the)",
    "NC" => "New Caledonia",
    "NZ" => "New Zealand",
    "NI" => "Nicaragua",
    "NE" => "Niger (the)",
    "NG" => "Nigeria",
    "NU" => "Niue",
    "NF" => "Norfolk Island",
    "MP" => "Northern Mariana Islands (the)",
    "NO" => "Norway",
    "OM" => "Oman",
    "PK" => "Pakistan",
    "PW" => "Palau",
    "PS" => "Palestine, State of",
    "PA" => "Panama",
    "PG" => "Papua New Guinea",
    "PY" => "Paraguay",
    "PE" => "Peru",
    "PH" => "Philippines",
    "PN" => "Pitcairn",
    "PL" => "Poland",
    "PT" => "Portugal",
    "PR" => "Puerto Rico",
    "QA" => "Qatar",
    "RE" => "Réunion",
    "RO" => "Romania",
    "RU" => "Russian Federation",
    "RW" => "Rwanda",
    "BL" => "Saint Barthélemy",
    "SH" => "Saint Helena, Ascension and Tristan da Cunha",
    "KN" => "Saint Kitts and Nevis",
    "LC" => "Saint Lucia",
    "MF" => "Saint Martin (French part)",
    "PM" => "Saint Pierre and Miquelon",
    "VC" => "Saint Vincent and the Grenadines",
    "WS" => "Samoa",
    "SM" => "San Marino",
    "ST" => "Sao Tome and Principe",
    "SA" => "Saudi Arabia",
    "SN" => "Senegal",
    "RS" => "Serbia",
    "SC" => "Seychelles",
    "SL" => "Sierra Leone",
    "SG" => "Singapore",
    "SX" => "Sint Maarten (Dutch part)",
    "SK" => "Slovakia",
    "SI" => "Slovenia",
    "SB" => "Solomon Islands",
    "SO" => "Somalia",
    "ZA" => "South Africa",
    "GS" => "South Georgia and the South Sandwich Islands",
    "SS" => "South Sudan",
    "ES" => "Spain",
    "LK" => "Sri Lanka",
    "SD" => "Sudan",
    "SR" => "Suriname",
    "SJ" => "Svalbard and Jan Mayen",
    "SE" => "Sweden",
    "CH" => "Switzerland",
    "SY" => "Syrian Arab Republic",
    "TW" => "Taiwan",
    "TJ" => "Tajikistan",
    "TZ" => "Tanzania, United Republic of",
    "TH" => "Thailand",
    "TL" => "Timor-Leste",
    "TG" => "Togo",
    "TK" => "Tokelau",
    "TO" => "Tonga",
    "TT" => "Trinidad and Tobago",
    "TN" => "Tunisia",
    "TR" => "Turkey",
    "TM" => "Turkmenistan",
    "TV" => "Tuvalu",
    "UG" => "Uganda",
    "UA" => "Ukraine",
    "AE" => "United Arab Emirates",
    "GB" => "United Kingdom of Great Britain and Northern Ireland",
    "US" => "United States of America",
    "UY" => "Uruguay",
    "UZ" => "Uzbekistan",
    "VU" => "Vanuatu",
    "VE" => "Venezuela (Bolivarian Republic of)",
    "VN" => "Viet Nam",
    "EH" => "Western Sahara",
    "YE" => "Yemen",
    "ZM" => "Zambia",
    "ZW" => "Zimbabwe"
];


// --- Example RPM values by country (USD) (reuse from your template) ---
$country_rpm = [
    "AF" => 2.50,
    "AX" => 1.20,
    "AL" => 2.00,
    "DZ" => 2.10,
    "AS" => 1.00,
    "AD" => 3.00,
    "AO" => 1.00,
    "AI" => 1.50,
    "AQ" => 0.00,
    "AG" => 1.60,
    "AR" => 3.50,
    "AM" => 2.20,
    "AW" => 1.50,
    "AU" => 18.00,
    "AT" => 10.00,
    "AZ" => 1.80,
    "BS" => 2.50,
    "BH" => 3.00,
    "BD" => 1.50,
    "BB" => 2.00,
    "BY" => 1.50,
    "BE" => 7.50,
    "BZ" => 1.50,
    "BJ" => 1.00,
    "BM" => 2.50,
    "BT" => 1.20,
    "BO" => 1.80,
    "BQ" => 1.50,
    "BA" => 2.00,
    "BW" => 1.50,
    "BV" => 0.00,
    "BR" => 4.00,
    "IO" => 1.00,
    "BN" => 3.00,
    "BG" => 3.00,
    "BF" => 1.00,
    "BI" => 1.00,
    "CV" => 1.00,
    "KH" => 1.50,
    "CM" => 1.20,
    "CA" => 14.00,
    "KY" => 2.00,
    "CF" => 1.00,
    "TD" => 1.00,
    "CL" => 3.00,
    "CN" => 3.00,
    "CX" => 1.00,
    "CC" => 1.00,
    "CO" => 3.50,
    "KM" => 1.00,
    "CD" => 1.00,
    "CG" => 1.00,
    "CK" => 1.00,
    "CR" => 3.50,
    "CI" => 1.20,
    "HR" => 3.00,
    "CU" => 1.00,
    "CW" => 1.50,
    "CY" => 4.00,
    "CZ" => 5.00,
    "DK" => 9.00,
    "DJ" => 1.00,
    "DM" => 1.50,
    "DO" => 2.80,
    "EC" => 2.50,
    "EG" => 1.80,
    "SV" => 2.00,
    "GQ" => 1.00,
    "ER" => 1.00,
    "EE" => 3.00,
    "SZ" => 1.00,
    "ET" => 1.00,
    "FK" => 0.00,
    "FO" => 2.00,
    "FJ" => 1.50,
    "FI" => 8.00,
    "FR" => 9.00,
    "GF" => 2.00,
    "PF" => 2.00,
    "TF" => 0.00,
    "GA" => 1.00,
    "GM" => 1.00,
    "GE" => 2.00,
    "DE" => 15.00,
    "GH" => 1.50,
    "GI" => 2.00,
    "GR" => 4.00,
    "GL" => 1.50,
    "GD" => 1.50,
    "GP" => 2.00,
    "GU" => 2.00,
    "GT" => 2.00,
    "GG" => 2.00,
    "GN" => 1.00,
    "GW" => 1.00,
    "GY" => 1.50,
    "HT" => 1.00,
    "HM" => 0.00,
    "VA" => 0.00,
    "HN" => 2.00,
    "HK" => 7.00,
    "HU" => 4.00,
    "IS" => 5.00,
    "IN" => 3.00,
    "ID" => 3.00,
    "IR" => 2.50,
    "IQ" => 1.50,
    "IE" => 12.00,
    "IM" => 2.00,
    "IL" => 8.00,
    "IT" => 6.00,
    "JM" => 2.50,
    "JP" => 10.00,
    "JE" => 2.00,
    "JO" => 3.00,
    "KZ" => 2.50,
    "KE" => 2.00,
    "KI" => 1.00,
    "KP" => 0.00,
    "KR" => 8.00,
    "KW" => 6.00,
    "KG" => 1.50,
    "LA" => 1.50,
    "LV" => 4.00,
    "LB" => 2.50,
    "LS" => 1.00,
    "LR" => 1.00,
    "LY" => 1.50,
    "LI" => 4.00,
    "LT" => 4.00,
    "LU" => 6.00,
    "MO" => 2.50,
    "MK" => 2.00,
    "MG" => 1.00,
    "MW" => 1.00,
    "MY" => 5.00,
    "MV" => 2.50,
    "ML" => 1.00,
    "MT" => 5.00,
    "MH" => 1.00,
    "MQ" => 2.00,
    "MR" => 1.00,
    "MU" => 3.00,
    "YT" => 1.00,
    "MX" => 6.00,
    "FM" => 1.00,
    "MD" => 2.00,
    "MC" => 4.00,
    "MN" => 2.00,
    "ME" => 2.00,
    "MS" => 1.50,
    "MA" => 2.00,
    "MZ" => 1.00,
    "MM" => 1.20,
    "NA" => 2.00,
    "NR" => 1.00,
    "NP" => 2.00,
    "NL" => 11.00,
    "NC" => 2.00,
    "NZ" => 12.00,
    "NI" => 2.00,
    "NE" => 1.00,
    "NG" => 2.50,
    "NU" => 1.00,
    "NF" => 1.00,
    "MP" => 1.50,
    "NO" => 13.00,
    "OM" => 4.00,
    "PK" => 2.50,
    "PW" => 1.00,
    "PS" => 2.00,
    "PA" => 3.00,
    "PG" => 1.00,
    "PY" => 2.00,
    "PE" => 3.00,
    "PH" => 2.00,
    "PN" => 0.00,
    "PL" => 6.00,
    "PT" => 7.00,
    "PR" => 5.00,
    "QA" => 5.00,
    "RE" => 2.00,
    "RO" => 4.00,
    "RU" => 3.00,
    "RW" => 1.00,
    "BL" => 1.50,
    "SH" => 1.00,
    "KN" => 1.50,
    "LC" => 1.50,
    "MF" => 1.50,
    "PM" => 1.00,
    "VC" => 1.50,
    "WS" => 1.00,
    "SM" => 3.00,
    "ST" => 1.00,
    "SA" => 7.00,
    "SN" => 1.00,
    "RS" => 2.00,
    "SC" => 1.50,
    "SL" => 1.00,
    "SG" => 8.00,
    "SX" => 1.50,
    "SK" => 4.00,
    "SI" => 4.00,
    "SB" => 1.00,
    "SO" => 1.00,
    "ZA" => 4.00,
    "GS" => 0.00,
    "SS" => 1.00,
    "ES" => 8.00,
    "LK" => 2.00,
    "SD" => 1.00,
    "SR" => 1.00,
    "SJ" => 1.00,
    "SE" => 12.00,
    "CH" => 10.00,
    "SY" => 1.00,
    "TW" => 6.00,
    "TJ" => 1.00,
    "TZ" => 1.00,
    "TH" => 4.00,
    "TL" => 1.00,
    "TG" => 1.00,
    "TK" => 1.00,
    "TO" => 1.00,
    "TT" => 2.00,
    "TN" => 2.00,
    "TR" => 5.00,
    "TM" => 1.00,
    "TV" => 1.00,
    "UG" => 1.00,
    "UA" => 3.00,
    "AE" => 10.00,
    "GB" => 15.00,
    "US" => 16.00,
    "UY" => 3.00,
    "UZ" => 1.50,
    "VU" => 1.00,
    "VE" => 2.50,
    "VN" => 3.00,
    "EH" => 1.00,
    "YE" => 1.00,
    "ZM" => 1.00,
    "ZW" => 1.00,

];



// --- Instagram-specific niches and RPMs (deep research, all possible) ---
$instagram_niche_rpm = [
    // High RPM Niches
    "Finance & Investing" => 25.0,
    "Stock Market & Trading" => 23.0,
    "Business / SEO / Blogging" => 20.0,
    "Making Money Online" => 18.0,
    "Real Estate" => 19.0,
    "Law / Legal Commentary" => 18.0,
    "Insurance" => 16.0,
    "Credit Cards & Loans" => 15.0,
    "Investments & Crypto" => 18.0,
    "Digital Marketing" => 14.0,
    "Affiliate Marketing" => 13.0,
    "Dropshipping & Ecommerce" => 12.0,
    "SaaS & Software Reviews" => 11.0,
    "Tech Reviews & Gadgets" => 10.0,
    "Productivity & Tech Tutorials" => 9.0,
    "Web Development" => 8.0,
    "Coding & Programming" => 10.0,
    "AI & Machine Learning" => 12.0,
    "Online Education / Study Tips" => 9.0,
    "Science & Technology" => 8.0,
    "Motivation & Philosophy" => 7.0,
    "Career & Professional Development" => 8.0,
    "Job Interview Tips" => 7.0,
    "Test Preparation" => 6.0,
    "Language Learning" => 7.0,
    "True Crime" => 8.0,
    "History" => 7.0,
    // Medium RPM Niches
    "Health & Fitness" => 7.0,
    "Weight Loss & Diet" => 8.0,
    "Yoga & Meditation" => 7.0,
    "Bodybuilding" => 7.0,
    "Sports" => 6.0,
    "Automotive" => 6.0,
    "Car Reviews" => 7.0,
    "Automotive Repairs" => 6.0,
    "Street Racing" => 6.0,
    "Travel & Lifestyle" => 8.0,
    "Luxury Travel" => 9.0,
    "Budget Travel" => 7.0,
    "Travel Guides" => 8.0,
    "Food & Cooking" => 5.0,
    "Restaurant Reviews" => 5.0,
    "Street Food" => 5.0,
    "Cooking Challenges" => 5.0,
    "Home Decor & Organization" => 5.0,
    "DIY & Crafts" => 5.0,
    "Gardening & Homesteading" => 4.0,
    "Parenting & Family" => 4.0,
    "Parenting Tips" => 4.0,
    "Kids' Content" => 4.0,
    "Pets & Animals" => 5.0,
    "Pet Training" => 5.0,
    "Funny Animals" => 4.0,
    "Book Reviews & Literature" => 4.0,
    "Book Summaries" => 4.0,
    "Animation & Motion Graphics" => 4.0,
    "Educational Content" => 8.0,
    "Science Experiments" => 6.0,
    "Howto & Style" => 5.0,
    "Travel Vlogs" => 6.0,
    "Product Reviews" => 6.0,
    "Unboxing" => 5.0,
    "Life Hacks & Productivity" => 6.0,
    "Motivation & Self-Improvement" => 7.0,
    "Study With Me" => 6.0,
    "Minimalism & Organization" => 5.0,
    "Sustainable Living & Eco-Friendly" => 5.0,
    "Home Improvement & Renovation" => 6.0,
    "Interior Design" => 6.0,
    "Sewing & Crafts" => 5.0,
    "Building & Construction" => 6.0,
    "Fashion" => 8.0,
    "Fashion Try-ons & Hauls" => 8.0,
    "Beauty & Makeup" => 10.0,
    "Shopping Hauls" => 7.0,
    "Minimalism & Organization" => 6.0,
    "Sustainable Living & Eco-Friendly" => 5.0,
    "Interior Design" => 6.0,
    "Home Improvement & Renovation" => 6.0,
    // Lower RPM Niches
    "Music" => 3.0,
    "Educational Music" => 3.5,
    "Gaming" => 4.0,
    "Mobile Gaming" => 3.0,
    "Grand Theft Auto / Open World Gaming" => 4.0,
    "Esports" => 4.0,
    "Fantasy Sports" => 4.0,
    "Comedy & Skits" => 3.0,
    "Comedy" => 3.0,
    "Entertainment" => 3.0,
    "People & Blogs" => 3.0,
    "Vlogging / Lifestyle" => 4.0,
    "Reactions, Skits, Commentary" => 3.0,
    "Short Movies" => 3.0,
    "Film & Animation" => 4.0,
    "News & Politics" => 3.0,
    "Nonprofits & Activism" => 2.0,
    "Shows" => 3.0,
    "Movies" => 3.0,
    "General / No Niche" => 2.0,
    "Viral Challenges" => 3.0,
    "Pranks" => 3.0,
    "Reaction Videos" => 3.0,
    "Movie & TV Reviews" => 4.0,
    "Movie/TV Show Analysis" => 4.0,
    "Animation Tutorials" => 4.0,
    "Instagram Growth" => 6.0,
    "YouTube Shorts" => 3.0,
 "Cryptocurrency & NFTs" => 15.0,
"Social Media Marketing" => 12.0,
"Personal Finance" => 20.0,
"Online Courses & Digital Products" => 13.0,
"Photography Tutorials" => 8.0,
"Smart Home & Gadgets" => 10.0,
"Software & App Reviews" => 11.0,
"Legal Advice & Law Tips" => 17.0,
"Luxury Lifestyle" => 12.0,
"Entrepreneurship" => 14.0,

// Additional Medium RPM Niches
"Mental Health & Self-Care" => 7.0,
"Vegan & Plant-Based Living" => 6.0,
"Pet Care & Training" => 6.0,
"Home Organization" => 5.0,
"Art & Illustration" => 6.0,
"Astrology & Spirituality" => 5.0,
"Event Planning" => 7.0,
"Minimalism" => 6.0,
"College & Student Life" => 5.0,
"Disability & Accessibility" => 5.0,
"Parenting (Special Needs)" => 7.0,
"Bookstagram (Books)" => 5.0,
"Adventure Sports" => 8.0,
"DIY Home Renovation" => 7.0,
"Gardening" => 5.0,
"Vintage/Retro Lifestyle" => 6.0,
"Language Learning" => 7.0,
"Local/Regional Food" => 6.0,

// Additional Lower RPM Niches
"Memes & Viral Content" => 3.0,
"Meme Pages" => 3.0,
"Fan Pages" => 2.0,
"Horoscopes" => 3.0,
"Street Photography" => 4.0,
"Reaction Memes" => 3.0,
"General Vlogs" => 3.0,
"Street Interviews" => 3.0,
"Fandoms & Pop Culture" => 3.0,
"ASMR" => 3.0,
"Unusual Hobbies" => 3.0,
"Local News" => 2.0,
];
$instagram_niches = array_keys($instagram_niche_rpm);

function get_rpm($country_code, $niche) {
    global $country_rpm, $instagram_niche_rpm;
    $country_val = $country_rpm[$country_code] ?? ($country_rpm["default"] ?? 0);
    $niche_val = $instagram_niche_rpm[$niche] ?? ($instagram_niche_rpm["Other"] ?? 0);
    return round(($country_val + $niche_val) / 2, 2);
}

// AJAX handler (same as template, adapted for Instagram)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    global $instagram_niche_rpm;
    $views = isset($_POST['ig_views']) ? (int)$_POST['ig_views'] : 0;
    $country = $_POST['ig_country'] ?? 'US';
    $niche = isset($_POST['ig_niche']) ? htmlspecialchars_decode($_POST['ig_niche']) : 'Other';
    $country_val = $country_rpm[$country] ?? ($country_rpm["default"] ?? 0.5);
    $niche_val = $instagram_niche_rpm[$niche] ?? $instagram_niche_rpm["Other"];
    $rpm = round(max(($country_val + $niche_val) / 2, 0.1), 2);
    $estimated_earnings = ($views / 1000) * $rpm;
    $results = [
        'views' => number_format($views),
        'country' => $countries[$country] ?? htmlspecialchars($country),
        'niche' => $niche,
        'rpm' => '$' . number_format($rpm, 2),
        'earnings' => '$' . number_format($estimated_earnings, 2)
    ];
    ?>
    <div class="result-card">
      <div class="result-meta">Estimated Monthly Instagram Earnings</div>
      <div class="result-earnings"><?= $results['earnings'] ?></div>
      <div class="result-details">
        <div class="result-row">
          <span class="result-label">Monthly Views</span>
          <span class="result-value"><?= $results['views'] ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Country</span>
          <span class="result-value"><?= htmlspecialchars($results['country']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Niche</span>
          <span class="result-value"><?= htmlspecialchars($results['niche']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Estimated RPM</span>
          <span class="result-value"><?= $results['rpm'] ?></span>
        </div>
      </div>
    </div>
    <?php
    exit;
}

include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';
?>


<html>
    <head>
        
          <link rel="stylesheet" href="/assets/css/plugins.css" />
  <link rel="stylesheet" href="/assets/css/base.css" />


  <link rel="stylesheet" href="/assets/css/style.css" />
  <link rel="preload" href="/assets/css/fonts/space.css" as="style" onload="this.rel='stylesheet'" />  
        
        <style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* TikTok Calculator Form Inputs and Button */
form#ig-money-form input.form-control,
form#ig-money-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#ig-money-form button#ig-money-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}

/* Result Card Styling */
.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}
.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}
.result-meta {
  font-weight: bold;
  font-size: 1.3rem;
  color: #2a3a5c;
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0;
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}
.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}
.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}
.result-label {
  font-weight: 700;
  color: #2a3a5c;
}
.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive adjustments */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
  #modal-loader-overlay {
    /* Ensure loader covers full viewport on mobile */
    align-items: center;
    justify-content: center;
  }
}

/* Feature checklist styling */
.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}
.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}
.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}
@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;
  overflow-wrap: break-word;
  white-space: normal;
}
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem;
  text-align: center;
}
</style>

        
    </head>
    
    
<body>
<div class="content-wrapper">

  <!-- Loader Overlay -->
  <div id="modal-loader-overlay">
    <div class="loader-content">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
      <span class="loader-text">Calculating Revenue...</span>
    </div>
  </div>

  <!-- HERO + CALCULATOR FORM -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">

         <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
          Instagram Money Calculator <span class="underline-3 style-1 primary"></span>
        </h1>
        <h3 class="lead fs-20 lh-sm mb-4 mt-5">
          Discover your true Instagram earning potential with the most advanced, accurate, and creator-focused Instagram Money Calculator. Instantly estimate your monthly income from views, followers, and engagement—customized for every country and niche. No sign-up, no guesswork, just real numbers.
        </h3>

          <form id="ig-money-form" method="POST" action="#">
            <div class="row g-3 align-items-center">
              <div class="col-md-4 mb-3 mb-md-0">
                <input
                  type="number"
                  class="form-control"
                  id="ig_views"
                  name="ig_views"
                  placeholder="Monthly Views"
                  min="0"
                  required
                  value="<?= isset($_POST['ig_views']) ? htmlspecialchars($_POST['ig_views']) : '' ?>"
                >
                <small class="form-text text-muted">Enter your average monthly Instagram views</small>
              </div>
              <div class="col-md-4 mb-3 mb-md-0">
                <select class="form-control" id="ig_country" name="ig_country" required>
                  <?php foreach ($countries as $code => $name): ?>
                    <option value="<?= htmlspecialchars($code) ?>" <?= (isset($_POST['ig_country']) && $_POST['ig_country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Select your audience country</small>
              </div>
              <div class="col-md-4">
                <select class="form-control" id="ig_niche" name="ig_niche" required>
                  <?php foreach ($instagram_niches as $n): ?>
                    <option value="<?= htmlspecialchars($n, ENT_QUOTES, 'UTF-8') ?>" <?= (isset($_POST['ig_niche']) && $_POST['ig_niche'] == $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Choose your Instagram content niche</small>
              </div>
            </div>
            <div class="mt-4"></div>
            <button
              class="btn mt-4"
              type="submit"
              id="ig-money-btn"
            >
              Calculate Earnings
            </button>
          </form>

          <div id="ig-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite"></div>

        </div>
      </div>
    </div>
  </section>

  <!-- PROCESS STEPS (CTA) -->
 <section class="wrapper">
  <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
    <h2 class="display-4 mb-3">How to Calculate Your Instagram Earnings: Step by Step</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6 process-wrapper line mt-5">
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">01</span></span>
        <h4 class="mb-1">Input Your Instagram Stats</h4>
        <p class="mb-0">Enter your average monthly Instagram views, select your country, and choose your content niche. The more accurate your stats, the more precise your earnings estimate will be.</p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-primary pe-none mb-4"><span class="number">02</span></span>
        <h4 class="mb-1">Calculate Your Earnings</h4>
        <p class="mb-0">Click the calculate button to instantly reveal your estimated monthly Instagram ad revenue, based on the latest RPM and CPM data for your country and niche.</p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">03</span></span>
        <h4 class="mb-1">Plan, Optimize & Grow</h4>
        <p class="mb-0">Use your insights to set realistic goals, optimize your content strategy, and unlock new monetization streams—whether you’re a micro-influencer or a global brand.</p>
      </div>
    </div>
  </div>
</section>

<section class="wrapper">
  <div class="container pt-2 pb-5 text-center">
    <p class="lead fs-18 lh-sm mb-4">
      Whether you're a creator, marketer, or brand, our Instagram Money Calculator gives you a realistic estimate of your earning potential. Analyze your audience, engagement, and niche to plan your next viral move!
    </p>
    <div class="row justify-content-center">
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Accurate RPMs &amp; CPMs for every Instagram niche and country</li>
          <li>Mobile-friendly, fast, and secure—no login required</li>
          <li>Actionable tips to boost your Instagram earnings</li>
          <li>SEO-optimized for creators and influencers</li>
          <li>Instant results with no signup required</li>
        </ul>
      </div>
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Works for all follower counts and engagement rates</li>
          <li>Easy to use on any device, anytime</li>
          <li>Updated regularly with the latest Instagram RPM data</li>
          <li>Completely free, no hidden fees</li>
          <li>Trusted by Instagrammers and brands worldwide</li>
        </ul>
      </div>
    </div>
    <div class="alert alert-success p-4 fs-17 mt-4">
      <strong>Ready to unlock your Instagram earning power?</strong> Enter your stats and see how much you could make today!
    </div>
  </div>
</section>

<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">Why Estimate Your Instagram Earnings?</h2>
    <p class="lead fs-18 lh-sm mb-7">
      Knowing your potential Instagram earnings is more than just curiosity—it’s a strategic advantage. Whether you’re a new creator or an established influencer, understanding your revenue helps you set realistic goals, plan your content calendar, and unlock new monetization opportunities.
    </p>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Set Financial Goals</h5>
          <p class="mb-0">Forecast your monthly and yearly income to plan investments in equipment, marketing, or team expansion. Knowing your numbers gives you the confidence to negotiate better rates and invest in your growth.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Understand Your Niche</h5>
          <p class="mb-0">Different Instagram niches have different RPMs and brand deal rates. Use the calculator to see how your topic and audience location affect your revenue, and identify high-paying niches for future growth.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Explore New Streams</h5>
          <p class="mb-0">Add extra revenue sources like brand deals, affiliate links, and merchandise to maximize your Instagram earning power. The calculator helps you estimate the impact of each stream on your total income.</p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Pro Tip:</strong> Creators in finance, tech, and education niches often earn higher RPMs and brand deals. Focus on high-engagement content and audience retention to boost your revenue.
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper" style="background-color:#f5faff;color:#23272b;">
  <div class="container py-7">
    <h2 class="display-6 mb-5 text-center" style="color:#212121;">Real Instagrammers, Real Results</h2>
    <div class="row gx-5 gy-4 justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “This calculator helped me price my first brand deal. The RPM data is spot-on, and I love the niche breakdown. Highly recommended!”
          </p>
          <div class="fw-bold" style="color:#2586f7;">– Sofia, Travel Blogger</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
          </div>
          <p>
            “I use the Instagram Money Calculator before every negotiation. It’s easy, accurate, and the country RPMs make a huge difference.”
          </p>
          <div class="fw-bold" style="color:#2586f7;">– Raj, Fitness Creator</div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “As a micro-influencer, understanding my value was tough. This tool gave me the confidence to pitch to brands and grow my income.”
          </p>
          <div class="fw-bold" style="color:#2586f7;">– Lina, Beauty Influencer</div>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
    <h2 class="display-4 mb-3">Tips to Maximize Your Instagram Earnings</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="uil uil-check"></i><strong>Focus on High-CPM Niches:</strong> Finance, tech, and beauty creators earn more per view. If you’re passionate about a high-paying topic, double down on it.</li>
          <li><i class="uil uil-check"></i><strong>Boost Engagement:</strong> Respond to comments, use trending hashtags, and encourage shares. High engagement signals value to both the Instagram algorithm and potential sponsors.</li>
          <li><i class="uil uil-check"></i><strong>Post Consistently:</strong> Regular uploads keep your audience engaged and attract more followers. Consistency is key for both growth and monetization.</li>
          <li><i class="uil uil-check"></i><strong>Collaborate with Others:</strong> Partner with other creators to expand your reach and audience. Cross-promotions and shoutouts can introduce you to new, relevant followers.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="uil uil-check"></i><strong>Leverage Instagram Stories & Reels:</strong> Use short-form video for higher reach and engagement. Instagram prioritizes Reels and Stories in the feed, so use them to boost your visibility.</li>
          <li><i class="uil uil-check"></i><strong>Negotiate Brand Deals:</strong> Use your earnings estimate to pitch higher rates to brands. Show them your stats and calculator results for proof of value.</li>
          <li><i class="uil uil-check"></i><strong>Track Analytics:</strong> Monitor your engagement and audience stats to optimize your content. Use Instagram Insights and third-party tools to spot trends and tweak your strategy.</li>
          <li><i class="uil uil-check"></i><strong>Stay Updated:</strong> Follow Instagram trends and platform updates to stay ahead. The algorithm and monetization options change often—stay informed to maximize your results.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Did you know?</strong> Instagram creators can earn from ad revenue, brand deals, affiliate links, and more. The more you diversify, the higher your total income!
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-gradient-primary">
  <div class="container pt-10 pt-md-12">
    <h2 class="display-4 mb-3">Frequently Asked Questions</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-lg-6 text-start">
        <div class="accordion accordion-wrapper" id="faqAccordionLeft">
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading1">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
                How does the Instagram Money Calculator work?
              </button>
            </div>
            <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>Our calculator estimates your Instagram earnings based on your monthly views, country, and niche. It uses up-to-date RPM rates and engagement data to generate a realistic income projection. RPM (Revenue Per Mille) is calculated for your specific country and niche, so you get the most accurate result possible.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading2">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
                What is RPM on Instagram?
              </button>
            </div>
            <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>RPM (Revenue Per Mille) is the estimated earnings per 1,000 views. On Instagram, RPM varies by country, niche, and engagement rate, and is typically higher for sponsored content than for ad revenue alone.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading3">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
                How much can I earn per 1,000 views on Instagram?
              </button>
            </div>
            <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>Most creators earn between $0.20 and $2.00 per 1,000 views from Instagram ad revenue, but sponsored content can pay $10–$50+ per 1,000 views in premium niches. Your actual earnings will depend on your audience’s country, your niche, and your engagement rate. Use the calculator above for a personalized estimate.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading4">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
                What factors affect my Instagram earnings?
              </button>
            </div>
            <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>Your niche, audience country, engagement rate, and video quality all impact your earnings. Brand deals, affiliate links, and product sales can also significantly increase your income. High-engagement, niche-focused accounts in top countries earn the most.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading5">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
                Can I earn money on Instagram without brand deals?
              </button>
            </div>
            <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>Yes! Many creators earn through affiliate marketing, digital products, and ad revenue from Reels and Stories, even without direct brand sponsorships. Instagram’s monetization tools are expanding every year, making it easier to earn from your content.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading6">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
                How do I increase my Instagram earnings?
              </button>
            </div>
            <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordionLeft">
              <div class="card-body">
                <p>Focus on high-engagement content, collaborate with other creators, post consistently, and pitch your stats to brands for sponsored deals. Diversify your income streams for best results. Track your analytics and optimize your posting times for maximum reach.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--/col-->
      <div class="col-lg-6 text-start">
        <div class="accordion accordion-wrapper" id="faqAccordionRight">
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading7">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
                Is this calculator free to use?
              </button>
            </div>
            <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordionRight">
              <div class="card-body">
                <p>Yes, our Instagram Money Calculator is 100% free and always will be. No sign-up, no hidden fees. Use it as often as you like to estimate your earnings or plan your next campaign.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading8">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
                Can I use this calculator for brand deals?
              </button>
            </div>
            <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordionRight">
              <div class="card-body">
                <p>Absolutely! Use your earnings estimate to negotiate better rates for sponsored posts and collaborations. Brands appreciate data-driven proposals, and showing your RPM and estimated earnings can help you secure higher payouts.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading9">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
                What is the best Instagram niche for high earnings?
              </button>
            </div>
            <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordionRight">
              <div class="card-body">
                <p>Finance, business, tech, beauty, fashion, and travel are among the highest-paying Instagram niches, especially when paired with audiences in high-CPM countries like the US, UK, and Australia. If you’re considering a new account or pivoting your content, these niches offer the best earning potential.</p>
              </div>
            </div>
          </div>
          <div class="card plain accordion-item">
            <div class="card-header" id="faqHeading10">
              <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse10" aria-expanded="false" aria-controls="faqCollapse10">
                Where can I learn more about Instagram monetization?
              </button>
            </div>
            <div id="faqCollapse10" class="accordion-collapse collapse" aria-labelledby="faqHeading10" data-bs-parent="#faqAccordionRight">
              <div class="card-body">
                <p>Check out our blog for guides on Instagram monetization, influencer marketing, and social media growth strategies. We regularly publish case studies, algorithm updates, and tips for maximizing your Instagram income.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--/col-->
    </div>
    <!--/.row -->
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Still have questions?</strong> Reach out to our team at any time. We’re here to help you succeed on Instagram!
        </div>
      </div>
    </div>
  </div>
</section>
</div>

</body>
</html>

<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
  var form = document.getElementById('ig-money-form');
  var loader = document.getElementById('modal-loader-overlay');
  var results = document.getElementById('ig-results-area');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      if (loader) loader.style.display = 'flex';
      if (results) results.innerHTML = '';
      var formData = new FormData(form);
      formData.append('ajax', '1');
      fetch(form.action, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.text())
      .then(html => {
        setTimeout(function() {
          if (loader) loader.style.display = 'none';
          results.innerHTML = html;
          results.style.display = 'flex';
        }, 2500);
      })
      .catch(function() {
        if (loader) loader.style.display = 'none';
        if (results) results.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
      });
    });
  }
});
</script>
