<?php
session_start();

$converted_dir = __DIR__ . '/gif-jpg-converted/';
$converted_url = '/tools/image-convertor/convert-to-jpg/gif-jpg-converted/';
if (!is_dir($converted_dir)) mkdir($converted_dir, 0777, true);

$conversion_result = '';
$compression_level_label = '';
$selected_compression_level = 'auto';
$disable_file_input = false;
$orig_img_url = '';
$orig_size = 0;
$orig_ext = '';
$orig_mime = '';

// Helper: Human-readable compression level
function getCompressionLevelLabel($level) {
    switch ($level) {
        case 'high': return 'High';
        case 'medium': return 'Medium';
        case 'low': return 'Low';
        default: return 'Auto (Recommended)';
    }
}

// --- Download handler: serve file if ?download=filename is set ---
if (isset($_GET['download'])) {
    $file = basename($_GET['download']);
    if (!preg_match('/^gifjpg_[a-zA-Z0-9]+\.jpg$/', $file) && !preg_match('/^gifjpg_[a-zA-Z0-9]+_originalsize\.jpg$/', $file)) {
        http_response_code(400);
        die('Invalid file name.');
    }
    $filepath = $converted_dir . $file;
    if (!file_exists($filepath)) {
        http_response_code(404);
        die('File not found.');
    }
    header('Content-Description: File Transfer');
    header('Content-Type: image/jpeg');
    header('Content-Disposition: attachment; filename="' . $file . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($filepath));
    flush();
    readfile($filepath);
    exit;
}

// --- HANDLE POST: Convert and Redirect ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $max_size = 6 * 1024 * 1024; // 6MB
    $compression_level = $_POST['compression_level'] ?? 'auto';
    $compression_level_label = getCompressionLevelLabel($compression_level);
    $selected_compression_level = $compression_level;
    $success = false;
    $unique_id = uniqid('gifjpg_');
    $download_name = '';
    $converted_file_path = '';
    $converted_img_url = '';
    $orig_size = 0;

    // If new file uploaded, handle upload and store path in session
    if (isset($_FILES['image_file']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['image_file'];
        if ($file['size'] > $max_size) {
            $_SESSION['conversion_result'] = '<div class="alert alert-danger">File too large. Maximum size is 6MB.</div>';
        } else {
            $img_info = getimagesize($file['tmp_name']);
            $mime = $img_info['mime'];
            if ($mime === 'image/gif') {
                $orig_ext = '.gif';
                $orig_name = $unique_id . '_orig' . $orig_ext;
                $orig_path = $converted_dir . $orig_name;
                move_uploaded_file($file['tmp_name'], $orig_path);
                $_SESSION['uploaded_gif_path'] = $orig_path;
                $_SESSION['uploaded_gif_url']  = $converted_url . $orig_name;
                $_SESSION['uploaded_gif_size'] = filesize($orig_path);
                $_SESSION['uploaded_gif_mime'] = $mime;
                $orig_img_url = $_SESSION['uploaded_gif_url'];
                $orig_size = $_SESSION['uploaded_gif_size'];
                $orig_mime = $mime;
                $disable_file_input = false;
            } else {
                $_SESSION['conversion_result'] = '<div class="alert alert-danger">Only GIF images are supported for this tool.</div>';
            }
        }
    }
    // If user changed compression level after upload, reuse previous file
    elseif (isset($_SESSION['uploaded_gif_path']) && file_exists($_SESSION['uploaded_gif_path'])) {
        $orig_path = $_SESSION['uploaded_gif_path'];
        $orig_img_url = $_SESSION['uploaded_gif_url'];
        $orig_size = $_SESSION['uploaded_gif_size'];
        $orig_mime = $_SESSION['uploaded_gif_mime'];
        $orig_ext = '.gif';
        $disable_file_input = false;
    }

    // If we have a valid original file, proceed to convert
    if (!empty($orig_path) && file_exists($orig_path)) {
        $download_name = $unique_id . '.jpg';
        $converted_file_path = $converted_dir . $download_name;

        // Compression level for JPG (0 = best quality/largest, 100 = worst quality/smallest)
        $jpg_quality = ($compression_level === 'high') ? 60 : (($compression_level === 'medium') ? 75 : 90);
        if ($compression_level === 'auto') $jpg_quality = 75;

        // Convert GIF to JPG (static: first frame only)
        $img = imagecreatefromgif($orig_path);
        $bg = imagecreatetruecolor(imagesx($img), imagesy($img));
        // White background for transparency
        $white = imagecolorallocate($bg, 255, 255, 255);
        imagefill($bg, 0, 0, $white);
        imagecopy($bg, $img, 0, 0, 0, imagesx($img), imagesy($img));
        $success = imagejpeg($bg, $converted_file_path, $jpg_quality);
        imagedestroy($img);
        imagedestroy($bg);

        $converted_size = filesize($converted_file_path);
        $converted_img_url = $converted_url . $download_name;
        $percent = $orig_size > 0 ? round(100 - ($converted_size / $orig_size * 100), 1) : 0;

        // If converted is larger, re-save original as JPG at best quality and explain
        if ($converted_size >= $orig_size) {
            $alt_download_name = $unique_id . '_originalsize.jpg';
            $img = imagecreatefromgif($orig_path);
            $bg = imagecreatetruecolor(imagesx($img), imagesy($img));
            $white = imagecolorallocate($bg, 255, 255, 255);
            imagefill($bg, 0, 0, $white);
            imagecopy($bg, $img, 0, 0, 0, imagesx($img), imagesy($img));
            imagejpeg($bg, $converted_dir . $alt_download_name, 100);
            imagedestroy($img);
            imagedestroy($bg);
            $_SESSION['conversion_result'] = '
            <div class="result-card main-result-card">
              <div class="result-meta">GIF to JPG Conversion Results</div>
              <div class="row gx-3 gy-3 align-items-center justify-content-center mb-3 flex-wrap result-img-row">
                <div class="col-12 col-md-6 text-center mb-2 mb-md-0">
                  <div class="img-preview-label">Original (GIF)</div>
                  <img src="'.htmlspecialchars($orig_img_url).'" class="img-fluid img-preview" alt="Original GIF" style="max-width:180px;max-height:180px;border-radius:10px;border:1px solid #eee;">
                </div>
                <div class="col-12 col-md-6 text-center">
                  <div class="img-preview-label">Converted (JPG)</div>
                  <img src="'.htmlspecialchars($converted_img_url).'" class="img-fluid img-preview" alt="Converted JPG" style="max-width:180px;max-height:180px;border-radius:10px;border:1px solid #eee;">
                </div>
              </div>
              <div class="result-details">
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Compression Level</span>
                  <span class="result-value">'.htmlspecialchars($compression_level_label).'</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Original Size</span>
                  <span class="result-value">'.number_format($orig_size/1024, 2).' KB</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Converted Size</span>
                  <span class="result-value">'.number_format($converted_size/1024, 2).' KB</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Reduction</span>
                  <span class="result-value">0%</span>
                </div>
              </div>
              <div class="alert alert-info mt-3 mb-0">
                <strong>No further compression possible.</strong> The converted JPG is larger than the original GIF. Downloaded JPG is saved at original GIF size and quality.
              </div>
              <a href="?download='.urlencode($alt_download_name).'" class="btn btn-primary mt-3">Download JPG (Original Size)</a>
            </div>';
        } else {
            $_SESSION['conversion_result'] = '
            <div class="result-card main-result-card">
              <div class="result-meta">GIF to JPG Conversion Results</div>
              <div class="row gx-3 gy-3 align-items-center justify-content-center mb-3 flex-wrap result-img-row">
                <div class="col-12 col-md-6 text-center mb-2 mb-md-0">
                  <div class="img-preview-label">Original (GIF)</div>
                  <img src="'.htmlspecialchars($orig_img_url).'" class="img-fluid img-preview" alt="Original GIF" style="max-width:180px;max-height:180px;border-radius:10px;border:1px solid #eee;">
                </div>
                <div class="col-12 col-md-6 text-center">
                  <div class="img-preview-label">Converted (JPG)</div>
                  <img src="'.htmlspecialchars($converted_img_url).'" class="img-fluid img-preview" alt="Converted JPG" style="max-width:180px;max-height:180px;border-radius:10px;border:1px solid #eee;">
                </div>
              </div>
              <div class="result-details">
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Compression Level</span>
                  <span class="result-value">'.htmlspecialchars($compression_level_label).'</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Original Size</span>
                  <span class="result-value">'.number_format($orig_size/1024, 2).' KB</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Converted Size</span>
                  <span class="result-value">'.number_format($converted_size/1024, 2).' KB</span>
                </div>
                <div class="result-row flex-column flex-md-row text-center text-md-start">
                  <span class="result-label">Reduction</span>
                  <span class="result-value">'.$percent.'%</span>
                </div>
              </div>
              <a href="?download='.urlencode($download_name).'" class="btn btn-primary mt-3">Download JPG</a>
            </div>';
        }
    } elseif (!isset($_SESSION['conversion_result'])) {
        $_SESSION['conversion_result'] = '<div class="alert alert-danger">Conversion failed. Please try another GIF image.</div>';
    }
    $_SESSION['compression_level'] = $compression_level;
    header("Location: ".$_SERVER['REQUEST_URI']);
    exit;
}

// On GET, show results only if they exist in session, then clear them
if (isset($_SESSION['conversion_result'])) {
    $conversion_result = $_SESSION['conversion_result'];
    unset($_SESSION['conversion_result']);
    if (isset($_SESSION['uploaded_gif_url'])) {
        $orig_img_url = $_SESSION['uploaded_gif_url'];
        $disable_file_input = false;
    }
    if (isset($_SESSION['compression_level'])) {
        $selected_compression_level = $_SESSION['compression_level'];
    }
} else {
    $conversion_result = '';
    $disable_file_input = false;
    $orig_img_url = '';
}

// SEO Meta
$page_title = "Convert GIF to JPG Instantly – Free Online GIF to JPG Converter";
$page_description = "Convert GIF images to JPG online in seconds. Transform your GIFs to high-quality JPGs for web, design, or print. No watermark, unlimited use, works on any device. Fast, free, and secure GIF to JPG conversion.";
$page_keywords = "GIF to JPG, convert GIF to JPG, online image converter, GIF to JPG tool, free GIF to JPG converter, lossless GIF conversion, web image optimization, batch GIF to JPG, fast GIF to JPG converter";

include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title><?= htmlspecialchars($page_title) ?></title>
    <meta name="description" content="<?= htmlspecialchars($page_description) ?>">
    <meta name="keywords" content="<?= htmlspecialchars($page_keywords) ?>">
    <link rel="stylesheet" href="/assets/css/plugins.css" />
    <link rel="stylesheet" href="/assets/css/base.css" />
    <link rel="stylesheet" href="/assets/css/style.css" />
    <link rel="preload" href="/assets/css/fonts/space.css" as="style" onload="this.rel='stylesheet'" />
            <style>
/* ================================
   Loader Overlay (Modal Spinner)
   ================================ */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* ================================
   Form Inputs & Button Styling
   ================================ */
form#image-compressor-form input.form-control,
form#image-compressor-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s, box-shadow 0.15s;
}
form#image-compressor-form button#compress-btn {
    display: flex;                   /* Enable flexbox for centering */
    align-items: center;             /* Vertically center content */
    justify-content: center;         /* Horizontally center content */
    height: 54px;
    font-size: 1.15rem;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
    border: none;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    cursor: pointer;
    /* Remove these if present: */
    padding-top: 0;
    padding-bottom: 0;
    padding-left: 0;
    padding-right: 0;
    padding: 0 24px;

}

/* ================================
   Custom File Input Styling
   ================================ */
.file-input-row,
.custom-file-input-wrapper {
    display: flex;
    align-items: center;
    width: 100%;
    max-width: 420px;
    margin: 0 auto 1.5rem auto;
    height: 56px;
    position: relative;
}
.custom-file-input {
    display: none;
}
.custom-file-label {
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px 0 0 6px;
    height: 56px;
    width: 150px;
    font-size: 0.9rem;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    border: none;
    margin: 0;
    text-align: center;
    transition: background 0.2s;
}
.custom-file-label:hover {
    background: linear-gradient(90deg, #6a82fb 0%, #3f78e0 100%);
}
.custom-file-filename {
    background: #f8fafc;
    color: #60697b;
    border-radius: 0 6px 6px 0;
    height: 56px;
    flex: 1 1 0%;
    font-size: 1.08rem;
    display: flex;
    align-items: center;
    padding-left: 18px;
    font-weight: 500;
    border-left: 1px solid #e0eafc;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* ================================
   Custom Select Styling (Matches File Input)
   ================================ */
.custom-select-wrapper {
    width: 100%;
    max-width: 420px;
    margin: 0 auto;
    height: 56px;
}
.custom-select-wrapper select.form-control {
    width: 100%;
    height: 56px;
    font-size: 1.1rem;
    font-weight: 600;
    border-radius: 6px;
    background: #f8fafc;
    color: #60697b;
    border: 1px solid #e0eafc;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    padding-left: 16px;
    padding-right: 16px;
}

/* ================================
   Helper Texts (Under Inputs)
   ================================ */
.custom-form-text,
#image-compressor-form .form-text {
    font-size: 1.08rem !important;
    font-weight: 600;
    color: #3f78e0 !important;
    margin-bottom: 0;
}

/* ================================
   Image Preview Styling
   ================================ */
.img-preview-label {
    font-size: 0.95rem;
    font-weight: 600;
    margin-bottom: 0.5rem;
    color: #3f78e0;
}
.img-preview {
    max-width: 180px;
    max-height: 180px;
    border-radius: 10px;
    border: 1px solid #eee;
}

/* ================================
   Result Card Styling
   ================================ */
.result-card {
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
    max-width: 420px;
    margin: 2rem auto 0 auto;
    padding: 2rem 2rem 1.5rem 2rem;
    display: flex;
    flex-direction: column;
    align-items: center;
    transition: box-shadow 0.2s;
}
.result-card:hover {
    box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-meta {
    font-weight: bold;
    font-size: 1.3rem;
    color: #2a3a5c;
    margin-bottom: 0.75rem;
    padding-bottom: 0.25rem;
    border-bottom: 2px solid #3f78e0;
    letter-spacing: 0.02em;
    text-align: center;
    background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
    border-radius: 6px 6px 0 0;
}
.result-details {
    width: 100%;
    display: flex;
    flex-direction: column;
    gap: 0.7rem;
}
.result-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: #f6fafd;
    border-radius: 9px;
    padding: 1rem 1.2rem;
    box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
    font-size: 1.11rem;
    max-width: 100%;
    word-wrap: break-word;
    overflow-wrap: break-word;
    white-space: normal;
    flex-direction: column;
    align-items: flex-start;
    text-align: left;
}
.result-label {
    font-weight: 700;
    color: #2a3a5c;
    order: 2;
    margin-top: 0.1em;
    font-size: 1em;
}
.result-value {
    font-weight: 500;
    color: #384c6c;
    text-align: right;
    word-break: break-word;
    order: 1;
    font-size: 1.2em;
    font-weight: 700;
    margin-bottom: 0.15em;
}
.result-earnings {
    font-size: 2.2rem;
    font-weight: 800;
    color: #19b34a;
    margin-bottom: 0.25rem;
    text-align: center;
    letter-spacing: -1px;
    word-break: break-all;
    overflow-wrap: break-word;
    white-space: normal;
    max-width: 100%;
}
.main-result-card {
    max-width: 600px;
    width: 100%;
}
.result-img-row {
    margin-bottom: 1.5rem !important;
}

/* ================================
   Responsive Adjustments
   ================================ */
@media (max-width: 600px) {
    .file-input-row,
    .custom-file-input-wrapper,
    .custom-select-wrapper,
    .result-card,
    .main-result-card {
        max-width: 98vw;
        width: 100%;
    }
    .custom-file-label, .custom-file-filename, .custom-select-wrapper select.form-control {
        font-size: 1rem;
    }
    .custom-file-label {
        width: 38vw;
        min-width: 90px;
        max-width: 50vw;
    }
    .custom-file-filename {
        padding-left: 10px;
    }
    .result-card {
        padding: 1.1rem 0.5rem 1.1rem 0.5rem;
        border-radius: 13px;
        margin: 1.2rem auto 0 auto;
    }
    .result-details {
        gap: 0.5rem;
    }
    .result-row {
        font-size: 1.08rem;
        padding: 0.85rem 0.7rem;
    }
    .result-earnings {
        font-size: 2.1rem;
    }
    .result-meta {
        font-size: 1rem;
    }
    .result-img-row .col-12 {
        margin-bottom: 1.2rem;
    }
}

/* ================================
   Feature Checklist Styling
   ================================ */
.feature-checklist {
    list-style: none;
    padding-left: 0;
    margin-bottom: 1.5rem;
}
.feature-checklist li {
    position: relative;
    padding-left: 2em;
    margin-bottom: 1.1em;
    font-size: 1.08rem;
    font-weight: 500;
    color: #23305c;
}
.feature-checklist li::before {
    content: "\2713";
    position: absolute;
    left: 0;
    top: 0.1em;
    color: #19b34a;
    font-size: 1.25em;
    font-weight: bold;
    line-height: 1;
}

.result-card .result-row {
  flex-wrap: wrap;
  white-space: normal !important;
  word-break: break-word;
}

.result-card .result-value {
  display: block;
  font-weight: bold;
  margin-top: 5px;
  white-space: normal !important;
  word-break: break-word;
}

@media (max-width: 768px) {
  .result-card .result-meta,
  .result-card .result-value,
  .result-card .result-label {
    font-size: 1rem !important;
    white-space: normal !important;
    word-break: break-word;
  }
}

@media (max-width: 767px) {
  .result-card .result-value {
    text-align: left !important;
    display: block;
    white-space: normal;
    word-break: break-word;
    margin-left: 0 !important;
  }
}

</style>
    
</head>
<body>
<div class="content-wrapper">
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">
         <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
           Convert GIF to JPG Instantly
         </h1>
         <h3 class="lead fs-20 lh-sm mb-4 mt-5">
           Instantly convert GIF images to high-quality JPGs online. Shrink file size, boost compatibility, and keep your images looking sharp—no signup, no watermark, unlimited use.
         </h3>
<form id="image-compressor-form" method="POST" enctype="multipart/form-data" action="" style="max-width:600px;margin:0 auto;">
  <div class="mb-3">
    <div class="custom-file-input-wrapper file-input-row">
      <input
        type="file"
        class="custom-file-input"
        id="image_file"
        name="image_file"
        accept="image/gif"
        <?= $disable_file_input ? 'disabled' : '' ?>
        required
        onchange="updateFilenameAndPreview(this)"
      >
      <label for="image_file" class="custom-file-label" id="choose-file-label">Choose GIF</label>
      <div class="custom-file-filename" id="file-filename" onclick="if(!document.getElementById('image_file').disabled){document.getElementById('image_file').click();}">No file chosen</div>
    </div>
    <small class="form-text text-muted">Choose a GIF image (max 6MB)</small>
    <div id="orig-preview-container" class="mt-3">
      <?php if ($orig_img_url): ?>
        <div class="img-preview-label">Preview</div>
        <img src="<?= htmlspecialchars($orig_img_url) ?>" class="img-fluid img-preview">
        <div class="mt-2">
          <button type="button" class="btn btn-link p-0" onclick="enableFileInput()">Choose another file</button>
        </div>
      <?php endif; ?>
    </div>
  </div>
  <div class="mb-3">
    <select class="form-control" id="compression_level" name="compression_level" required>
      <option value="auto"<?= ($selected_compression_level=='auto'?' selected':'') ?>>Auto (Recommended)</option>
      <option value="high"<?= ($selected_compression_level=='high'?' selected':'') ?>>High Compression</option>
      <option value="medium"<?= ($selected_compression_level=='medium'?' selected':'') ?>>Medium Compression</option>
      <option value="low"<?= ($selected_compression_level=='low'?' selected':'') ?>>Low Compression</option>
    </select>
    <small class="form-text text-muted">Select compression level</small>
  </div>
  <div class="row">
    <div class="col-12 d-flex justify-content-center">
      <button class="btn" type="submit" id="compress-btn" style="margin-top:10px;width:100%;max-width:320px;">Convert to JPG</button>
    </div>
  </div>
</form>
         <div id="compressor-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite">
           <?= $conversion_result ?>
         </div>
        </div>
      </div>
    </div>
  </section>

  <!-- HOW IT WORKS SECTION -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <h2 class="display-4 mb-3">How GIF to JPG Conversion Works</h2>
      <div class="row gx-lg-8 gx-xl-12 gy-6 process-wrapper line mt-5">
        <div class="col-md-6 col-lg-4">
          <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">01</span></span>
          <h4 class="mb-1">Upload Your GIF Image</h4>
          <p class="mb-0">
            Start by choosing any GIF image from your device. Our tool instantly checks your file for compatibility and prepares it for conversion. No technical skills required—just drag, drop, and go.
          </p>
        </div>
        <div class="col-md-6 col-lg-4">
          <span class="icon btn btn-circle btn-lg btn-primary pe-none mb-4"><span class="number">02</span></span>
          <h4 class="mb-1">Select Compression Level</h4>
          <p class="mb-0">
            Pick your preferred compression level: Auto, High, Medium, or Low. "Auto" uses smart algorithms to balance size and quality, while other options give you full control over the final output. You can reconvert with different settings any time.
          </p>
        </div>
        <div class="col-md-6 col-lg-4">
          <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">03</span></span>
          <h4 class="mb-1">Download & Use Instantly</h4>
          <p class="mb-0">
            In seconds, your JPG image is ready for download—smaller, faster, and compatible everywhere. Use it for websites, blogs, email, print, or social media without sacrificing quality.
          </p>
        </div>
      </div>
      <div class="row mt-5">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-primary p-4 fs-17">
            <strong>Tip:</strong> Converting GIFs to JPGs before uploading to your website or sharing online can dramatically improve load times, SEO, and user experience while saving storage and bandwidth.
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- FEATURE CHECKLIST -->
  <section class="wrapper">
    <div class="container pt-2 pb-5 text-center">
      <p class="lead fs-18 lh-sm mb-4">
        Whether you’re a web developer, designer, marketer, or everyday user, our GIF to JPG Converter makes it easy to transform your images for any purpose. No technical skills required—just fast, reliable results every time.
      </p>
      <div class="row justify-content-center">
        <div class="col-md-6">
          <ul class="feature-checklist">
            <li>Supports all GIF images—animated and static</li>
            <li>No watermarks, no sign-up, unlimited free use</li>
            <li>Smart conversion: balances file size and visual quality automatically</li>
            <li>Works on mobile, tablet, and desktop devices</li>
            <li>Secure: your images are never stored or shared</li>
          </ul>
        </div>
        <div class="col-md-6">
          <ul class="feature-checklist">
            <li>Instant results—see file size reduction in real time</li>
            <li>Drag & drop or browse to upload GIFs</li>
            <li>Batch conversion for multiple files at once</li>
            <li>Optimized for web, email, print, and social media</li>
            <li>Trusted by professionals, bloggers, and creators worldwide</li>
          </ul>
        </div>
      </div>
      <div class="alert alert-success p-4 fs-17 mt-4">
        <strong>Ready to convert your GIFs?</strong> Transform your first image now—no registration required!
      </div>
    </div>
  </section>

  <!-- WHY GIF TO JPG CONVERSION MATTERS -->
  <section class="wrapper bg-gradient-primary">
    <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
      <h2 class="display-4 mb-3">Why Convert GIF to JPG?</h2>
      <p class="lead fs-18 lh-sm mb-7">
        GIF is a classic format for simple animations and graphics, but it’s limited to 256 colors and can result in large file sizes. JPG, on the other hand, supports millions of colors, lossy compression, and is universally supported—making it the ideal choice for high-quality images on the web. Converting GIFs to JPGs shrinks file size, boosts quality, and ensures your images look great everywhere.
      </p>
      <div class="row gx-lg-8 gx-xl-12 gy-6">
        <div class="col-md-6 col-lg-4">
          <div class="card shadow-sm p-4 h-100">
            <h5 class="mb-2">Boost Website Speed</h5>
            <p class="mb-0">
              JPGs load faster and look sharper than GIFs, making your website feel modern and responsive. Google ranks faster sites higher, so GIF to JPG conversion is a must for every site owner and designer.
            </p>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="card shadow-sm p-4 h-100">
            <h5 class="mb-2">Save Storage & Bandwidth</h5>
            <p class="mb-0">
              Smaller JPGs mean less server space, lower hosting costs, and reduced data usage for your visitors. Whether you run a blog, store, or portfolio, GIF to JPG conversion pays off.
            </p>
          </div>
        </div>
        <div class="col-md-6 col-lg-4">
          <div class="card shadow-sm p-4 h-100">
            <h5 class="mb-2">Universal Compatibility</h5>
            <p class="mb-0">
              JPG is supported everywhere—websites, email, social media, and print. Converting GIFs to JPGs ensures your images display perfectly, no matter where you share them.
            </p>
          </div>
        </div>
      </div>
      <div class="row mt-6">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-primary p-4 fs-17">
            <strong>Pro Tip:</strong> Always convert GIFs to JPGs for web graphics, blog images, and email attachments. This one step can dramatically improve performance and compatibility.
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- HOW GIF TO JPG CONVERSION WORKS (IN-DEPTH) -->
  <section class="wrapper bg-light">
    <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
      <h2 class="display-4 mb-3">How GIF to JPG Conversion Works</h2>
      <div class="row gx-lg-8 gx-xl-12 gy-6">
        <div class="col-md-6 text-start">
          <p class="fs-18 lh-lg">
            GIF (Graphics Interchange Format) is a lossless format limited to 256 colors, often used for simple graphics and animations. JPG (Joint Photographic Experts Group) is a lossy format that supports millions of colors and is highly optimized for photographs and complex images. When you convert a GIF to JPG, the image is rendered in true color with advanced compression, resulting in smaller files and better quality for photographs and graphics. Our tool uses advanced algorithms to ensure your converted JPGs are crisp, vibrant, and as small as possible.
          </p>
          <p class="fs-18 lh-lg">
            Choose your compression level: "Auto" for smart optimization, or High, Medium, and Low for more control. "High" shrinks file size the most, while "Low" preserves more detail. You can preview your GIF and JPG before and after conversion to ensure perfect results.
          </p>
        </div>
        <div class="col-md-6 text-start">
          <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
            <li><strong>Lossless Rendering:</strong> Converts GIF to JPG with minimal quality loss for the best results.</li>
            <li><strong>Smart Compression:</strong> Balances file size and image quality for web, email, and print.</li>
            <li><strong>Color Optimization:</strong> Expands color range from 256 (GIF) to millions (JPG).</li>
            <li><strong>Batch Conversion:</strong> Upload and convert multiple GIFs to JPGs at once for maximum efficiency.</li>
            <li><strong>Security:</strong> Your images are never stored, shared, or watermarked—privacy guaranteed.</li>
          </ul>
        </div>
      </div>
      <div class="row mt-5">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-success p-4 fs-17">
            <strong>Did you know?</strong> JPGs converted from GIFs can be up to 80% smaller, dramatically speeding up your website and saving bandwidth.
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- CUSTOMER REVIEWS SECTION -->
  <section class="wrapper" style="background-color:#f5faff;color:#23272b;">
    <div class="container py-7">
      <h2 class="display-6 mb-5 text-center" style="color:#212121;">What Users Say About Our GIF to JPG Converter</h2>
      <div class="row gx-5 gy-4 justify-content-center">
        <div class="col-md-4">
          <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
            <div class="mb-2 text-warning">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              “The GIF to JPG Converter has made my website so much faster. I can convert dozens of graphics in seconds and the quality is always perfect. Highly recommended for any web professional!”
            </p>
            <div class="fw-bold" style="color:#2586f7;">– Alex, Web Developer</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
            <div class="mb-2 text-warning">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
            </div>
            <p>
              “I use GIFs for all my product icons. This converter helps me keep load times low and conversions high. The batch feature is a huge time saver.”
            </p>
            <div class="fw-bold" style="color:#2586f7;">– Priya, Store Owner</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
            <div class="mb-2 text-warning">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              “As a designer, I’m impressed with how well this tool preserves color and detail in converted JPGs. The results are always crisp and professional.”
            </p>
            <div class="fw-bold" style="color:#2586f7;">– Maria, Graphic Designer</div>
          </div>
        </div>
      </div>
      <div class="row gx-5 gy-4 justify-content-center mt-4">
        <div class="col-md-4">
          <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
            <div class="mb-2 text-warning">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              “No more slow uploads! I can convert GIFs for my business presentations and newsletters in seconds. The interface is clean and super easy to use.”
            </p>
            <div class="fw-bold" style="color:#2586f7;">– Michael, Marketing Manager</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
            <div class="mb-2 text-warning">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              “The drag-and-drop feature is a game changer. I can convert dozens of GIFs for my online store in one go, and the results are always reliable. My site speed scores have never been better.”
            </p>
            <div class="fw-bold" style="color:#2586f7;">– Sofia, eCommerce Owner</div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- ORGANIC GROWTH TIPS -->
  <section class="wrapper bg-light">
    <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
      <h2 class="display-4 mb-3">Tips for Effective GIF to JPG Conversion</h2>
      <div class="row gx-lg-8 gx-xl-12 gy-6">
        <div class="col-md-6 text-start">
          <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
            <li><strong>Resize Before Converting:</strong> Scale images to the exact size needed for your site or app to avoid unnecessary file weight.</li>
            <li><strong>Preview Before Download:</strong> Always compare the original and converted image to make sure quality meets your needs.</li>
            <li><strong>Batch Convert for Efficiency:</strong> Save time by converting multiple GIFs to JPGs at once, especially for large projects or eCommerce stores.</li>
            <li><strong>Keep Originals Safe:</strong> Store uncompressed GIFs for future editing or printing, and use JPGs for web and sharing.</li>
            <li><strong>Optimize Alt Text:</strong> Add descriptive alt tags to your images for better SEO and accessibility.</li>
          </ul>
        </div>
        <div class="col-md-6 text-start">
          <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
            <li><strong>Test Website Speed:</strong> Use tools like Google PageSpeed Insights to see how GIF to JPG conversion improves your site’s load time.</li>
            <li><strong>Automate Your Workflow:</strong> Integrate GIF to JPG conversion into your CMS or build process for consistent optimization.</li>
            <li><strong>Stay Updated:</strong> Follow best practices and new image formats to ensure your site stays fast and modern.</li>
            <li><strong>Use the Right Compression Level:</strong> For most web use, a JPG quality of 75 provides the best balance between size and clarity.</li>
          </ul>
        </div>
      </div>
      <div class="row mt-5">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-success p-4 fs-17">
            <strong>Did you know?</strong> Converted JPGs can cut page load time by up to 80%, leading to better SEO, higher engagement, and lower bounce rates.
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- FAQ SECTION -->
  <section class="wrapper bg-gradient-primary">
    <div class="container pt-10 pt-md-12">
      <h2 class="display-4 mb-3">Frequently Asked Questions</h2>
      <div class="row gx-lg-8 gx-xl-12 gy-6">
        <div class="col-lg-6 text-start">
          <div class="accordion" id="faqAccordionLeft">
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading1">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
                  How does the GIF to JPG Converter work?
                </button>
              </h2>
              <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordionLeft">
                <div class="accordion-body">
                  <p>
                    The GIF to JPG Converter uses advanced algorithms to optimize color and compress your GIF images into high-quality JPGs. You can choose your preferred compression level, and the tool will balance optimization and image clarity, so your images look perfect and load instantly.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading2">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
                  Will my GIF images lose quality?
                </button>
              </h2>
              <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordionLeft">
                <div class="accordion-body">
                  <p>
                    Our tool is designed to minimize quality loss. In most cases, you’ll notice a huge reduction in file size with little to no visible change. You can preview the result before downloading to ensure it meets your standards.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading3">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
                  What image formats are supported?
                </button>
              </h2>
              <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordionLeft">
                <div class="accordion-body">
                  <p>
                    This tool is focused on GIF to JPG conversion. For other formats like PNG, SVG, WebP, or RAW, please use our dedicated converters.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading4">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
                  Is there a file size or usage limit?
                </button>
              </h2>
              <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordionLeft">
                <div class="accordion-body">
                  <p>
                    No, you can convert as many GIF images as you like, up to 6MB per file. There are no watermarks, no sign-up, and no hidden restrictions—just fast, free conversion.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading5">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
                  Is my privacy protected?
                </button>
              </h2>
              <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordionLeft">
                <div class="accordion-body">
                  <p>
                    Yes, your GIF images are processed securely and are never stored or shared. All conversion happens in real-time, and your files are deleted immediately after processing.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--/col-->
        <div class="col-lg-6 text-start">
          <div class="accordion" id="faqAccordionRight">
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading6">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
                  Can I convert multiple GIFs at once?
                </button>
              </h2>
              <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordionRight">
                <div class="accordion-body">
                  <p>
                    Absolutely! Use the batch conversion feature to upload and convert several GIF images in one go. This is perfect for web projects, eCommerce stores, or anyone managing lots of visuals.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading7">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
                  Will the tool work on my phone or tablet?
                </button>
              </h2>
              <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordionRight">
                <div class="accordion-body">
                  <p>
                    Yes, our GIF to JPG converter is fully responsive and works on all modern mobile devices and tablets. You can convert and download images directly from your phone, anywhere, anytime.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading8">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
                  Does conversion affect SEO?
                </button>
              </h2>
              <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordionRight">
                <div class="accordion-body">
                  <p>
                    Yes—in a good way! Smaller JPG images mean faster page loads, which Google rewards with higher rankings. Optimized images also improve user experience, which can boost your site’s SEO performance.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading9">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
                  Can I use converted JPGs for print?
                </button>
              </h2>
              <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordionRight">
                <div class="accordion-body">
                  <p>
                    For web and digital use, converted JPGs are perfect. For high-quality print, keep an original uncompressed GIF version, as JPG compression may reduce print quality at large sizes.
                  </p>
                </div>
              </div>
            </div>
            <div class="accordion-item">
              <h2 class="accordion-header" id="faqHeading10">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse10" aria-expanded="false" aria-controls="faqCollapse10">
                  Is this tool really free?
                </button>
              </h2>
              <div id="faqCollapse10" class="accordion-collapse collapse" aria-labelledby="faqHeading10" data-bs-parent="#faqAccordionRight">
                <div class="accordion-body">
                  <p>
                    Yes! Our GIF to JPG converter is 100% free to use, with no watermarks, usage limits, or hidden fees. Enjoy unlimited, high-quality image conversion anytime you need it.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--/col-->
      </div>
      <!--/.row -->
      <div class="row mt-6">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-primary p-4 fs-17">
            <strong>Still have questions?</strong> Reach out to our support team anytime. We’re here to help you get the best results from your images!
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function updateFilenameAndPreview(input) {
    var fileName = "No file chosen";
    var container = document.getElementById('orig-preview-container');
    if (container) container.innerHTML = '';
    if (input.files && input.files.length > 0) {
        fileName = input.files[0].name;
        if (container) {
            var reader = new FileReader();
            reader.onload = function(e) {
                container.innerHTML = '<div class="img-preview-label">Preview</div><img src="'+e.target.result+'" class="img-fluid img-preview">';
            }
            reader.readAsDataURL(input.files[0]);
        }
    }
    document.getElementById('file-filename').textContent = fileName;
}
function enableFileInput() {
    var fileInput = document.getElementById('image_file');
    var fileNameDiv = document.getElementById('file-filename');
    var previewDiv = document.getElementById('orig-preview-container');
    fileInput.disabled = false;
    fileInput.value = '';
    fileNameDiv.textContent = 'No file chosen';
    if (previewDiv) previewDiv.innerHTML = '';
}
document.addEventListener('DOMContentLoaded', function() {
    var fileInput = document.getElementById('image_file');
    var fileNameDiv = document.getElementById('file-filename');
    var previewDiv = document.getElementById('orig-preview-container');
    if (fileInput && fileNameDiv) {
        fileInput.value = '';
        fileNameDiv.textContent = 'No file chosen';
        if (previewDiv) previewDiv.innerHTML = '';
        fileInput.onchange = function() {
            updateFilenameAndPreview(this);
        };
        fileNameDiv.onclick = function() {
            fileInput.click();
        };
    }
});
</script>
</body>
</html>
