<?php

// Log errors to error.log in this script's directory
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

$compressed_dir = __DIR__ . '/compressed/';

if (!isset($_GET['file'])) {
    http_response_code(400);
    exit('No file specified.');
}

$file = basename($_GET['file']);
$filepath = $compressed_dir . $file;

$allowed_ext = ['jpg', 'jpeg', 'png', 'webp'];
$ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
if (!in_array($ext, $allowed_ext)) {
    http_response_code(403);
    exit('Invalid file type.');
}

error_log("Looking for file: $filepath");

if (!is_file($filepath) || !is_readable($filepath)) {
    http_response_code(404);
    exit('File not found.');
}

header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $file . '"');
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filepath));
flush();
readfile($filepath);
exit;
?>
