<?php
// SEO meta tags (set before header include)
$page_title = "YouTube Money Calculator: Estimate Your YouTube Earnings Instantly";
$page_description = "Estimate your YouTube earnings by views, country, and niche. Use our free YouTube Money Calculator to calculate ad revenue and maximize your channel’s income.";
$page_author = "Instablogs";
$pageKeywords = "YouTube Money Calculator, YouTube earnings, YouTube ad revenue, YouTube RPM, YouTube calculator, YouTube income estimator, YouTube revenue tool, YouTube channel earnings, YouTube views to money, YouTube niche earnings, YouTube country RPM, YouTube monetization, YouTube revenue estimate, YouTube calculator tool";

// Include header (make sure your header.php outputs meta tags using these variables)
include $_SERVER['DOCUMENT_ROOT'] . '/admin/header.php';

// --- PHP Logic ---

// List of all countries (UN member states)
$countries = [
    "AF" => "Afghanistan", "AL" => "Albania", "DZ" => "Algeria", "AD" => "Andorra", "AO" => "Angola", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan",
    // ... (rest of country list as before)
    "US" => "United States", "GB" => "United Kingdom", "IN" => "India", "CA" => "Canada", "DE" => "Germany", "FR" => "France", "BR" => "Brazil", "RU" => "Russia", "JP" => "Japan"
    // Add all other countries as needed
];

// YouTube official categories/niches
$niches = [
    "Film & Animation", "Autos & Vehicles", "Music", "Pets & Animals", "Sports", "Short Movies", "Travel & Events", "Gaming", "Videoblogging", "People & Blogs", "Comedy", "Entertainment", "News & Politics", "Howto & Style", "Education", "Science & Technology", "Nonprofits & Activism", "Movies", "Anime/Animation", "Action/Adventure", "Classics", "Documentary", "Drama", "Family", "Foreign", "Horror", "Sci-Fi/Fantasy", "Thriller", "Shorts", "Shows", "Trailers", "Finance", "Health & Fitness", "Food & Cooking", "Beauty & Fashion", "DIY & Crafts", "Parenting", "History", "Nature & Wildlife", "Motivation", "Product Reviews", "Unboxing", "ASMR"
];

// Example RPM values by country (USD)
$country_rpm = [
    "US" => 6.0, "GB" => 5.0, "CA" => 5.5, "AU" => 5.2, "DE" => 4.5, "IN" => 1.0, "BR" => 1.2, "RU" => 1.3, "FR" => 4.0, "JP" => 3.8,
    "default" => 2.5
];
// Example RPM values by niche (USD)
$niche_rpm = [
    "Finance" => 10.0, "Education" => 8.0, "Tech" => 7.0, "Gaming" => 3.0, "Music" => 2.5, "Comedy" => 2.0, "Entertainment" => 2.2, "Beauty & Fashion" => 4.0, "Food & Cooking" => 4.0,
    "Health & Fitness" => 6.0, "Howto & Style" => 5.0, "Science & Technology" => 6.0, "People & Blogs" => 2.5, "Travel & Events" => 3.5, "ASMR" => 2.0,
    "default" => 2.5
];

// Helper to get RPM
function get_rpm($country_code, $niche) {
    global $country_rpm, $niche_rpm;
    $country_val = $country_rpm[$country_code] ?? $country_rpm["default"];
    $niche_val = $niche_rpm[$niche] ?? $niche_rpm["default"];
    return round(($country_val + $niche_val) / 2, 2);
}

// Handle form
$results = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $views = isset($_POST['monthly_views']) ? (int)$_POST['monthly_views'] : 0;
    $country = $_POST['country'] ?? 'US';
    $niche = $_POST['niche'] ?? 'Entertainment';
    $rpm = get_rpm($country, $niche);

    $estimated_earnings = ($views / 1000) * $rpm;
    $results = [
        'views' => number_format($views),
        'country' => $countries[$country] ?? $country,
        'niche' => $niche, // Use plain text, not htmlspecialchars, to avoid &amp; bug
        'rpm' => '$' . number_format($rpm, 2),
        'earnings' => '$' . number_format($estimated_earnings, 2)
    ];
}
?>

<!-- Styles: Only one table style, wider and responsive -->
<style>

@import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@500;700&display=swap');
<link rel="stylesheet" href="/assets/css/style.css" />

html, body {
  margin: 0 !important;
  padding: 0 !important;
  box-sizing: border-box;
  height: 100%;
}
header, .wrapper, .content-wrapper, .container, .navbar, .navbar-brand {
  margin-top: 0 !important;
  padding-top: 0 !important;
}

/* Remove ALL space above header/logo/nav */
html, body {
  margin: 0 !important;
  padding: 0 !important;
  box-sizing: border-box;
  height: 100%;
}

/* Remove margin/padding from header and containers at the top */
header, .wrapper, .content-wrapper, .container, .navbar, .navbar-brand {
  margin-top: 0 !important;
  padding-top: 0 !important;
}

/* Remove top margin from first heading/title if present */
header h1, header h2, .ytmc-title {
  margin-top: 0 !important;
}

/* Calculator and content styling */
body {
    font-family: 'Montserrat', Arial, sans-serif;
    background: linear-gradient(135deg, #e0eafc 0%, #cfdef3 100%);
    margin: 0;
    padding: 0;
}
.ytmc-container {
    max-width: 900px;
    margin: 40px auto 20px auto;
    background: #fff;
    border-radius: 18px;
    box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
    padding: 40px 32px 32px 32px;
}
.ytmc-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #e62117;
    letter-spacing: -1px;
    margin-bottom: 10px;
    text-align: center;
}
.ytmc-subtitle {
    font-size: 1.2rem;
    color: #333;
    margin-bottom: 22px;
    text-align: center;
}
.ytmc-form label {
    font-weight: 600;
    color: #333;
    margin-top: 12px;
    display: block;
}
.ytmc-form input, .ytmc-form select {
    width: 100%;
    padding: 10px 14px;
    margin: 6px 0 20px 0;
    border: 1px solid #cfd8dc;
    border-radius: 6px;
    font-size: 1rem;
    background: #f8fafc;
    transition: border-color 0.2s;
}
.ytmc-form input:focus, .ytmc-form select:focus {
    border-color: #e62117;
    outline: none;
}
.ytmc-form button {
    display: block;
    background: linear-gradient(90deg,#e62117 0%,#ff6e7f 100%);
    color: #fff;
    font-size: 1.15rem;
    font-weight: 700;
    border: none;
    border-radius: 8px;
    padding: 12px 36px;
    cursor: pointer;
    box-shadow: 0 4px 16px rgba(230,33,23,0.07);
    transition: background 0.2s;
    margin: 0 auto;
    text-align: center;
}
.ytmc-form button:hover {
    background: linear-gradient(90deg,#ff6e7f 0%,#e62117 100%);
}

/* Results Card */
.ytmc-results-card {
    max-width: 600px;
    margin: 30px auto 0 auto;
    padding: 32px 30px;
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 4px 16px rgba(0,0,0,0.08);
    text-align: center;
}
.ytmc-results-card h2 {
    margin-bottom: 12px;
    color: #007bff;
    font-size: 1.7em;
    text-align: center;
}
.ytmc-earnings {
    font-size: 2.4em;
    color: #28a745;
    font-weight: bold;
    margin-bottom: 22px;
}

/* Responsive Table Styling */
.ytmc-results-table-responsive {
    width: 100%;
    overflow-x: auto;
    margin: 0 auto;
}
.ytmc-results-table {
    width: 100%;
    min-width: 400px;
    max-width: 540px;
    margin: 0 auto;
    border-collapse: separate;
    border-spacing: 0;
    background: #f9fbfd;
    border-radius: 16px;
    box-shadow: 0 2px 12px rgba(33, 118, 255, 0.07);
    font-size: 1.22em;
    font-family: 'Segoe UI', 'Open Sans', Arial, sans-serif;
    overflow: hidden;
}
.ytmc-results-table th, .ytmc-results-table td {
    padding: 20px 18px;
    border-bottom: 1px solid #e3e8ee;
    text-align: left;
}
.ytmc-results-table th {
    background: #eaf2ff;
    color: #2176ff;
    font-weight: 700;
    width: 48%;
    font-size: 1.09em;
    border-right: 1px solid #e3e8ee;
}
.ytmc-results-table td {
    color: #222;
    font-weight: 600;
    text-align: right;
    background: #f9fbfd;
}
.ytmc-results-table tr:nth-child(even) td {
    background: #f3f8ff;
}
.ytmc-results-table tr:last-child th,
.ytmc-results-table tr:last-child td {
    border-bottom: none;
}
.ytmc-results-table tr:hover td {
    background: #e7f1ff;
    transition: background 0.2s;
}
@media (max-width: 700px) {
    .ytmc-container { padding: 15px 2vw 15px 2vw; }
    .ytmc-title { font-size: 1.6rem; }
    .ytmc-results-card { padding: 16px 6px; font-size: 1em; }
    .ytmc-results-table th, .ytmc-results-table td { padding: 12px 6px; font-size: 1em; }
    .ytmc-results-table { font-size: 1em; min-width: 320px; }
}

/* Content Section */
.ytmc-content {
    margin-top: 40px;
    line-height: 1.7;
    color: #263238;
}
.ytmc-content h2 {
    color: #e62117;
    font-size: 1.5rem;
    margin-top: 2em;
}
.ytmc-content h3 {
    color: #263238;
    margin-top: 1.5em;
    font-size: 1.15rem;
}
.ytmc-faq {
    margin-top: 2.5em;
    background: #f9fbe7;
    border-radius: 10px;
    padding: 28px 22px;
}
.ytmc-faq h2 {
    color: #e62117;
    font-size: 1.35rem;
}
.ytmc-faq details {
    margin-bottom: 1.2em;
}
.ytmc-faq summary {
    font-weight: 600;
    color: #263238;
    cursor: pointer;
    font-size: 1.08rem;
}
.ytmc-faq p {
    margin-left: 1.2em;
    color: #263238;
}

/* Black footer styling with space above */
.site-footer {
  background: #111;
  color: #fff;
  text-align: center;
  padding: 40px 0 20px 0;
  margin-top: 60px;
  font-size: 1.1em;
  letter-spacing: 0.02em;
  width: 100%;
}

html, body {
  margin: 0 !important;
  padding: 0 !important;
  box-sizing: border-box;
  height: 100%;
}
body {
  background: linear-gradient(135deg, #e0eafc 0%, #cfdef3 100%);
  font-family: 'Montserrat', Arial, sans-serif;
}
header, .wrapper, .content-wrapper, .container, .navbar, .navbar-brand {
  margin-top: 0 !important;
  padding-top: 0 !important;
}
header h1, header h2, .ytmc-title {
  margin-top: 0 !important;
}
</style>



<div class="ytmc-container">
    <div class="ytmc-title">YouTube Money Calculator</div>
    <div class="ytmc-subtitle">
        Instantly estimate your potential monthly YouTube ad earnings based on your views, country, and channel niche. Powered by the latest RPM data and real YouTube categories.
    </div>
    <form class="ytmc-form" method="post">
        <label for="monthly_views">Monthly Views</label>
        <input type="number" name="monthly_views" id="monthly_views" min="100" max="1000000000" value="<?= isset($_POST['monthly_views']) ? htmlspecialchars($_POST['monthly_views']) : '100000' ?>" required>

        <label for="country">Country</label>
        <select name="country" id="country" required>
            <?php foreach ($countries as $code => $name): ?>
                <option value="<?= $code ?>" <?= (isset($_POST['country']) && $_POST['country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
            <?php endforeach; ?>
        </select>

        <label for="niche">YouTube Niche</label>
        <select name="niche" id="niche" required>
            <?php foreach ($niches as $niche): ?>
                <option value="<?= htmlspecialchars($niche) ?>" <?= (isset($_POST['niche']) && $_POST['niche'] == $niche) ? 'selected' : '' ?>><?= htmlspecialchars($niche) ?></option>
            <?php endforeach; ?>
        </select>

        <button type="submit">Calculate Earnings</button>
    </form>

    <?php if ($results): ?>
        <div class="ytmc-results-card">
            <h2>Estimated Monthly Earnings</h2>
            <div class="ytmc-earnings"><?= htmlspecialchars($results['earnings']) ?></div>
            <div class="ytmc-results-table-responsive">
                <table class="ytmc-results-table">
                    <tr>
                        <th>Monthly Views</th>
                        <td><?= htmlspecialchars($results['views']) ?></td>
                    </tr>
                    <tr>
                        <th>Country</th>
                        <td><?= htmlspecialchars($results['country']) ?></td>
                    </tr>
                    <tr>
                        <th>Niche</th>
                        <td><?= $results['niche'] ?></td>
                    </tr>
                    <tr>
                        <th>Estimated RPM</th>
                        <td><?= htmlspecialchars($results['rpm']) ?></td>
                    </tr>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <!-- Informational Content Section -->
    <div class="ytmc-content">
        <h2>What is the YouTube Money Calculator?</h2>
        <p>
            The YouTube Money Calculator is a free online tool that estimates how much money you can earn from YouTube ads based on your monthly views, country, and channel niche. It uses up-to-date RPM (Revenue Per Mille) data and official YouTube categories to provide a realistic estimate of your potential earnings.
        </p>
        <h2>How Does the YouTube Money Calculator Work?</h2>
        <p>
            Our calculator uses the following formula to estimate your monthly earnings:
        </p>
        <blockquote>
            <b>Estimated Earnings = (Monthly Views / 1,000) × RPM</b>
        </blockquote>
        <p>
            <b>RPM</b> (Revenue Per Mille) is the net revenue you earn per 1,000 views after YouTube’s share is deducted. RPM varies by country and niche, so our tool averages both for a balanced estimate.
        </p>
        <h2>Why Do Country and Niche Matter?</h2>
        <p>
            Advertisers pay different rates based on your audience’s country and your channel’s niche. For example, finance and tech channels in the US or UK earn much higher RPMs than entertainment channels in developing countries. This calculator uses real-world RPM data for maximum accuracy.
        </p>
        <h2>How to Use This Calculator</h2>
        <ol>
            <li>Enter your average monthly YouTube views.</li>
            <li>Select your primary audience country.</li>
            <li>Choose your channel’s main niche or category.</li>
            <li>Click "Calculate Earnings" to see your estimated monthly ad income.</li>
        </ol>
        <h2>Understanding RPM and CPM</h2>
        <p>
            <b>CPM</b> (Cost Per Mille) is what advertisers pay for 1,000 ad impressions. <b>RPM</b> is what you, the creator, actually receive per 1,000 views after YouTube’s 45% cut and other adjustments. RPM is always lower than CPM, but it reflects your real earnings.
        </p>
        <h2>What Factors Affect YouTube Earnings?</h2>
        <ul>
            <li><b>Audience Location:</b> US, UK, Australia, and Canada have the highest RPMs.</li>
            <li><b>Niche:</b> Finance, tech, and education channels earn more than entertainment or vlogging channels.</li>
            <li><b>Engagement:</b> Higher watch time and engagement boost ad revenue.</li>
            <li><b>Video Length:</b> Videos over 8 minutes can have multiple ads, increasing RPM.</li>
            <li><b>Seasonality:</b> Earnings spike during Q4 (holiday season) due to increased ad spend.</li>
        </ul>
        <h2>How Accurate is This Calculator?</h2>
        <p>
            This tool provides a realistic estimate based on the latest available RPM data for each country and niche. Actual earnings may vary due to factors like ad-block usage, video content suitability, and advertiser demand. For the most accurate numbers, check your YouTube Analytics dashboard.
        </p>
        <h2>Tips to Increase Your YouTube Earnings</h2>
        <ul>
            <li>Focus on high-RPM niches (finance, tech, education).</li>
            <li>Grow your audience in high-paying countries.</li>
            <li>Increase video length (8+ minutes) to enable more ads.</li>
            <li>Boost engagement with compelling content and calls to action.</li>
            <li>Optimize your titles, thumbnails, and descriptions for search.</li>
        </ul>
        <h2>Other Ways to Make Money on YouTube</h2>
        <ul>
            <li>Channel memberships and Super Chats</li>
            <li>Brand sponsorships and affiliate marketing</li>
            <li>Merchandise sales</li>
            <li>Offering online courses or consulting</li>
        </ul>
        <h2>Frequently Asked Questions (FAQ)</h2>
        <div class="ytmc-faq">
            <details>
                <summary>How much does YouTube pay per 1,000 views?</summary>
                <p>
                    On average, YouTube pays between $1 and $10 per 1,000 views, depending on your country, niche, and audience engagement. Finance and tech channels in the US can earn $8–$15 RPM, while entertainment channels in developing countries may earn $0.50–$2 RPM.
                </p>
            </details>
            <details>
                <summary>What is RPM and how is it calculated?</summary>
                <p>
                    RPM (Revenue Per Mille) is your net earnings per 1,000 views, after YouTube’s share and other deductions. It’s calculated as: <b>Total Revenue ÷ Total Views × 1,000</b>.
                </p>
            </details>
            <details>
                <summary>How can I increase my YouTube RPM?</summary>
                <p>
                    Focus on high-value niches, target audiences in high-paying countries, create longer videos (8+ minutes), and boost engagement to attract better ads and increase your RPM.
                </p>
            </details>
            <details>
                <summary>Does this calculator use real YouTube data?</summary>
                <p>
                    This calculator uses the latest RPM data from industry reports and averages for each country and niche. For your actual earnings, check your YouTube Analytics dashboard.
                </p>
            </details>
            <details>
                <summary>Can I use this calculator for shorts or live streams?</summary>
                <p>
                    This tool is designed for standard YouTube videos monetized with ads. Shorts and live streams have different monetization models, but you can use your average RPM if you have one.
                </p>
            </details>
            <details>
                <summary>What is the minimum requirement for YouTube monetization?</summary>
                <p>
                    You need at least 1,000 subscribers and 4,000 valid public watch hours in the past 12 months to join the YouTube Partner Program and start earning ad revenue.
                </p>
            </details>
            <details>
                <summary>Why are my YouTube earnings lower than expected?</summary>
                <p>
                    Earnings can be affected by ad-block usage, limited advertiser demand, low engagement, or a high percentage of views from low-RPM countries or non-monetized content.
                </p>
            </details>
        </div>
        <h2>About This Tool</h2>
        <p>
            This YouTube Money Calculator is designed to help creators, marketers, and brands estimate their potential ad revenue with transparency and accuracy. It is regularly updated with the latest RPM data and supports all countries and YouTube categories. For feedback or suggestions, please contact our support team.
        </p>
    </div>
</div>

<?php
// Include footer
include $_SERVER['DOCUMENT_ROOT'] . '/admin/footer.php';
?>
