<?php
// --- Meta for SEO ---
$page_title = "YouTube Shorts Revenue Calculator: Estimate Your Earnings";

$page_description = "Calculate your YouTube Shorts earnings instantly. Get accurate revenue estimates by country, niche, and views. Free, fast, and trusted by creators worldwide.";

$page_author = "Gwaa";
$page_keywords = "YouTube Shorts Revenue Calculator, YouTube Shorts earnings, YouTube Shorts RPM, YouTube Shorts CPM, YouTube Shorts ad revenue, YouTube Shorts monetization, YouTube Shorts RPM by country, YouTube Shorts RPM by niche, YouTube Shorts income estimator, YouTube Shorts calculator";

// --- All ISO 3166-1 countries (from template) ---
$countries = [
    "AF" => "Afghanistan", "AX" => "Åland Islands", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas (the)", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia (Plurinational State of)", "BQ" => "Bonaire, Sint Eustatius and Saba", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "IO" => "British Indian Ocean Territory (the)", "BN" => "Brunei Darussalam", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "CV" => "Cabo Verde", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "KY" => "Cayman Islands (the)", "CF" => "Central African Republic (the)", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos (Keeling) Islands (the)", "CO" => "Colombia", "KM" => "Comoros (the)", "CD" => "Congo (the Democratic Republic of the)", "CG" => "Congo (the)", "CK" => "Cook Islands (the)", "CR" => "Costa Rica", "CI" => "Côte d'Ivoire", "HR" => "Croatia", "CU" => "Cuba", "CW" => "Curaçao", "CY" => "Cyprus", "CZ" => "Czechia", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic (the)", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "SZ" => "Eswatini", "ET" => "Ethiopia", "FK" => "Falkland Islands (the) [Malvinas]", "FO" => "Faroe Islands (the)", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories (the)", "GA" => "Gabon", "GM" => "Gambia (the)", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "VA" => "Holy See (the)", "HN" => "Honduras", "HK" => "Hong Kong", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran (Islamic Republic of)", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KP" => "Korea (the Democratic People's Republic of)", "KR" => "Korea (the Republic of)", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Lao People's Democratic Republic (the)", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macao", "MK" => "Republic of North Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands (the)", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "MX" => "Mexico", "FM" => "Micronesia (Federated States of)", "MD" => "Moldova (the Republic of)", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands (the)", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger (the)", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "MP" => "Northern Mariana Islands (the)", "NO" => "Norway", "OM" => "Oman", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestine, State of", "PA" => "Panama", "PG" => "Papua New Guinea", "PY" => "Paraguay", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RE" => "Réunion", "RO" => "Romania", "RU" => "Russian Federation", "RW" => "Rwanda", "BL" => "Saint Barthélemy", "SH" => "Saint Helena, Ascension and Tristan da Cunha", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin (French part)", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "ST" => "Sao Tome and Principe", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SX" => "Sint Maarten (Dutch part)", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "SS" => "South Sudan", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syrian Arab Republic", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania, United Republic of", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TV" => "Tuvalu", "UG" => "Uganda", "UA" => "Ukraine", "AE" => "United Arab Emirates", "GB" => "United Kingdom of Great Britain and Northern Ireland", "US" => "United States of America", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VE" => "Venezuela (Bolivarian Republic of)", "VN" => "Viet Nam", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe"
];

// --- RPM values by country (USD, 2025 Shorts averages) ---
$country_rpm = [
    "AF" => 0.06, "AX" => 0.02, "AL" => 0.03, "DZ" => 0.04, "AS" => 0.02, "AD" => 0.05, "AO" => 0.02, "AI" => 0.03, "AQ" => 0.00, "AG" => 0.03, "AR" => 0.05, "AM" => 0.04, "AW" => 0.03, "AU" => 0.11, "AT" => 0.09, "AZ" => 0.03, "BS" => 0.04, "BH" => 0.05, "BD" => 0.01, "BB" => 0.03, "BY" => 0.03, "BE" => 0.08, "BZ" => 0.03, "BJ" => 0.02, "BM" => 0.04, "BT" => 0.02, "BO" => 0.03, "BQ" => 0.03, "BA" => 0.03, "BW" => 0.03, "BV" => 0.00, "BR" => 0.04, "IO" => 0.02, "BN" => 0.05, "BG" => 0.03, "BF" => 0.02, "BI" => 0.02, "CV" => 0.02, "KH" => 0.02, "CM" => 0.02, "CA" => 0.09, "KY" => 0.04, "CF" => 0.02, "TD" => 0.02, "CL" => 0.04, "CN" => 0.04, "CX" => 0.02, "CC" => 0.02, "CO" => 0.04, "KM" => 0.02, "CD" => 0.02, "CG" => 0.02, "CK" => 0.02, "CR" => 0.04, "CI" => 0.02, "HR" => 0.04, "CU" => 0.02, "CW" => 0.03, "CY" => 0.05, "CZ" => 0.05, "DK" => 0.09, "DJ" => 0.02, "DM" => 0.03, "DO" => 0.04, "EC" => 0.04, "EG" => 0.02, "SV" => 0.03, "GQ" => 0.02, "ER" => 0.02, "EE" => 0.04, "SZ" => 0.02, "ET" => 0.02, "FK" => 0.00, "FO" => 0.03, "FJ" => 0.03, "FI" => 0.08, "FR" => 0.08, "GF" => 0.03, "PF" => 0.03, "TF" => 0.00, "GA" => 0.02, "GM" => 0.02, "GE" => 0.03, "DE" => 0.10, "GH" => 0.03, "GI" => 0.03, "GR" => 0.05, "GL" => 0.03, "GD" => 0.03, "GP" => 0.03, "GU" => 0.03, "GT" => 0.03, "GG" => 0.03, "GN" => 0.02, "GW" => 0.02, "GY" => 0.03, "HT" => 0.02, "HM" => 0.00, "VA" => 0.00, "HN" => 0.03, "HK" => 0.06, "HU" => 0.05, "IS" => 0.05, "IN" => 0.01, "ID" => 0.01, "IR" => 0.04, "IQ" => 0.03, "IE" => 0.08, "IM" => 0.03, "IL" => 0.07, "IT" => 0.07, "JM" => 0.04, "JP" => 0.07, "JE" => 0.03, "JO" => 0.04, "KZ" => 0.04, "KE" => 0.03, "KI" => 0.02, "KP" => 0.00, "KR" => 0.07, "KW" => 0.06, "KG" => 0.03, "LA" => 0.02, "LV" => 0.05, "LB" => 0.04, "LS" => 0.02, "LR" => 0.02, "LY" => 0.03, "LI" => 0.05, "LT" => 0.05, "LU" => 0.06, "MO" => 0.04, "MK" => 0.03, "MG" => 0.02, "MW" => 0.02, "MY" => 0.05, "MV" => 0.04, "ML" => 0.02, "MT" => 0.05, "MH" => 0.02, "MQ" => 0.03, "MR" => 0.02, "MU" => 0.04, "YT" => 0.02, "MX" => 0.06, "FM" => 0.02, "MD" => 0.03, "MC" => 0.05, "MN" => 0.03, "ME" => 0.03, "MS" => 0.03, "MA" => 0.03, "MZ" => 0.02, "MM" => 0.02, "NA" => 0.03, "NR" => 0.02, "NP" => 0.02, "NL" => 0.09, "NC" => 0.03, "NZ" => 0.09, "NI" => 0.03, "NE" => 0.02, "NG" => 0.03, "NU" => 0.02, "NF" => 0.02, "MP" => 0.03, "NO" => 0.11, "OM" => 0.05, "PK" => 0.01, "PW" => 0.02, "PS" => 0.03, "PA" => 0.04, "PG" => 0.02, "PY" => 0.03, "PE" => 0.04, "PH" => 0.02, "PN" => 0.00, "PL" => 0.07, "PT" => 0.07, "PR" => 0.06, "QA" => 0.06, "RE" => 0.03, "RO" => 0.05, "RU" => 0.04, "RW" => 0.02, "BL" => 0.03, "SH" => 0.02, "KN" => 0.03, "LC" => 0.03, "MF" => 0.03, "PM" => 0.02, "VC" => 0.03, "WS" => 0.02, "SM" => 0.04, "ST" => 0.02, "SA" => 0.07, "SN" => 0.02, "RS" => 0.03, "SC" => 0.03, "SL" => 0.02, "SG" => 0.07, "SX" => 0.03, "SK" => 0.05, "SI" => 0.05, "SB" => 0.02, "SO" => 0.02, "ZA" => 0.05, "GS" => 0.00, "SS" => 0.02, "ES" => 0.07, "LK" => 0.02, "SD" => 0.02, "SR" => 0.02, "SJ" => 0.02, "SE" => 0.09, "CH" => 0.09, "SY" => 0.02, "TW" => 0.05, "TJ" => 0.02, "TZ" => 0.02, "TH" => 0.04, "TL" => 0.02, "TG" => 0.02, "TK" => 0.02, "TO" => 0.02, "TT" => 0.03, "TN" => 0.03, "TR" => 0.04, "TM" => 0.02, "TV" => 0.02, "UG" => 0.02, "UA" => 0.04, "AE" => 0.08, "GB" => 0.10, "US" => 0.12, "UY" => 0.04, "UZ" => 0.03, "VU" => 0.02, "VE" => 0.03, "VN" => 0.02, "EH" => 0.02, "YE" => 0.02, "ZM" => 0.02, "ZW" => 0.02
];

// --- YouTube Shorts Niches (2025, deep research, all possible) ---
$shorts_niche_rpm = [
    // High RPM Niches
    "Make Money Online" => 0.20,
    "Finance & Investing" => 0.18,
    "Business & Entrepreneurship" => 0.14,
    "Digital Marketing" => 0.13,
    "Crypto & NFTs" => 0.15,
    "Affiliate Marketing" => 0.13,
    "Personal Finance" => 0.16,
    "Ecommerce & Dropshipping" => 0.12,
    "Tech Reviews & Gadgets" => 0.10,
    "Software & App Reviews" => 0.10,
    "Online Education" => 0.09,
    "Career Advice" => 0.09,
    "Legal Advice" => 0.11,
    "Real Estate" => 0.12,
    "AI & Machine Learning" => 0.10,
    "Productivity & Self-Improvement" => 0.09,
    // Medium RPM Niches
    "Health & Fitness" => 0.08,
    "Weight Loss & Diet" => 0.08,
    "Yoga & Meditation" => 0.07,
    "Bodybuilding" => 0.07,
    "Travel & Lifestyle" => 0.08,
    "Luxury Travel" => 0.09,
    "Food & Cooking" => 0.06,
    "Restaurant Reviews" => 0.06,
    "Parenting & Family" => 0.05,
    "Parenting (Special Needs)" => 0.06,
    "Pets & Animals" => 0.07,
    "Pet Care & Training" => 0.07,
    "Gardening & Homesteading" => 0.05,
    "DIY & Crafts" => 0.06,
    "Home Decor & Organization" => 0.06,
    "Minimalism" => 0.06,
    "Sustainable Living" => 0.06,
    "Science & Technology" => 0.08,
    "Motivation & Philosophy" => 0.07,
    "Study Tips & Education" => 0.08,
    "Language Learning" => 0.07,
    "Book Reviews" => 0.06,
    "Book Summaries" => 0.06,
    "Art & Illustration" => 0.07,
    "Photography Tutorials" => 0.07,
    "Animation & Motion Graphics" => 0.07,
    "Event Planning" => 0.07,
    "College & Student Life" => 0.06,
    "Adventure Sports" => 0.08,
    "Home Improvement" => 0.07,
    "Interior Design" => 0.07,
    "Fashion & Beauty" => 0.09,
    "Makeup Tutorials" => 0.09,
    "Shopping Hauls" => 0.08,
    "Vegan & Plant-Based Living" => 0.07,
    "Mental Health & Self-Care" => 0.07,
    "Astrology & Spirituality" => 0.05,
    "Luxury Lifestyle" => 0.10,
    // Lower RPM Niches
    "Music" => 0.03,
    "Educational Music" => 0.04,
    "Gaming" => 0.05,
    "Mobile Gaming" => 0.04,
    "Motorsports" => 0.06,
    "Sports" => 0.05,
    "Comedy & Skits" => 0.03,
    "Entertainment" => 0.03,
    "People & Blogs" => 0.03,
    "Vlogging" => 0.04,
    "Reactions & Commentary" => 0.03,
    "Short Movies" => 0.03,
    "Film & Animation" => 0.04,
    "News & Politics" => 0.03,
    "Nonprofits & Activism" => 0.02,
    "Shows" => 0.03,
    "Movies" => 0.03,
    "General / No Niche" => 0.02,
    "Viral Challenges" => 0.03,
    "Pranks" => 0.03,
    "Memes & Viral Content" => 0.03,
    "Meme Pages" => 0.03,
    "Fan Pages" => 0.02,
    "Horoscopes" => 0.03,
    "Street Photography" => 0.04,
    "Reaction Memes" => 0.03,
    "General Vlogs" => 0.03,
    "Street Interviews" => 0.03,
    "Fandoms & Pop Culture" => 0.03,
    "ASMR" => 0.03,
    "Unusual Hobbies" => 0.03,
    "Local News" => 0.02,
    "YouTube Shorts Growth" => 0.04,
    "Other" => 0.02
];
$shorts_niches = array_keys($shorts_niche_rpm);

function get_rpm($country_code, $niche) {
    global $country_rpm, $shorts_niche_rpm;
    $country_val = $country_rpm[$country_code] ?? 0.02;
    $niche_val = $shorts_niche_rpm[$niche] ?? 0.02;
    return round(($country_val + $niche_val) / 2, 4);
}

// AJAX handler for calculator
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    global $shorts_niche_rpm;
    $views = isset($_POST['yt_views']) ? (int)$_POST['yt_views'] : 0;
    $country = $_POST['yt_country'] ?? 'US';
    $niche = isset($_POST['yt_niche']) ? htmlspecialchars_decode($_POST['yt_niche']) : 'Other';
    $music_tracks = isset($_POST['yt_music']) ? (int)$_POST['yt_music'] : 0;
    $country_val = $country_rpm[$country] ?? 0.02;
    $niche_val = $shorts_niche_rpm[$niche] ?? $shorts_niche_rpm["Other"];
    $rpm = round(max(($country_val + $niche_val) / 2, 0.01), 4);

    // Music deduction: 0 tracks = 1.0, 1 track = 0.5, 2+ tracks = 0.33
    $music_factor = 1.0;
    if ($music_tracks === 1) $music_factor = 0.5;
    if ($music_tracks >= 2) $music_factor = 0.33;

    $pre_split = ($views / 1000) * $rpm * $music_factor;
    $estimated_earnings = $pre_split * 0.45; // 45% creator share

    $results = [
        'views' => number_format($views),
        'country' => $countries[$country] ?? htmlspecialchars($country),
        'niche' => $niche,
        'rpm' => '$' . number_format($rpm, 4),
        'music_factor' => $music_factor,
        'earnings' => '$' . number_format($estimated_earnings, 2)
    ];
    ?>
    <div class="result-card">
      <div class="result-meta">Estimated YouTube Shorts Earnings</div>
      <div class="result-earnings"><?= $results['earnings'] ?></div>
      <div class="result-details">
        <div class="result-row">
          <span class="result-label">Shorts Views</span>
          <span class="result-value"><?= $results['views'] ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Country</span>
          <span class="result-value"><?= htmlspecialchars($results['country']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Niche</span>
          <span class="result-value"><?= htmlspecialchars($results['niche']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Estimated RPM</span>
          <span class="result-value"><?= $results['rpm'] ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Music Tracks</span>
          <span class="result-value"><?= $music_tracks ?></span>
        </div>
      </div>
    </div>
    <?php
    exit;
}

include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<html>
    <head>
     <link rel="stylesheet" href="/assets/css/plugins.css" />
  <link rel="stylesheet" href="/assets/css/base.css" />


  <link rel="stylesheet" href="/assets/css/style.css" />
  <link rel="preload" href="/assets/css/fonts/space.css" as="style" onload="this.rel='stylesheet'" /> 
  
  <style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* TikTok Calculator Form Inputs and Button */
form#yt-shorts-form input.form-control,
form#yt-shorts-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#yt-shorts-form button#yt-shorts-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}

/* Result Card Styling */
.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}
.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}
.result-meta {
  font-weight: bold;
  font-size: 1.3rem;
  color: #2a3a5c;
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0;
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}
.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}
.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}
.result-label {
  font-weight: 700;
  color: #2a3a5c;
}
.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive adjustments */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
  #modal-loader-overlay {
    /* Ensure loader covers full viewport on mobile */
    align-items: center;
    justify-content: center;
  }
}

/* Feature checklist styling */
.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}
.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}
.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}
@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;
  overflow-wrap: break-word;
  white-space: normal;
}
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem;
  text-align: center;
}
</style>

</head>
<body>
  
  
  
<div class="content-wrapper">

  <!-- Loader Overlay -->
  <div id="modal-loader-overlay">
    <div class="loader-content">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
      <span class="loader-text">Calculating Revenue...</span>
    </div>
  </div>

  <!-- HERO + CALCULATOR FORM -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">
          <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
          YouTube Shorts Revenue Calculator <span class="underline-3 style-1 primary"></span>
        </h1>
        <h3 class="lead fs-20 lh-sm mb-4 mt-5">
          Instantly estimate your YouTube Shorts earnings by country, niche, and views. Discover your real earning potential from YouTube’s fastest-growing video format—no guesswork, just real numbers.
        </h3>

          <form id="yt-shorts-form" method="POST" action="#">
  <div class="row g-3 align-items-center">
    <div class="col-md-6 mb-3 mb-md-0">
      <input
        type="number"
        class="form-control"
        id="yt_views"
        name="yt_views"
        placeholder="Shorts Views"
        min="0"
        required
        value="<?= isset($_POST['yt_views']) ? htmlspecialchars($_POST['yt_views']) : '' ?>"
      >
      <small class="form-text text-muted">Enter your YouTube Shorts views</small>
    </div>
    <div class="col-md-6 mb-3 mb-md-0">
      <select class="form-control" id="yt_country" name="yt_country" required>
        <?php foreach ($countries as $code => $name): ?>
          <option value="<?= htmlspecialchars($code) ?>" <?= (isset($_POST['yt_country']) && $_POST['yt_country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
        <?php endforeach; ?>
      </select>
      <small class="form-text text-muted">Select your audience country</small>
    </div>
  </div>
  <div class="row g-3 align-items-center mt-0">
    <div class="col-md-6 mb-3 mb-md-0">
      <select class="form-control" id="yt_niche" name="yt_niche" required>
        <?php foreach ($shorts_niches as $n): ?>
          <option value="<?= htmlspecialchars($n, ENT_QUOTES, 'UTF-8') ?>" <?= (isset($_POST['yt_niche']) && $_POST['yt_niche'] == $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
        <?php endforeach; ?>
      </select>
      <small class="form-text text-muted">Choose your Shorts content niche</small>
    </div>
    <div class="col-md-6">
      <select class="form-control" id="yt_music" name="yt_music" required>
        <option value="0">No Music</option>
        <option value="1">1 Music Track</option>
        <option value="2">2+ Music Tracks</option>
      </select>
      <small class="form-text text-muted">How many music tracks in your Short?</small>
    </div>
  </div>
  <div class="mt-4"></div>
  <button
    class="btn mt-4"
    type="submit"
    id="yt-shorts-btn"
  >
    Calculate Earnings
  </button>
</form>


          <div id="yt-shorts-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite"></div>
        </div>
      </div>
    </div>
  </section>

  <!-- PROCESS STEPS (CTA) -->
 <section class="wrapper">
  <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
    <h2 class="display-4 mb-3">How to Use the YouTube Shorts Revenue Calculator</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6 process-wrapper line mt-5">
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">01</span></span>
        <h4 class="mb-1">Enter Your Shorts Stats</h4>
        <p class="mb-0">
          Add your monthly Shorts views, select your country and content niche, and include any extra revenue like Super Thanks or brand deals. The more accurate your stats, the more precise your estimate.
        </p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-primary pe-none mb-4"><span class="number">02</span></span>
        <h4 class="mb-1">Get Instant Revenue Estimates</h4>
        <p class="mb-0">
          The calculator uses up-to-date Shorts RPMs for your country and niche, applies YouTube’s revenue share, and instantly projects your monthly and yearly Shorts income.
        </p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">03</span></span>
        <h4 class="mb-1">Plan Your Shorts Strategy</h4>
        <p class="mb-0">
          Use your results to set Shorts-specific goals, optimize upload frequency, and unlock new monetization streams. Track your progress and make smarter content decisions.
        </p>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Tip:</strong> Use the calculator to compare Shorts and long-form revenue. See which format brings you the best ROI!
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper">
  <div class="container pt-2 pb-5 text-center">
    <p class="lead fs-18 lh-sm mb-4">
      The YouTube Shorts Revenue Calculator is built for creators, brands, and agencies who want to understand and maximize their Shorts income. Whether you’re just starting or already viral, use it to benchmark your growth, plan your content, and set realistic financial goals.
    </p>
    <div class="row justify-content-center">
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Calculates Shorts ad revenue and Super Thanks</li>
          <li>Customizes for every country, niche, and view count</li>
          <li>Shows Shorts RPM and CPM for 2025</li>
          <li>Works for all channel sizes and engagement rates</li>
          <li>No login, no limits, and no hidden fees</li>
        </ul>
      </div>
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Benchmarks against top Shorts creators</li>
          <li>Mobile and desktop friendly</li>
          <li>Updated for YouTube’s latest Shorts monetization rules</li>
          <li>Private and secure—your data is never stored</li>
          <li>Trusted by creators, brands, and agencies worldwide</li>
        </ul>
      </div>
    </div>
    <div class="alert alert-success p-4 fs-17 mt-4">
      <strong>Ready to see your Shorts earning power?</strong> Enter your stats and get an instant, data-driven projection!
    </div>
  </div>
</section>

<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">How YouTube Shorts Revenue Is Calculated</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Shorts Ad Revenue Pool</h5>
          <p class="mb-0">
            YouTube collects ad revenue from all Shorts, then distributes it to creators based on their share of total Shorts views. The calculator uses the latest RPM data for your country and niche to estimate your payout.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Super Thanks & Brand Deals</h5>
          <p class="mb-0">
            Shorts creators can also earn from Super Thanks and brand partnerships. Add these to your stats for a complete revenue picture—especially if your Shorts go viral.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Country & Niche Impact</h5>
          <p class="mb-0">
            RPMs vary widely by country and topic. Finance, tech, and gaming Shorts in the US, UK, or Canada earn the highest rates. The calculator adjusts for these differences automatically.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Did you know?</strong> Shorts RPMs are rising every year as more advertisers target short-form video. Now is the best time to go all-in on Shorts!
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
    <h2 class="display-4 mb-3">Tips to Maximize Your YouTube Shorts Revenue</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="bi bi-check"></i><strong>Hook Viewers Fast:</strong> The first 2 seconds are everything. Use bold visuals and captions to grab attention immediately.</li>
          <li><i class="bi bi-check"></i><strong>Ride the Trends:</strong> Use trending sounds, hashtags, and challenges to boost your Shorts’ discoverability.</li>
          <li><i class="bi bi-check"></i><strong>Batch Create:</strong> Film multiple Shorts in one session for consistent uploads and algorithm love.</li>
          <li><i class="bi bi-check"></i><strong>Test Different Lengths:</strong> Try 10s, 30s, and 59s Shorts to see what drives the most engagement and revenue.</li>
          <li><i class="bi bi-check"></i><strong>Promote Across Platforms:</strong> Share your Shorts on Instagram Reels and TikTok to grow your audience everywhere.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="bi bi-check"></i><strong>Encourage Engagement:</strong> Ask viewers to like, comment, and subscribe at the end of every Short.</li>
          <li><i class="bi bi-check"></i><strong>Analyze Analytics:</strong> Use YouTube Studio to track Shorts RPM, watch time, and retention. Double down on what works.</li>
          <li><i class="bi bi-check"></i><strong>Collaborate:</strong> Partner with other Shorts creators for duets, remixes, or shoutouts.</li>
          <li><i class="bi bi-check"></i><strong>Monetize Early:</strong> Enable Super Thanks and look for brand deals as soon as you qualify.</li>
          <li><i class="bi bi-check"></i><strong>Stay Consistent:</strong> Uploading daily or several times a week keeps you in the Shorts feed and maximizes revenue.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Did you know?</strong> The top 1% of Shorts creators upload at least 20 Shorts per month. Consistency and experimentation are key to unlocking viral growth and higher payouts.
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-gradient-primary">
  <div class="container pt-10 pt-md-12">
    <h2 class="display-4 mb-3">Frequently Asked Questions</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionLeft">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading1">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
                How is YouTube Shorts revenue calculated?
              </button>
            </h2>
            <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Shorts revenue comes from a global ad pool, divided among creators based on their share of total Shorts views. Your payout depends on your country, niche, and engagement. The calculator uses the latest RPM data for 2025.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading2">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
                Is Shorts RPM lower than long-form video RPM?
              </button>
            </h2>
            <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Yes, Shorts RPM is usually lower than long-form, but top Shorts can still earn thousands per month thanks to massive reach and viral potential.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading3">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
                Can I monetize Shorts in any country?
              </button>
            </h2>
            <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Shorts monetization is available in most countries, but RPMs and eligibility may vary. Always check YouTube’s latest policy for your region.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading4">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
                Do Super Thanks and brand deals count as Shorts revenue?
              </button>
            </h2>
            <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Yes! Add your Super Thanks and brand deal income to the calculator for a full picture of your Shorts earnings.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading5">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
                How many Shorts do I need to upload to earn $1,000/month?
              </button>
            </h2>
            <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  It depends on your RPM and views. For example, at a $1 RPM, you’d need 1 million Shorts views per month. Use the calculator to set your own goals based on your niche and country.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionRight">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading6">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
                Can I use the calculator for multiple channels?
              </button>
            </h2>
            <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Absolutely! Use the calculator as often as you like for any number of channels or Shorts. It’s free and unlimited.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading7">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
                Is my data private and secure?
              </button>
            </h2>
            <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  100%. The calculator does not store, share, or log any user data. All calculations happen instantly and privately in your browser session.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading8">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
                What’s a good RPM for Shorts in 2025?
              </button>
            </h2>
            <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  RPMs vary, but $0.50–$2.50 is typical. Top niches and countries can see $3+ RPM. Use the calculator to benchmark your own results.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading9">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
                Do Shorts views count toward long-form monetization?
              </button>
            </h2>
            <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Shorts views do not count toward the 4,000 watch hours for long-form monetization, but 10 million Shorts views in 90 days can qualify you for the YouTube Partner Program.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading10">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse10" aria-expanded="false" aria-controls="faqCollapse10">
                Where can I learn more about Shorts monetization?
              </button>
            </h2>
            <div id="faqCollapse10" class="accordion-collapse collapse" aria-labelledby="faqHeading10" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Visit the YouTube Creator Academy or our blog for in-depth guides, algorithm updates, and the latest Shorts monetization strategies for 2025 and beyond.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row mt-6">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-primary p-4 fs-17">
            <strong>Still have questions?</strong> Reach out to our expert team anytime. We’re here to help you grow your YouTube Shorts channel and income!
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
</div>

</body>
</html>

<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
  var form = document.getElementById('yt-shorts-form');
  var loader = document.getElementById('modal-loader-overlay');
  var results = document.getElementById('yt-shorts-results-area');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      if (loader) loader.style.display = 'flex';
      if (results) results.innerHTML = '';
      var formData = new FormData(form);
      formData.append('ajax', '1');
      fetch(form.action, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.text())
      .then(html => {
        setTimeout(function() {
          if (loader) loader.style.display = 'none';
          results.innerHTML = html;
          results.style.display = 'flex';
        }, 2500);
      })
      .catch(function() {
        if (loader) loader.style.display = 'none';
        if (results) results.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
      });
    });
  }
});
</script>
