<?php
function is_ajax_request() {
    return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
}


// 60 characters CTA title
$page_title = "YouTube Money Calculator: Instantly Estimate Your Earnings";

// Description (max ~160 characters, SEO-optimized)
$page_description = "Estimate your YouTube earnings instantly with our free YouTube Money Calculator. Enter your stats to see your ad revenue, RPM, and channel income.";

// Keywords (comma-separated, SEO-focused)
$page_keywords = "YouTube Money Calculator, YouTube revenue estimator, YouTube earnings, YouTube RPM, YouTube CPM, YouTube ad revenue, YouTube income calculator, YouTube monetization, YouTube channel calculator";


$page_author = "Instablogs";


// --- All ISO 3166-1 countries ---
$countries = [
    "AF" => "Afghanistan",
    "AX" => "Åland Islands",
    "AL" => "Albania",
    "DZ" => "Algeria",
    "AS" => "American Samoa",
    "AD" => "Andorra",
    "AO" => "Angola",
    "AI" => "Anguilla",
    "AQ" => "Antarctica",
    "AG" => "Antigua and Barbuda",
    "AR" => "Argentina",
    "AM" => "Armenia",
    "AW" => "Aruba",
    "AU" => "Australia",
    "AT" => "Austria",
    "AZ" => "Azerbaijan",
    "BS" => "Bahamas (the)",
    "BH" => "Bahrain",
    "BD" => "Bangladesh",
    "BB" => "Barbados",
    "BY" => "Belarus",
    "BE" => "Belgium",
    "BZ" => "Belize",
    "BJ" => "Benin",
    "BM" => "Bermuda",
    "BT" => "Bhutan",
    "BO" => "Bolivia (Plurinational State of)",
    "BQ" => "Bonaire, Sint Eustatius and Saba",
    "BA" => "Bosnia and Herzegovina",
    "BW" => "Botswana",
    "BV" => "Bouvet Island",
    "BR" => "Brazil",
    "IO" => "British Indian Ocean Territory (the)",
    "BN" => "Brunei Darussalam",
    "BG" => "Bulgaria",
    "BF" => "Burkina Faso",
    "BI" => "Burundi",
    "CV" => "Cabo Verde",
    "KH" => "Cambodia",
    "CM" => "Cameroon",
    "CA" => "Canada",
    "KY" => "Cayman Islands (the)",
    "CF" => "Central African Republic (the)",
    "TD" => "Chad",
    "CL" => "Chile",
    "CN" => "China",
    "CX" => "Christmas Island",
    "CC" => "Cocos (Keeling) Islands (the)",
    "CO" => "Colombia",
    "KM" => "Comoros (the)",
    "CD" => "Congo (the Democratic Republic of the)",
    "CG" => "Congo (the)",
    "CK" => "Cook Islands (the)",
    "CR" => "Costa Rica",
    "CI" => "Côte d'Ivoire",
    "HR" => "Croatia",
    "CU" => "Cuba",
    "CW" => "Curaçao",
    "CY" => "Cyprus",
    "CZ" => "Czechia",
    "DK" => "Denmark",
    "DJ" => "Djibouti",
    "DM" => "Dominica",
    "DO" => "Dominican Republic (the)",
    "EC" => "Ecuador",
    "EG" => "Egypt",
    "SV" => "El Salvador",
    "GQ" => "Equatorial Guinea",
    "ER" => "Eritrea",
    "EE" => "Estonia",
    "SZ" => "Eswatini",
    "ET" => "Ethiopia",
    "FK" => "Falkland Islands (the) [Malvinas]",
    "FO" => "Faroe Islands (the)",
    "FJ" => "Fiji",
    "FI" => "Finland",
    "FR" => "France",
    "GF" => "French Guiana",
    "PF" => "French Polynesia",
    "TF" => "French Southern Territories (the)",
    "GA" => "Gabon",
    "GM" => "Gambia (the)",
    "GE" => "Georgia",
    "DE" => "Germany",
    "GH" => "Ghana",
    "GI" => "Gibraltar",
    "GR" => "Greece",
    "GL" => "Greenland",
    "GD" => "Grenada",
    "GP" => "Guadeloupe",
    "GU" => "Guam",
    "GT" => "Guatemala",
    "GG" => "Guernsey",
    "GN" => "Guinea",
    "GW" => "Guinea-Bissau",
    "GY" => "Guyana",
    "HT" => "Haiti",
    "HM" => "Heard Island and McDonald Islands",
    "VA" => "Holy See (the)",
    "HN" => "Honduras",
    "HK" => "Hong Kong",
    "HU" => "Hungary",
    "IS" => "Iceland",
    "IN" => "India",
    "ID" => "Indonesia",
    "IR" => "Iran (Islamic Republic of)",
    "IQ" => "Iraq",
    "IE" => "Ireland",
    "IM" => "Isle of Man",
    "IL" => "Israel",
    "IT" => "Italy",
    "JM" => "Jamaica",
    "JP" => "Japan",
    "JE" => "Jersey",
    "JO" => "Jordan",
    "KZ" => "Kazakhstan",
    "KE" => "Kenya",
    "KI" => "Kiribati",
    "KP" => "Korea (the Democratic People's Republic of)",
    "KR" => "Korea (the Republic of)",
    "KW" => "Kuwait",
    "KG" => "Kyrgyzstan",
    "LA" => "Lao People's Democratic Republic (the)",
    "LV" => "Latvia",
    "LB" => "Lebanon",
    "LS" => "Lesotho",
    "LR" => "Liberia",
    "LY" => "Libya",
    "LI" => "Liechtenstein",
    "LT" => "Lithuania",
    "LU" => "Luxembourg",
    "MO" => "Macao",
    "MK" => "Republic of North Macedonia",
    "MG" => "Madagascar",
    "MW" => "Malawi",
    "MY" => "Malaysia",
    "MV" => "Maldives",
    "ML" => "Mali",
    "MT" => "Malta",
    "MH" => "Marshall Islands (the)",
    "MQ" => "Martinique",
    "MR" => "Mauritania",
    "MU" => "Mauritius",
    "YT" => "Mayotte",
    "MX" => "Mexico",
    "FM" => "Micronesia (Federated States of)",
    "MD" => "Moldova (the Republic of)",
    "MC" => "Monaco",
    "MN" => "Mongolia",
    "ME" => "Montenegro",
    "MS" => "Montserrat",
    "MA" => "Morocco",
    "MZ" => "Mozambique",
    "MM" => "Myanmar",
    "NA" => "Namibia",
    "NR" => "Nauru",
    "NP" => "Nepal",
    "NL" => "Netherlands (the)",
    "NC" => "New Caledonia",
    "NZ" => "New Zealand",
    "NI" => "Nicaragua",
    "NE" => "Niger (the)",
    "NG" => "Nigeria",
    "NU" => "Niue",
    "NF" => "Norfolk Island",
    "MP" => "Northern Mariana Islands (the)",
    "NO" => "Norway",
    "OM" => "Oman",
    "PK" => "Pakistan",
    "PW" => "Palau",
    "PS" => "Palestine, State of",
    "PA" => "Panama",
    "PG" => "Papua New Guinea",
    "PY" => "Paraguay",
    "PE" => "Peru",
    "PH" => "Philippines",
    "PN" => "Pitcairn",
    "PL" => "Poland",
    "PT" => "Portugal",
    "PR" => "Puerto Rico",
    "QA" => "Qatar",
    "RE" => "Réunion",
    "RO" => "Romania",
    "RU" => "Russian Federation",
    "RW" => "Rwanda",
    "BL" => "Saint Barthélemy",
    "SH" => "Saint Helena, Ascension and Tristan da Cunha",
    "KN" => "Saint Kitts and Nevis",
    "LC" => "Saint Lucia",
    "MF" => "Saint Martin (French part)",
    "PM" => "Saint Pierre and Miquelon",
    "VC" => "Saint Vincent and the Grenadines",
    "WS" => "Samoa",
    "SM" => "San Marino",
    "ST" => "Sao Tome and Principe",
    "SA" => "Saudi Arabia",
    "SN" => "Senegal",
    "RS" => "Serbia",
    "SC" => "Seychelles",
    "SL" => "Sierra Leone",
    "SG" => "Singapore",
    "SX" => "Sint Maarten (Dutch part)",
    "SK" => "Slovakia",
    "SI" => "Slovenia",
    "SB" => "Solomon Islands",
    "SO" => "Somalia",
    "ZA" => "South Africa",
    "GS" => "South Georgia and the South Sandwich Islands",
    "SS" => "South Sudan",
    "ES" => "Spain",
    "LK" => "Sri Lanka",
    "SD" => "Sudan",
    "SR" => "Suriname",
    "SJ" => "Svalbard and Jan Mayen",
    "SE" => "Sweden",
    "CH" => "Switzerland",
    "SY" => "Syrian Arab Republic",
    "TW" => "Taiwan",
    "TJ" => "Tajikistan",
    "TZ" => "Tanzania, United Republic of",
    "TH" => "Thailand",
    "TL" => "Timor-Leste",
    "TG" => "Togo",
    "TK" => "Tokelau",
    "TO" => "Tonga",
    "TT" => "Trinidad and Tobago",
    "TN" => "Tunisia",
    "TR" => "Turkey",
    "TM" => "Turkmenistan",
    "TV" => "Tuvalu",
    "UG" => "Uganda",
    "UA" => "Ukraine",
    "AE" => "United Arab Emirates",
    "GB" => "United Kingdom of Great Britain and Northern Ireland",
    "US" => "United States of America",
    "UY" => "Uruguay",
    "UZ" => "Uzbekistan",
    "VU" => "Vanuatu",
    "VE" => "Venezuela (Bolivarian Republic of)",
    "VN" => "Viet Nam",
    "EH" => "Western Sahara",
    "YE" => "Yemen",
    "ZM" => "Zambia",
    "ZW" => "Zimbabwe"
];

// Example RPM values by country (USD)
$country_rpm = [
    "AF" => 3.11,
    "AX" => 0.35,
    "AL" => 0.74,
    "DZ" => 2.57,
    "AS" => 0.35,
    "AD" => 0.35,
    "AO" => 0.15,
    "AI" => 0.45,
    "AQ" => 0.00,
    "AG" => 0.45,
    "AR" => 0.77,
    "AM" => 3.91,
    "AW" => 0.00,
    "AU" => 36.21,
    "AT" => 16.86,
    "AZ" => 0.59,
    "BS" => 0.35,
    "BH" => 0.35,
    "BD" => 0.44,
    "BB" => 0.35,
    "BY" => 0.35,
    "BE" => 5.60,
    "BZ" => 0.35,
    "BJ" => 0.35,
    "BM" => 0.35,
    "BT" => 0.35,
    "BO" => 0.35,
    "BQ" => 0.35,
    "BA" => 0.35,
    "BW" => 0.35,
    "BV" => 0.00,
    "BR" => 1.14,
    "IO" => 0.35,
    "BN" => 0.35,
    "BG" => 1.50,
    "BF" => 0.35,
    "BI" => 0.35,
    "KH" => 0.35,
    "CM" => 0.35,
    "CA" => 13.50,
    "CV" => 0.35,
    "KY" => 0.35,
    "CF" => 0.35,
    "TD" => 0.35,
    "CL" => 0.35,
    "CN" => 0.35,
    "CX" => 0.00,
    "CC" => 0.00,
    "CO" => 0.35,
    "KM" => 0.35,
    "CD" => 0.35,
    "CG" => 0.35,
    "CK" => 0.35,
    "CR" => 0.35,
    "CI" => 0.35,
    "HR" => 1.67,
    "CU" => 0.35,
    "CW" => 0.35,
    "CY" => 0.35,
    "CZ" => 2.75,
    "DK" => 6.38,
    "DJ" => 0.35,
    "DM" => 0.45,
    "DO" => 0.35,
    "EC" => 1.00,
    "EG" => 0.46,
    "SV" => 0.35,
    "GQ" => 0.35,
    "ER" => 0.35,
    "EE" => 0.35,
    "SZ" => 0.35,
    "ET" => 0.35,
    "FK" => 0.00,
    "FO" => 0.35,
    "FJ" => 0.35,
    "FI" => 14.90,
    "FR" => 3.90,
    "GF" => 0.35,
    "PF" => 0.35,
    "TF" => 0.00,
    "GA" => 0.35,
    "GM" => 0.35,
    "GE" => 0.35,
    "DE" => 38.85,
    "GH" => 0.35,
    "GI" => 0.35,
    "GR" => 2.00,
    "GL" => 0.35,
    "GD" => 0.45,
    "GP" => 0.35,
    "GU" => 0.35,
    "GT" => 0.35,
    "GG" => 0.35,
    "GN" => 0.35,
    "GW" => 0.35,
    "GY" => 0.35,
    "HT" => 0.35,
    "HM" => 0.00,
    "VA" => 0.00,
    "HN" => 0.35,
    "HK" => 2.85,
    "HU" => 1.80,
    "IS" => 0.35,
    "IN" => 0.83,
    "ID" => 0.74,
    "IR" => 5.67,
    "IQ" => 0.71,
    "IE" => 18.20,
    "IM" => 0.35,
    "IL" => 14.08,
    "IT" => 0.89, // Note: Some sources list Italy as high as $13.66, but $0.89 is the median for most creators.
    "JM" => 4.94,
    "JP" => 10.53,
    "JE" => 2.00,
    "JO" => 1.50,
    "KZ" => 1.77,
    "KE" => 0.35,
    "KI" => 0.35,
    "KP" => 0.00,
    "KR" => 8.88,
    "KW" => 6.56,
    "KG" => 1.23,
    "LA" => 5.09,
    "LV" => 6.60,
    "LB" => 1.70,
    "LS" => 0.35,
    "LR" => 2.00,
    "LY" => 4.69,
    "LI" => 1.00,
    "LT" => 6.86,
    "LU" => 0.35,
    "MO" => 1.25,
    "MK" => 1.27,
    "MG" => 0.50,
    "MW" => 0.35,
    "MY" => 1.40,
    "MV" => 2.01,
    "ML" => 8.41,
    "MT" => 5.34,
    "MH" => 0.35,
    "MQ" => 0.00,
    "MR" => 3.80,
    "MU" => 7.05,
    "YT" => 3.00,
    "MX" => 9.51,
    "FM" => 0.35,
    "MD" => 29.50,
    "MC" => 0.35,
    "MN" => 5.85,
    "ME" => 0.35,
    "MS" => 0.45,
    "MA" => 0.34,
    "MZ" => 6.78,
    "MM" => 1.22,
    "NA" => 2.00,
    "NR" => 0.35,
    "NP" => 2.14,
    "NL" => 17.77,
    "NC" => 1.33,
    "NZ" => 28.15,
    "NI" => 1.92,
    "NE" => 6.00,
    "NG" => 2.89,
    "NU" => 0.35,
    "NF" => 0.35,
    "MP" => 0.45,
    "NO" => 20.17,
    "OM" => 3.78,
    "PK" => 0.59,
    "PW" => 0.35,
    "PS" => 2.50,
    "PA" => 1.73,
    "PG" => 2.27,
    "PY" => 2.48,
    "PE" => 1.24,
    "PH" => 0.48,
    "PN" => 0.00,
    "PL" => 7.67,
    "PT" => 10.32,
    "PR" => 8.05,
    "QA" => 1.11,
    "RE" => 0.35,
    "RO" => 1.67,
    "RU" => 1.30,
    "RW" => 0.35,
    "BL" => 0.35,
    "SH" => 0.35,
    "KN" => 0.45,
    "LC" => 0.45,
    "MF" => 0.35,
    "PM" => 0.35,
    "VC" => 0.45,
    "WS" => 0.35,
    "SM" => 0.35,
    "ST" => 0.35,
    "SA" => 1.88,
    "SN" => 0.35,
    "RS" => 1.10,
    "SC" => 0.35,
    "SL" => 0.35,
    "SG" => 3.11,
    "SX" => 0.35,
    "SK" => 2.00,
    "SI" => 0.35,
    "SB" => 0.35,
    "SO" => 0.35,
    "ZA" => 1.46,
    "GS" => 0.00,
    "SS" => 0.35,
    "ES" => 2.69,
    "LK" => 0.55,
    "SD" => 0.35,
    "SR" => 0.35,
    "SJ" => 0.35,
    "SE" => 18.18,
    "CH" => 6.89,
    "SY" => 0.35,
    "TW" => 1.79,
    "TJ" => 0.35,
    "TZ" => 0.35,
    "TH" => 1.05,
    "TL" => 0.35,
    "TG" => 0.35,
    "TK" => 0.35,
    "TO" => 0.35,
    "TT" => 0.35,
    "TN" => 0.35,
    "TR" => 0.75,
    "TM" => 0.35,
    "TC" => 0.35,
    "TV" => 0.35,
    "UG" => 0.35,
    "UA" => 1.20,
    "AE" => 2.60,
    "GB" => 13.75,
    "US" => 13.00,
    "UM" => 0.00,
    "UY" => 0.35,
    "UZ" => 0.35,
    "VU" => 0.35,
    "VE" => 0.80,
    "VN" => 0.70,
    "VG" => 0.35,
    "VI" => 0.35,
    "WF" => 0.35,
    "EH" => 0.35,
    "YE" => 0.35,
    "ZM" => 0.35,
    "ZW" => 0.35
];



// Example RPM values by niche (USD)
$niche_rpm = [
    // High RPM Niches
    "Finance & Investing" => 25.0,           // $15–$40 [8][5][6]
    "Business / SEO / Blogging" => 20.0,     // $10–$50 [8][5]
    "Real Estate" => 18.0,                   // $13–$30 [8][6]
    "Law / Legal Commentary" => 20.0,        // $20+ [8]
    "Crypto & Web3" => 12.0,                 // $7–$25 [8]
    "Digital Marketing" => 13.0,             // $13–$15 [5]
    "Productivity & Tech Reviews" => 10.0,   // $5–$15 [8][6]
    "Online Education / Self-Improvement" => 9.0, // $7–$12 [8][6]
    "Insurance" => 15.0,                     // $10–$20 [6]
    "Motivation & Philosophy" => 7.0,        // $5–$10 [6]
    "Tutorials" => 8.0,                      // $3–$20 [7]
    "Career & Professional Development" => 8.0, // $5–$12 [6]
    "Science & Technology" => 7.0,           // $6–$10 [6][8]
    "Health & Fitness" => 6.0,               // $3–$10 [6][4][5]
    "Educational Content" => 7.0,            // $3–$8 [7][6]
    "Real Estate Insights" => 12.0,          // $10–$20 [8]
    "Personal Finance" => 10.0,              // $5–$12 [5][8]
    "Marketing & Social Media Tips" => 8.0,  // $6–$12 [6][8]
    // Medium RPM Niches
    "Food & Cooking" => 3.0,                 // $1–$3 [7][6]
    "Travel & Lifestyle" => 6.0,             // $3–$15 [6][7]
    "Automotive" => 5.0,                     // $3–$7 [6]
    "Tech & Gadgets" => 7.0,                 // $5–$10 [6]
    "Beauty & Makeup" => 4.0,                // $3–$10 [4][6]
    "Fashion" => 3.5,                        // $3–$7 [6]
    "Parenting & Family" => 2.5,             // $2–$5 [6]
    "Home Decor & Organization" => 3.0,      // $2–$5 [6]
    "DIY & Crafts" => 3.0,                   // $2–$5 [6]
    "Gardening & Homesteading" => 2.5,       // $2–$4 [6]
    "Book Reviews & Literature" => 2.0,      // $1–$4 [6]
    "Animation & Motion Graphics" => 2.5,    // $2–$5 [6]
    "Pets & Animals" => 3.0,                 // $2–$8 [4][6]
    "Sports" => 2.5,                         // $2–$5 [6]
    "ASMR" => 2.0,                           // $1–$3 [6]
    "Howto & Style" => 4.0,                  // $3–$6 [6]
    "Travel Vlogs" => 4.0,                   // $3–$7 [6]
    "Product Reviews" => 3.0,                // $2–$5 [6]
    "Unboxing" => 3.0,                       // $2–$5 [6]
    "Life Hacks & Productivity" => 5.0,      // $4–$8 [6]
    "Motivation & Self-Improvement" => 6.0,  // $5–$10 [6]
    "Science Experiments" => 5.0,            // $4–$8 [6]
    // Lower RPM Niches (high volume, lower RPM)
    "Music" => 1.0,                          // $0.25–$1 [8]
    "Gaming" => 2.0,                         // $1–$4 [8][6]
    "Comedy" => 2.0,                         // $1–$4 [8][6]
    "Entertainment" => 2.5,                  // $1–$5 [8][6]
    "People & Blogs" => 2.0,                 // $1–$4 [8][6]
    "Vlogging / Lifestyle" => 2.5,           // $1–$5 [8][6]
    "Reactions, Skits, Commentary" => 2.0,   // $1–$4 [8]
    "Short Movies" => 1.5,                   // $1–$3 [6]
    "Film & Animation" => 2.5,               // $2–$5 [6]
    "News & Politics" => 2.0,                // $1–$4 [6]
    "Nonprofits & Activism" => 1.0,          // $0.5–$2 [6]
    "Shows" => 1.5,                          // $1–$3 [6]
    "Movies" => 2.0,                         // $1–$4 [6]
   "Making Money Online" => 15.0,              // [9][10]
    "Side Hustles" => 13.0,                     // [9][10]
    "Dropshipping & Ecommerce" => 12.0,         // [10]
    "Affiliate Marketing" => 14.0,              // [10]
    "Stock Market & Investing" => 25.0,         // [6][10]
    "Credit Cards & Loans" => 18.0,             // [10]
    "Insurance Explained" => 15.0,              // [10]
    "Tech Education" => 18.0,                   // [7]
    "Artificial Intelligence & AI Tools" => 12.0, // [5][6]
    "Machine Learning" => 10.0,                 // [6]
    "Coding & Programming" => 8.0,              // [6]
    "Web Development" => 7.0,                   // [6]
    "SaaS & Software Reviews" => 9.0,           // [6]
    "Mobile Apps & Reviews" => 5.0,             // [6]
    "Motivational & Spiritual" => 5.0,          // [9]
    "Minimalism & Organization" => 4.0,         // [6]
    "Sustainable Living & Eco-Friendly" => 4.0, // [6]
    "Home Improvement & Renovation" => 5.0,     // [6]
    "Interior Design" => 4.0,                   // [6]
    "Street Food" => 2.5,                       // [4]
    "Restaurant Reviews" => 3.0,                // [4]
    "Cooking Challenges" => 3.0,                // [4]
    "Fashion Try-ons & Hauls" => 4.0,           // [4][9]
    "Shopping Hauls" => 3.0,                    // [4][9]
    "Beauty Tutorials" => 4.0,                  // [4]
    "Weight Loss & Diet" => 10.0,               // [4]
    "Yoga & Meditation" => 6.0,                 // [11]
    "Bodybuilding" => 7.0,                      // [11]
    "Fitness & Workout" => 7.0,                 // [11]
    "Travel Guides" => 7.0,                     // [6]
    "Budget Travel" => 6.0,                     // [6]
    "Luxury Travel" => 10.0,                    // [6]
    "Language Learning" => 6.0,                 // [6]
    "Study With Me" => 4.0,                     // [6]
    "Test Preparation" => 6.0,                  // [6]
    "Career Advice" => 8.0,                     // [6]
    "Job Interview Tips" => 7.0,                // [6]
    "Parenting Tips" => 3.0,                    // [6]
    "Kids' Content" => 2.0,                     // [6]
    "Educational Music" => 1.8,                 // [7]
    "Military Analysis" => 0.5,                 // [7]
    "True Crime" => 8.0,                        // [7]
    "History" => 4.0,                           // [7]
    "Book Summaries" => 2.5,                    // [6]
    "Storytelling" => 5.0,                      // [7]
    "Horror Movie Essays" => 10.0,              // [7]
    "Ufology & Paranormal" => 3.0,              // [7]
    "Sewing & Crafts" => 4.0,                   // [7]
    "Grand Theft Auto / Open World Gaming" => 4.5, // [7]
    "Mobile Gaming" => 3.0,                     // [7]
    "Esports" => 4.0,                           // [6]
    "Fantasy Sports" => 5.0,                    // [6]
    "Sports Analysis" => 4.0,                   // [6]
    "Pet Training" => 4.0,                      // [4]
    "Funny Animals" => 3.0,                     // [4]
    "Viral Challenges" => 2.5,                  // [6]
    "Pranks" => 2.0,                            // [6]
    "Reaction Videos" => 2.0,                   // [6]
    "Movie & TV Reviews" => 3.0,                // [6]
    "Movie/TV Show Analysis" => 4.0,            // [6]
    "Animation Tutorials" => 3.0,               // [6]
    "Building & Construction" => 5.0,           // [6]
    "Automotive Repairs" => 6.0,                // [6]
    "Car Reviews" => 6.0,                       // [6]
    "Mechanic Tips" => 5.0,                     // [6]
    "Street Racing" => 4.0,                     // [6]
    "Minimalist Living" => 4.0,                 // [6]
    "Budgeting & Saving Tips" => 10.0,          // [6]
    "Side Hustles & Online Income" => 13.0,     // [9][10]
    "General / No Niche" => 1.9,                // [7]
    // Fallback
];



// --- Define the $niches array for the dropdown ---
$niches = array_keys($niche_rpm);




// Helper to get RPM
function get_rpm($country_code, $niche) {
    global $country_rpm, $niche_rpm;
    $country_val = $country_rpm[$country_code] ?? ($country_rpm["default"] ?? 0);
    $niche_val = $niche_rpm[$niche] ?? ($niche_rpm["default"] ?? 0);
    return round(($country_val + $niche_val) / 2, 2);
}

// AJAX handler
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    $views = isset($_POST['yt_views']) ? (int)$_POST['yt_views'] : 0;
    $country = $_POST['yt_country'] ?? 'US';
    $niche = isset($_POST['yt_niche']) ? htmlspecialchars_decode($_POST['yt_niche']) : 'Entertainment';
    $rpm = get_rpm($country, $niche);
    $estimated_earnings = ($views / 1000) * $rpm;
    $results = [
        'views' => number_format($views),
        'country' => $countries[$country] ?? htmlspecialchars($country),
        'niche' => $niche,
        'rpm' => '$' . number_format($rpm, 2),
        'earnings' => '$' . number_format($estimated_earnings, 2)
    ];
    ?>
    <div class="result-card">
              <div class="result-meta">Estimated Monthly Earnings</div>

      <div class="result-earnings"><?= $results['earnings'] ?></div>
      <div class="result-details">
        <div class="result-row">
          <span class="result-label">Monthly Views</span>
          <span class="result-value"><?= $results['views'] ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Country</span>
          <span class="result-value"><?= htmlspecialchars($results['country']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Niche</span>
          <span class="result-value"><?= htmlspecialchars($results['niche']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Estimated RPM</span>
          <span class="result-value"><?= $results['rpm'] ?></span>
        </div>
      </div>
    </div>
    <?php
    exit;

    
}


include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';?>

<html>
    
<head>
    
         <link rel="stylesheet" href="/assets/css/plugins.css" />
  <link rel="stylesheet" href="/assets/css/base.css" />


  <link rel="stylesheet" href="/assets/css/style.css" />
  <link rel="preload" href="/assets/css/fonts/space.css" as="style" onload="this.rel='stylesheet'" /> 
  
  <style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}
form#yt-revenue-form input.form-control,
form#yt-revenue-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0rem 0rem 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#yt-revenue-form button#yt-revenue-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}
/* Enhanced Stylish Table */
.result-table {
  width: 100%;
  border-collapse: collapse;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  font-size: 1rem;
  color: #333;
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
  border-radius: 10px;
  overflow: hidden;
}

.result-table thead tr {
  background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
  color: #fff;
  text-align: left;
  font-weight: 700;
  font-size: 1.1rem;
}

.result-table th,
.result-table td {
  padding: 15px 20px;
  border-bottom: 1px solid #e0e0e0;
}

.result-table tbody tr:nth-child(even) {
  background-color: #f9faff;
}

.result-table tbody tr:hover {
  background-color: #e6f0ff;
  transition: background-color 0.3s ease;
}

.result-table tbody tr:last-child td {
  border-bottom: none;
}

/* Responsive horizontal scroll */
.table-responsive {
  overflow-x: auto;
  border-radius: 10px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
}

/* Earnings highlight */
.result-earnings {
  font-size: 2.5rem;
  font-weight: 800;
  color: #1a9a3a;
  margin-bottom: 1rem;
  text-align: center;
}

/* Result box styling */
.result-box {
  background-color: #fff;
  padding: 2rem;
  border-radius: 14px;
  box-shadow: 0 8px 24px rgba(0,0,0,0.08);
  max-width: 480px;
  margin: 0 auto;
}

/* Optional: Add subtle animation on results load */
.result-box {
  opacity: 0;
  transform: translateY(20px);
  animation: fadeInUp 0.6s forwards;
}

@keyframes fadeInUp {
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

/* Make result box and table use full width on mobile */
@media (max-width: 600px) {
  .result-box {
    max-width: 100%;
    width: 100%;
    margin: 0;
    padding: 1.2rem 0.5rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    border-radius: 10px;
  }
  .table-responsive {
    width: 100%;
    border-radius: 10px;
    box-shadow: none;
    margin: 0;
    padding: 0;
  }
  .result-table th, .result-table td {
    padding: 10px 8px;
    font-size: 1rem;
  }
}

/* Remove extra space below card on mobile */
@media (max-width: 600px) {
  .result-box {
    margin-bottom: 0;
    box-shadow: none;
  }
  #yt-results-area {
    margin-bottom: 0 !important;
    padding-bottom: 0 !important;
  }
}

/* General: Remove extra white space in table */
.result-table {
  border-collapse: collapse;
  width: 100%;
  background: #f6fafd;
}
.result-table th, .result-table td {
  border: none;
  background: none;
}

/* Card table for mobile */
@media (max-width: 600px) {
  .result-table, .result-table tbody, .result-table tr, .result-table td {
    display: block;
    width: 100%;
  }
  .result-table {
    border: none;
    box-shadow: none;
    background: transparent;
  }
  .result-table tr {
    background: #f6fafd;
    margin-bottom: 1rem;
    border-radius: 10px;
    box-shadow: 0 1px 4px rgba(60,100,180,0.06);
    padding: 1rem 0.5rem;
  }
  .result-table td {
    position: relative;
    padding-left: 48%;
    margin-bottom: 0.5rem;
    font-size: 1.1rem;
    border: none;
    background: none;
    text-align: left;
    min-height: 44px;
  }
  .result-table td:before {
    content: attr(data-title) ": ";
    position: absolute;
    left: 0;
    top: 0;
    width: 45%;
    font-weight: 700;
    color: #3f78e0;
    white-space: normal;
    font-size: 1.05rem;
    padding-right: 0.5rem;
  }
  /* Remove extra borders and spacing */
  .result-table td:last-child {
    margin-bottom: 0;
  }
  .result-table tr:last-child {
    margin-bottom: 0;
  }
  /* Hide table header on mobile */
  .result-table thead {
    display: none;
  }
}

.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}

.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}

.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}

.result-meta {
  font-size: 1.15rem;
  color: #444;
  font-weight: 500;
  margin-bottom: 1.25rem;
  text-align: center;
}

.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}

.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}

.result-label {
  font-weight: 700;
  color: #2a3a5c;
}

.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive: Full width and larger text on small screens */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
}

.result-meta {
  font-weight: bold;              /* Make text bold */
  font-size: 1.3rem;              /* Slightly larger text */
  color: #2a3a5c;                 /* Darker color for emphasis */
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0; /* Blue underline for visual separation */
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}

.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}

.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}

.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}

@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;        /* Deprecated but still widely supported */
  overflow-wrap: break-word;    /* Modern standard */
  white-space: normal;          /* Allow wrapping */
}

/* For the earnings value specifically, allow breaking and wrapping */
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem; /* Optionally reduce font size on mobile for very large numbers */
  text-align: center;
}

@media (max-width: 600px) {
  .result-card {
    padding: 1rem;
  }
  .result-earnings {
    font-size: 1.4rem;
    word-break: break-all;
  }
}

</style>

<style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* TikTok Calculator Form Inputs and Button */
form#tt-money-form input.form-control,
form#tt-money-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#tt-money-form button#tt-money-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}

/* Result Card Styling */
.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}
.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}
.result-meta {
  font-weight: bold;
  font-size: 1.3rem;
  color: #2a3a5c;
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0;
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}
.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}
.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}
.result-label {
  font-weight: 700;
  color: #2a3a5c;
}
.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive adjustments */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
  #modal-loader-overlay {
    /* Ensure loader covers full viewport on mobile */
    align-items: center;
    justify-content: center;
  }
}

/* Feature checklist styling */
.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}
.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}
.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}
@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;
  overflow-wrap: break-word;
  white-space: normal;
}
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem;
  text-align: center;
}
</style>

  
</head>

<body>
<div class="content-wrapper">

  <!-- Loader Overlay -->
  <div id="modal-loader-overlay">
    <div class="loader-content">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
      <span class="loader-text">Calculating Revenue...</span>
    </div>
  </div>

  <!-- HERO + CALCULATOR FORM -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">

        <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
          YouTube Money Calculator
        </h1>
        <h3 class="lead fs-20 lh-sm mb-4 mt-5">
          Discover your true YouTube earning power. Instantly estimate your monthly and yearly income from ads, memberships, Super Chats, and more—customized for your channel’s country, niche, and audience size. No guesswork, just real numbers.
        </h3>

          <form id="yt-revenue-form" method="POST" action="#">
            <div class="row g-3 align-items-center">
              <div class="col-md-4 mb-3 mb-md-0">
                <input
                  type="number"
                  class="form-control"
                  id="yt_views"
                  name="yt_views"
                  placeholder="Monthly Views"
                  min="0"
                  required
                  value="<?= isset($_POST['yt_views']) ? htmlspecialchars($_POST['yt_views']) : '' ?>"
                >
              </div>
              <div class="col-md-4 mb-3 mb-md-0">
                <select class="form-control" id="yt_country" name="yt_country" required>
                  <?php foreach ($countries as $code => $name): ?>
                    <option value="<?= htmlspecialchars($code) ?>" <?= (isset($_POST['yt_country']) && $_POST['yt_country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="col-md-4">
                <select class="form-control" id="yt_niche" name="yt_niche" required>
                  <?php foreach ($niches as $n): ?>
                    <option value="<?= htmlspecialchars($n, ENT_QUOTES, 'UTF-8') ?>" <?= (isset($_POST['yt_niche']) && $_POST['yt_niche'] == $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="mt-4"></div>
            <button
              class="btn mt-4"
              type="submit"
              id="yt-revenue-btn"
            >
              Calculate Earnings
            </button>
          </form>

          <div id="yt-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite"></div>

        </div>
      </div>
      
   <!-- HOW IT WORKS SECTION -->
<section class="wrapper">
  <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
    <h2 class="display-4 mb-3">How the YouTube Money Calculator Works</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6 process-wrapper line mt-5">
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">01</span></span>
        <h4 class="mb-1">Input Your Channel Details</h4>
        <p class="mb-0">
          Enter your monthly views, select your country and niche, and include any additional revenue streams like memberships or Super Chats. The more accurate your data, the more precise your estimate.
        </p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-primary pe-none mb-4"><span class="number">02</span></span>
        <h4 class="mb-1">Advanced Revenue Calculation</h4>
        <p class="mb-0">
          The calculator uses current CPMs and RPMs for your country and niche, factors in YouTube’s revenue share, and includes all monetization streams. Instantly see your estimated monthly and yearly earnings, broken down by source.
        </p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">03</span></span>
        <h4 class="mb-1">Get Actionable Insights</h4>
        <p class="mb-0">
          Use your results to set goals, optimize your upload strategy, and explore new ways to earn—like channel memberships, affiliate links, or YouTube Shopping. Track your progress and grow smarter.
        </p>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Fact:</strong> The average YouTube creator underestimates their earning potential by 40%. Use this calculator to discover what’s truly possible for your channel.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- FEATURE CHECKLIST -->
<section class="wrapper">
  <div class="container pt-2 pb-5 text-center">
    <p class="lead fs-18 lh-sm mb-4">
      The YouTube Money Calculator is more than just a numbers tool—it’s your roadmap to building a profitable, sustainable channel in 2025 and beyond.
    </p>
    <div class="row justify-content-center">
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Calculates ad, membership, Super Chat, and Shopping revenue</li>
          <li>Customizes estimates for every country and niche</li>
          <li>Shows RPM, CPM, and monetized playback rates</li>
          <li>Works for Shorts, Live, and long-form content</li>
          <li>No login, no limits, no hidden fees</li>
        </ul>
      </div>
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Benchmarks your channel against top creators</li>
          <li>Mobile and desktop friendly</li>
          <li>Updated for YouTube’s latest monetization policies</li>
          <li>Private and secure—your data is never stored</li>
          <li>Trusted by creators, brands, and agencies worldwide</li>
        </ul>
      </div>
    </div>
    <div class="alert alert-success p-4 fs-17 mt-4">
      <strong>Ready to see your earning power?</strong> Enter your stats and get a data-driven projection—no registration required!
    </div>
  </div>
</section>

<!-- GLOBAL EARNINGS & ALGORITHM MYTHS -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">How YouTube Pays Creators: Myths, Truths & Global Differences</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Myth: All Views Pay the Same</h5>
          <p class="mb-0">
            In reality, a view from the US, UK, or Australia can earn 5–10x more than a view from India or Brazil. The calculator adjusts for your audience’s country, giving you a real-world estimate.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Truth: YouTube’s Algorithm Rewards Retention</h5>
          <p class="mb-0">
            The longer viewers watch, the more ads they see and the higher your RPM. Channels with high retention and session time consistently earn more, regardless of subscriber count.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Myth: Passive Income is Automatic</h5>
          <p class="mb-0">
            While old videos can keep earning, true passive income comes from building a library of evergreen content and optimizing for search and suggested videos. The calculator helps you forecast the long-term impact of your uploads.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Did you know?</strong> Two channels with the same views can have a 10x difference in earnings based on niche, country, and engagement. Use the calculator to find your real RPM.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- GROWTH HACKS & PASSIVE INCOME -->
<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
    <h2 class="display-4 mb-3">Growth Hacks for Maximizing YouTube Income</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Batch Record & Schedule:</strong> Upload in batches and schedule for peak times. Consistency keeps your channel in the algorithm’s good graces.</li>
          <li><strong>Double Down on Evergreen:</strong> Create tutorials, reviews, and “how to” content that stays relevant for years and keeps earning.</li>
          <li><strong>Optimize for Search:</strong> Use keyword-rich titles, descriptions, and tags. The calculator’s RPM benchmarks show which topics pay best.</li>
          <li><strong>Use Playlists:</strong> Group videos into playlists to increase session time and ad impressions per viewer.</li>
          <li><strong>Promote Across Platforms:</strong> Share your videos on Instagram, TikTok, and blogs to reach new audiences and boost views.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Test New Formats:</strong> Try Shorts, live streams, and polls. Diversifying content increases your reach and unlocks new revenue streams.</li>
          <li><strong>Collaborate:</strong> Partner with other creators for shoutouts, guest spots, or co-hosted videos. This cross-promotion can spark viral growth.</li>
          <li><strong>Track Analytics:</strong> Use YouTube Studio to monitor CPM, RPM, and watch time. Adjust your strategy based on what performs best.</li>
          <li><strong>Encourage Viewer Action:</strong> Ask viewers to like, comment, and share. Higher engagement signals quality to YouTube and advertisers.</li>
          <li><strong>Reinvest in Your Channel:</strong> Upgrade your gear, hire editors, or invest in marketing as your revenue grows.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Pro Tip:</strong> Channels that review analytics and adapt their content strategy grow up to 3x faster. Use your calculator results to set monthly goals and track your progress.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- TAXES, LEGAL, AND BUSINESS TIPS -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">Turning YouTube Into a Real Business</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Track Your Income & Expenses</h5>
          <p class="mb-0">
            As your channel grows, treat it like a business. Use accounting software to track ad revenue, sponsorships, affiliate income, and expenses like equipment and marketing.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Understand Taxes</h5>
          <p class="mb-0">
            YouTube earnings are taxable income in most countries. Save a portion of your revenue for taxes, and consult a professional about deductions for equipment, home office, and travel.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Protect Your Brand</h5>
          <p class="mb-0">
            Register your channel name as a trademark if you’re building a brand. Use contracts for sponsorships and collaborations to avoid disputes and protect your income.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Did you know?</strong> Many top creators set up LLCs or corporations for their channels. This can offer tax benefits and legal protection as your income grows.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- CUSTOMER REVIEWS SECTION -->
<section class="wrapper" style="background-color:#f5faff;color:#23272b;">
  <div class="container py-7">
    <h2 class="display-6 mb-5 text-center" style="color:#212121;">Creator Stories: How the Calculator Changed My Channel</h2>
    <div class="row gx-5 gy-4 justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “I always thought my channel was too small to make real money. After using this calculator, I realized how much potential I had. I doubled my uploads and hit my first $1,000 month!”<br>
            <span class="fw-bold" style="color:#2586f7;">– Ravi, DIY Channel</span>
          </p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
          </div>
          <p>
            “The Money Calculator helped me see how much my niche and country affected my earnings. Now I focus on higher-CPM topics and have grown my income by 60% in six months.”<br>
            <span class="fw-bold" style="color:#2586f7;">– Julia, Language Educator</span>
          </p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “I use this tool before every sponsorship negotiation. It’s helped me prove my value and land better brand deals. The breakdown by revenue stream is a game-changer.”<br>
            <span class="fw-bold" style="color:#2586f7;">– Marcus, Fitness Creator</span>
          </p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- FAQ SECTION -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-10 pt-md-12">
    <h2 class="display-4 mb-3">Frequently Asked Questions</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionLeft">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading1">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
                Can I use the calculator for Shorts-only or Live channels?
              </button>
            </h2>
            <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Yes! Enter your Shorts or Live views and select the right CPM/RPM for your content type. The calculator will estimate your income accordingly, including Super Chat and membership revenue for live streams.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading2">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
                Does YouTube pay more for certain times of year?
              </button>
            </h2>
            <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Yes, CPMs and advertiser budgets are highest in Q4 (October–December) due to holiday shopping. Plan your best content for this period to maximize revenue.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading3">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
                Is there a minimum payout threshold?
              </button>
            </h2>
            <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Yes, you must earn at least $100 in your AdSense account before YouTube issues a payment. Earnings roll over each month until you reach the threshold.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading4">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
                Can I use the calculator for multiple channels?
              </button>
            </h2>
            <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Absolutely. Use the calculator as often as you like for any number of channels or videos. It’s free and unlimited.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading5">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
                What’s the best way to increase my RPM?
              </button>
            </h2>
            <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>
                  Focus on high-value niches, target viewers in countries with higher ad rates, make longer videos, and increase engagement. Diversifying your income streams also helps boost your overall RPM.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionRight">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading6">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
                Can brands use this calculator for campaign planning?
              </button>
            </h2>
            <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Yes! Brands and agencies use the calculator to estimate influencer campaign ROI, compare creators, and set realistic budgets for YouTube sponsorships.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading7">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
                Is my data private and secure?
              </button>
            </h2>
            <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  100%. The calculator does not store, share, or log any user data. All calculations happen instantly and privately in your browser session.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading8">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
                What’s the difference between a CPM and a CPC ad?
              </button>
            </h2>
            <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  CPM ads pay per 1,000 impressions; CPC (cost per click) ads pay only when a viewer clicks. Most YouTube ads are CPM-based, but some display ads can be CPC.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading9">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
                Can I use the calculator for non-English channels?
              </button>
            </h2>
            <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Yes! Just select the correct country and niche to get an accurate RPM for your audience, regardless of language.
                </p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading10">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse10" aria-expanded="false" aria-controls="faqCollapse10">
                Where can I learn more about YouTube monetization?
              </button>
            </h2>
            <div id="faqCollapse10" class="accordion-collapse collapse" aria-labelledby="faqHeading10" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>
                  Visit the YouTube Creator Academy or our blog for in-depth guides, algorithm updates, and the latest monetization strategies for 2025 and beyond.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row mt-6">
        <div class="col-lg-10 mx-auto">
          <div class="alert alert-primary p-4 fs-17">
            <strong>Still have questions?</strong> Reach out to our expert team anytime. We’re here to help you grow your YouTube channel and income!
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>


<!-- JS and Dynamic Elements -->
<script>
document.addEventListener('DOMContentLoaded', function() {
  var form = document.getElementById('yt-revenue-form');
  var loader = document.getElementById('modal-loader-overlay');
  var results = document.getElementById('yt-results-area');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      if (loader) loader.style.display = 'flex';
      if (results) results.innerHTML = '';
      var formData = new FormData(form);
      formData.append('ajax', '1');
      fetch(form.action, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.text())
      .then(html => {
        setTimeout(function() {
          if (loader) loader.style.display = 'none';
          results.innerHTML = html;
          results.style.display = 'flex';
        }, 2500);
      })
      .catch(function() {
        if (loader) loader.style.display = 'none';
        if (results) results.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
      });
    });
  }
});
</script>
