<?php
// --- Meta for SEO ---
$page_title = "Twitch Money Calculator: Calculate Your Real Streaming Earnings Instantly";
$page_description = "Estimate your Twitch income with the Twitch Money Calculator. Instantly see your ad, sub, bits, and donation revenue by country, niche, and audience size. Free, accurate, and trusted by streamers worldwide!";
$page_author = "TwitchPro";
$page_keywords = "Twitch Money Calculator, Twitch earnings, Twitch RPM, Twitch CPM, Twitch ad revenue, Twitch monetization, Twitch RPM by country, Twitch RPM by niche, Twitch streamer income estimator, Twitch calculator";

// --- All ISO 3166-1 countries (from template) ---
$countries = [
    "AF" => "Afghanistan", "AX" => "Åland Islands", "AL" => "Albania", "DZ" => "Algeria", "AS" => "American Samoa", "AD" => "Andorra", "AO" => "Angola", "AI" => "Anguilla", "AQ" => "Antarctica", "AG" => "Antigua and Barbuda", "AR" => "Argentina", "AM" => "Armenia", "AW" => "Aruba", "AU" => "Australia", "AT" => "Austria", "AZ" => "Azerbaijan", "BS" => "Bahamas (the)", "BH" => "Bahrain", "BD" => "Bangladesh", "BB" => "Barbados", "BY" => "Belarus", "BE" => "Belgium", "BZ" => "Belize", "BJ" => "Benin", "BM" => "Bermuda", "BT" => "Bhutan", "BO" => "Bolivia (Plurinational State of)", "BQ" => "Bonaire, Sint Eustatius and Saba", "BA" => "Bosnia and Herzegovina", "BW" => "Botswana", "BV" => "Bouvet Island", "BR" => "Brazil", "IO" => "British Indian Ocean Territory (the)", "BN" => "Brunei Darussalam", "BG" => "Bulgaria", "BF" => "Burkina Faso", "BI" => "Burundi", "CV" => "Cabo Verde", "KH" => "Cambodia", "CM" => "Cameroon", "CA" => "Canada", "KY" => "Cayman Islands (the)", "CF" => "Central African Republic (the)", "TD" => "Chad", "CL" => "Chile", "CN" => "China", "CX" => "Christmas Island", "CC" => "Cocos (Keeling) Islands (the)", "CO" => "Colombia", "KM" => "Comoros (the)", "CD" => "Congo (the Democratic Republic of the)", "CG" => "Congo (the)", "CK" => "Cook Islands (the)", "CR" => "Costa Rica", "CI" => "Côte d'Ivoire", "HR" => "Croatia", "CU" => "Cuba", "CW" => "Curaçao", "CY" => "Cyprus", "CZ" => "Czechia", "DK" => "Denmark", "DJ" => "Djibouti", "DM" => "Dominica", "DO" => "Dominican Republic (the)", "EC" => "Ecuador", "EG" => "Egypt", "SV" => "El Salvador", "GQ" => "Equatorial Guinea", "ER" => "Eritrea", "EE" => "Estonia", "SZ" => "Eswatini", "ET" => "Ethiopia", "FK" => "Falkland Islands (the) [Malvinas]", "FO" => "Faroe Islands (the)", "FJ" => "Fiji", "FI" => "Finland", "FR" => "France", "GF" => "French Guiana", "PF" => "French Polynesia", "TF" => "French Southern Territories (the)", "GA" => "Gabon", "GM" => "Gambia (the)", "GE" => "Georgia", "DE" => "Germany", "GH" => "Ghana", "GI" => "Gibraltar", "GR" => "Greece", "GL" => "Greenland", "GD" => "Grenada", "GP" => "Guadeloupe", "GU" => "Guam", "GT" => "Guatemala", "GG" => "Guernsey", "GN" => "Guinea", "GW" => "Guinea-Bissau", "GY" => "Guyana", "HT" => "Haiti", "HM" => "Heard Island and McDonald Islands", "VA" => "Holy See (the)", "HN" => "Honduras", "HK" => "Hong Kong", "HU" => "Hungary", "IS" => "Iceland", "IN" => "India", "ID" => "Indonesia", "IR" => "Iran (Islamic Republic of)", "IQ" => "Iraq", "IE" => "Ireland", "IM" => "Isle of Man", "IL" => "Israel", "IT" => "Italy", "JM" => "Jamaica", "JP" => "Japan", "JE" => "Jersey", "JO" => "Jordan", "KZ" => "Kazakhstan", "KE" => "Kenya", "KI" => "Kiribati", "KP" => "Korea (the Democratic People's Republic of)", "KR" => "Korea (the Republic of)", "KW" => "Kuwait", "KG" => "Kyrgyzstan", "LA" => "Lao People's Democratic Republic (the)", "LV" => "Latvia", "LB" => "Lebanon", "LS" => "Lesotho", "LR" => "Liberia", "LY" => "Libya", "LI" => "Liechtenstein", "LT" => "Lithuania", "LU" => "Luxembourg", "MO" => "Macao", "MK" => "Republic of North Macedonia", "MG" => "Madagascar", "MW" => "Malawi", "MY" => "Malaysia", "MV" => "Maldives", "ML" => "Mali", "MT" => "Malta", "MH" => "Marshall Islands (the)", "MQ" => "Martinique", "MR" => "Mauritania", "MU" => "Mauritius", "YT" => "Mayotte", "MX" => "Mexico", "FM" => "Micronesia (Federated States of)", "MD" => "Moldova (the Republic of)", "MC" => "Monaco", "MN" => "Mongolia", "ME" => "Montenegro", "MS" => "Montserrat", "MA" => "Morocco", "MZ" => "Mozambique", "MM" => "Myanmar", "NA" => "Namibia", "NR" => "Nauru", "NP" => "Nepal", "NL" => "Netherlands (the)", "NC" => "New Caledonia", "NZ" => "New Zealand", "NI" => "Nicaragua", "NE" => "Niger (the)", "NG" => "Nigeria", "NU" => "Niue", "NF" => "Norfolk Island", "MP" => "Northern Mariana Islands (the)", "NO" => "Norway", "OM" => "Oman", "PK" => "Pakistan", "PW" => "Palau", "PS" => "Palestine, State of", "PA" => "Panama", "PG" => "Papua New Guinea", "PY" => "Paraguay", "PE" => "Peru", "PH" => "Philippines", "PN" => "Pitcairn", "PL" => "Poland", "PT" => "Portugal", "PR" => "Puerto Rico", "QA" => "Qatar", "RE" => "Réunion", "RO" => "Romania", "RU" => "Russian Federation", "RW" => "Rwanda", "BL" => "Saint Barthélemy", "SH" => "Saint Helena, Ascension and Tristan da Cunha", "KN" => "Saint Kitts and Nevis", "LC" => "Saint Lucia", "MF" => "Saint Martin (French part)", "PM" => "Saint Pierre and Miquelon", "VC" => "Saint Vincent and the Grenadines", "WS" => "Samoa", "SM" => "San Marino", "ST" => "Sao Tome and Principe", "SA" => "Saudi Arabia", "SN" => "Senegal", "RS" => "Serbia", "SC" => "Seychelles", "SL" => "Sierra Leone", "SG" => "Singapore", "SX" => "Sint Maarten (Dutch part)", "SK" => "Slovakia", "SI" => "Slovenia", "SB" => "Solomon Islands", "SO" => "Somalia", "ZA" => "South Africa", "GS" => "South Georgia and the South Sandwich Islands", "SS" => "South Sudan", "ES" => "Spain", "LK" => "Sri Lanka", "SD" => "Sudan", "SR" => "Suriname", "SJ" => "Svalbard and Jan Mayen", "SE" => "Sweden", "CH" => "Switzerland", "SY" => "Syrian Arab Republic", "TW" => "Taiwan", "TJ" => "Tajikistan", "TZ" => "Tanzania, United Republic of", "TH" => "Thailand", "TL" => "Timor-Leste", "TG" => "Togo", "TK" => "Tokelau", "TO" => "Tonga", "TT" => "Trinidad and Tobago", "TN" => "Tunisia", "TR" => "Turkey", "TM" => "Turkmenistan", "TV" => "Tuvalu", "UG" => "Uganda", "UA" => "Ukraine", "AE" => "United Arab Emirates", "GB" => "United Kingdom of Great Britain and Northern Ireland", "US" => "United States of America", "UY" => "Uruguay", "UZ" => "Uzbekistan", "VU" => "Vanuatu", "VE" => "Venezuela (Bolivarian Republic of)", "VN" => "Viet Nam", "EH" => "Western Sahara", "YE" => "Yemen", "ZM" => "Zambia", "ZW" => "Zimbabwe"
];
// --- Twitch CPM/RPM values by country (USD, 2025 averages, based on) ---
$country_rpm = [
    "US" => 7.50, "GB" => 7.00, "DE" => 7.20, "CA" => 6.80, "AU" => 7.10, "FR" => 6.50, "SE" => 6.20, "NO" => 6.10, "DK" => 6.00, "NL" => 6.00, "FI" => 5.80, "JP" => 5.50, "KR" => 5.40, "IE" => 5.30, "SG" => 5.10, "CH" => 5.00, "NZ" => 5.00, "IT" => 4.80, "ES" => 4.70, "BE" => 4.60, "AT" => 4.50, "PL" => 4.30, "PT" => 4.10, "CZ" => 4.00, "RU" => 3.90, "BR" => 3.80, "MX" => 3.70, "TR" => 3.60, "IN" => 3.50, "ID" => 3.40, "PH" => 3.30, "TH" => 3.20, "MY" => 3.10, "AR" => 3.00, "CO" => 2.90, "CL" => 2.80, "ZA" => 2.70, "EG" => 2.60, "NG" => 2.50, "KE" => 2.40, "PK" => 2.30, "BD" => 2.20, "VN" => 2.10, "UA" => 2.00,
    // All other countries default to 2.00 for conservative global average
];
foreach ($countries as $code => $name) {
    if (!isset($country_rpm[$code])) $country_rpm[$code] = 2.00;
}

// --- Twitch/Instagram Niches (deep research, all possible, based on ) ---
$twitch_niche_rpm = [
    // High RPM
    "Finance & Investing" => 8.0, "Business & Entrepreneurship" => 7.5, "Crypto & NFTs" => 7.0, "Stock Market & Trading" => 7.0, "Tech Reviews & Gadgets" => 6.5, "Software & App Reviews" => 6.0, "Digital Marketing" => 6.0, "Personal Finance" => 7.0, "Online Education" => 6.0, "AI & Machine Learning" => 6.5, "Legal Advice" => 6.0, "Real Estate" => 6.5, "Science & Technology" => 6.0, "Productivity & Self-Improvement" => 5.5,
    // Gaming and eSports
    "eSports" => 6.0, "FPS Gaming" => 5.5, "MOBA Gaming" => 5.5, "Strategy Gaming" => 5.0, "MMORPG" => 4.8, "Mobile Gaming" => 4.5, "Retro Gaming" => 4.5, "Speedrunning" => 5.0, "Indie Games" => 4.5, "VR Gaming" => 5.0, "Simulation Games" => 4.8,
    // Medium RPM
    "Health & Fitness" => 5.0, "Weight Loss & Diet" => 5.0, "Yoga & Meditation" => 4.5, "Bodybuilding" => 5.0, "Travel & Lifestyle" => 5.0, "Luxury Travel" => 5.5, "Food & Cooking" => 4.5, "Restaurant Reviews" => 4.5, "Parenting & Family" => 4.0, "Pets & Animals" => 4.0, "DIY & Crafts" => 4.0, "Home Decor & Organization" => 4.0, "Minimalism" => 4.0, "Sustainable Living" => 4.0, "Motivation & Philosophy" => 4.2, "Study Tips & Education" => 4.5, "Language Learning" => 4.0, "Book Reviews" => 4.0, "Art & Illustration" => 4.0, "Animation & Motion Graphics" => 4.0, "Event Planning" => 4.2, "College & Student Life" => 4.0, "Adventure Sports" => 4.5, "Home Improvement" => 4.0, "Interior Design" => 4.0, "Fashion & Beauty" => 5.0, "Makeup Tutorials" => 5.0, "Shopping Hauls" => 4.5, "Vegan & Plant-Based Living" => 4.2, "Mental Health & Self-Care" => 4.2, "Astrology & Spirituality" => 4.0, "Luxury Lifestyle" => 5.0,
    // Lower RPM
    "Music" => 3.5, "Educational Music" => 3.8, "Comedy & Skits" => 3.5, "Entertainment" => 3.5, "People & Blogs" => 3.5, "Vlogging" => 3.7, "Reactions & Commentary" => 3.5, "Short Movies" => 3.5, "Film & Animation" => 3.8, "News & Politics" => 3.2, "Nonprofits & Activism" => 2.5, "Shows" => 3.0, "Movies" => 3.0, "General / No Niche" => 2.0, "Viral Challenges" => 3.0, "Pranks" => 3.0, "Memes & Viral Content" => 3.0, "Meme Pages" => 3.0, "Fan Pages" => 2.5, "Horoscopes" => 2.8, "Street Photography" => 3.5, "Reaction Memes" => 3.0, "General Vlogs" => 3.0, "Street Interviews" => 3.0, "Fandoms & Pop Culture" => 3.0, "ASMR" => 3.0, "Unusual Hobbies" => 3.0, "Local News" => 2.5, "Other" => 2.0
];
$twitch_niches = array_keys($twitch_niche_rpm);

function get_rpm($country_code, $niche) {
    global $country_rpm, $twitch_niche_rpm;
    $country_val = $country_rpm[$country_code] ?? 2.00;
    $niche_val = $twitch_niche_rpm[$niche] ?? 2.00;
    return round(($country_val + $niche_val) / 2, 2);
}

// AJAX handler for calculator
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    global $twitch_niche_rpm;
    $views = isset($_POST['tw_views']) ? (int)$_POST['tw_views'] : 0;
    $country = $_POST['tw_country'] ?? 'US';
    $niche = isset($_POST['tw_niche']) ? htmlspecialchars_decode($_POST['tw_niche']) : 'Other';
    $subs = isset($_POST['tw_subs']) ? (int)$_POST['tw_subs'] : 0;
    $bits = isset($_POST['tw_bits']) ? (int)$_POST['tw_bits'] : 0;
    $donations = isset($_POST['tw_donations']) ? (float)$_POST['tw_donations'] : 0.0;

    $country_val = $country_rpm[$country] ?? 2.00;
    $niche_val = $twitch_niche_rpm[$niche] ?? $twitch_niche_rpm["Other"];
    $rpm = round(max(($country_val + $niche_val) / 2, 0.5), 2);

    // Ad revenue (CPM/RPM)
    $ad_revenue = ($views / 1000) * $rpm;

    // Sub revenue (assume Tier 1, $4.99, 50% payout)
    $sub_revenue = $subs * 4.99 * 0.5;

    // Bits (1 bit = $0.01)
    $bits_revenue = $bits * 0.01;

    // Donations (direct)
    $donation_revenue = $donations;

    $total = $ad_revenue + $sub_revenue + $bits_revenue + $donation_revenue;

    $results = [
        'views' => number_format($views),
        'subs' => number_format($subs),
        'bits' => number_format($bits),
        'donations' => '$' . number_format($donations, 2),
        'country' => $countries[$country] ?? htmlspecialchars($country),
        'niche' => $niche,
        'rpm' => '$' . number_format($rpm, 2),
        'ad_revenue' => '$' . number_format($ad_revenue, 2),
        'sub_revenue' => '$' . number_format($sub_revenue, 2),
        'bits_revenue' => '$' . number_format($bits_revenue, 2),
        'donation_revenue' => '$' . number_format($donation_revenue, 2),
        'total' => '$' . number_format($total, 2)
    ];
    ?>
    <div class="result-card">
      <div class="result-meta">Estimated Twitch Earnings</div>
      <div class="result-earnings"><?= $results['total'] ?></div>
      <div class="result-details">
        <div class="result-row"><span class="result-label">Ad Revenue</span><span class="result-value"><?= $results['ad_revenue'] ?></span></div>
        <div class="result-row"><span class="result-label">Subscribers</span><span class="result-value"><?= $results['subs'] ?> (<?= $results['sub_revenue'] ?>)</span></div>
        <div class="result-row"><span class="result-label">Bits</span><span class="result-value"><?= $results['bits'] ?> (<?= $results['bits_revenue'] ?>)</span></div>
        <div class="result-row"><span class="result-label">Donations</span><span class="result-value"><?= $results['donation_revenue'] ?></span></div>
        <div class="result-row"><span class="result-label">Country</span><span class="result-value"><?= htmlspecialchars($results['country']) ?></span></div>
        <div class="result-row"><span class="result-label">Niche</span><span class="result-value"><?= htmlspecialchars($results['niche']) ?></span></div>
        <div class="result-row"><span class="result-label">Estimated RPM</span><span class="result-value"><?= $results['rpm'] ?></span></div>
      </div>
    </div>
    <?php
    exit;
}

include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<html>
    <head>
     <link rel="stylesheet" href="/assets/css/plugins.css" />
  <link rel="stylesheet" href="/assets/css/base.css" />


  <link rel="stylesheet" href="/assets/css/style.css" />
  <link rel="preload" href="/assets/css/fonts/space.css" as="style" onload="this.rel='stylesheet'" />   
     <style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* TikTok Calculator Form Inputs and Button */
form#tw-money-form input.form-control,
form#tw-money-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#tw-money-form button#tw-money-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}

/* Result Card Styling */
.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}
.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}
.result-meta {
  font-weight: bold;
  font-size: 1.3rem;
  color: #2a3a5c;
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0;
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}
.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}
.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}
.result-label {
  font-weight: 700;
  color: #2a3a5c;
}
.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive adjustments */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
  #modal-loader-overlay {
    /* Ensure loader covers full viewport on mobile */
    align-items: center;
    justify-content: center;
  }
}

/* Feature checklist styling */
.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}
.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}
.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}
@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;
  overflow-wrap: break-word;
  white-space: normal;
}
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem;
  text-align: center;
}
</style>   
    </head>
    <body>
<div class="content-wrapper">

  <!-- Loader Overlay -->
  <div id="modal-loader-overlay">
    <div class="loader-content">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
      <span class="loader-text">Calculating Revenue...</span>
    </div>
  </div>

  <!-- HERO + CALCULATOR FORM -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">
        <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
          Twitch Money Calculator <span class="underline-3 style-1 primary"></span>
        </h1>
        <h3 class="lead fs-20 lh-sm mb-4 mt-5">
          Instantly estimate your Twitch streaming earnings in 2025. Enter your stats to see your potential income from ads, subscribers, bits, and donations—customized for your country, niche, and audience size. No guesswork, just real numbers.
        </h3>

          <form id="tw-money-form" method="POST" action="#">
            <div class="row g-3 align-items-center">
              <div class="col-md-6 mb-3 mb-md-0">
                <input type="number" class="form-control" id="tw_views" name="tw_views" placeholder="Monthly Ad Views" min="0" required value="<?= isset($_POST['tw_views']) ? htmlspecialchars($_POST['tw_views']) : '' ?>">
                <small class="form-text text-muted">Enter your monthly ad views</small>
              </div>
              <div class="col-md-6 mb-3 mb-md-0">
                <select class="form-control" id="tw_country" name="tw_country" required>
                  <?php foreach ($countries as $code => $name): ?>
                    <option value="<?= htmlspecialchars($code) ?>" <?= (isset($_POST['tw_country']) && $_POST['tw_country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Select your audience country</small>
              </div>
            </div>
            <div class="row g-3 align-items-center mt-0">
              <div class="col-md-6 mb-3 mb-md-0">
                <select class="form-control" id="tw_niche" name="tw_niche" required>
                  <?php foreach ($twitch_niches as $n): ?>
                    <option value="<?= htmlspecialchars($n, ENT_QUOTES, 'UTF-8') ?>" <?= (isset($_POST['tw_niche']) && $_POST['tw_niche'] == $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Choose your Twitch content niche</small>
              </div>
              <div class="col-md-6">
                <input type="number" class="form-control" id="tw_subs" name="tw_subs" placeholder="Monthly Subscribers" min="0" required value="<?= isset($_POST['tw_subs']) ? htmlspecialchars($_POST['tw_subs']) : '' ?>">
                <small class="form-text text-muted">Enter your monthly paid subscribers</small>
              </div>
            </div>
            <div class="row g-3 align-items-center mt-0">
              <div class="col-md-6 mb-3 mb-md-0">
                <input type="number" class="form-control" id="tw_bits" name="tw_bits" placeholder="Monthly Bits" min="0" required value="<?= isset($_POST['tw_bits']) ? htmlspecialchars($_POST['tw_bits']) : '' ?>">
                <small class="form-text text-muted">Enter your monthly bits cheered</small>
              </div>
              <div class="col-md-6">
                <input type="number" step="0.01" class="form-control" id="tw_donations" name="tw_donations" placeholder="Monthly Donations ($)" min="0" required value="<?= isset($_POST['tw_donations']) ? htmlspecialchars($_POST['tw_donations']) : '' ?>">
                <small class="form-text text-muted">Enter your monthly direct donations ($)</small>
              </div>
            </div>
            <div class="mt-4"></div>
            <button class="btn mt-4" type="submit" id="tw-money-btn">Calculate Earnings</button>
          </form>

          <div id="tw-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite"></div>
        </div>
      </div>
    </div>
  </section>

<!-- HOW THE TWITCH MONEY CALCULATOR WORKS -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">How the Twitch Money Calculator Works</h2>
    <p class="lead fs-18 lh-sm mb-7">
      The Twitch Money Calculator is designed to give streamers and brands a transparent, data-driven estimate of Twitch earnings. By combining your real stats with the latest Twitch payout rates, you get a clear, actionable view of your income potential in 2025.
    </p>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">1. Enter Your Channel Data</h5>
          <p class="mb-0">
            Start by entering your average monthly ad views, subscriber count, bits, donations, country, and niche. The more accurate your numbers, the more reliable your results.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">2. Ad Revenue Calculation</h5>
          <p class="mb-0">
            The calculator multiplies your ad views by the current RPM (revenue per 1,000 views) for your country and niche. RPMs reflect real-world CPMs and are updated for 2025, so you get a realistic ad income estimate.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">3. Subscription Revenue</h5>
          <p class="mb-0">
            Subscription revenue is based on your total paid subs and Twitch’s payout split. Affiliates generally receive 50% of sub fees, while Partners and Partner Plus can earn up to 70%. The calculator reflects your sub tier and payout rate.
          </p>
        </div>
      </div>
    </div>
    <div class="row gx-lg-8 gx-xl-12 gy-6 mt-4">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">4. Bits & Donations</h5>
          <p class="mb-0">
            Bits are Twitch’s virtual cheers, worth $0.01 each. Donations are added at 100% value (minus payment processor fees). Both are included in your total estimate for a complete view of your income.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">5. Total Earnings Formula</h5>
          <p class="mb-0">
            The calculator adds up ad revenue, sub revenue, bits, and donations for your total monthly Twitch earnings. You’ll see a clear breakdown so you know where your money comes from.
          </p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">6. Country & Niche Factors</h5>
          <p class="mb-0">
            RPMs and sub values vary by country and content type. The calculator uses the latest rates for every major region and Twitch niche, so your estimate is tailored to your unique audience and genre.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Example:</strong> If you stream from the UK and have 150,000 monthly ad views, 400 subscribers, 7,500 bits, and £100 in donations, with a UK RPM of $6.80:<br>
          <span class="fw-bold">
            Ad Revenue = (150,000 / 1,000) × $6.80 = $1,020<br>
            Sub Revenue = 400 × $4.99 × 0.5 = $998<br>
            Bits Revenue = 7,500 × $0.01 = $75<br>
            Donation Revenue = $127 (approx. £100)<br>
            Total = $2,220/month
          </span>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Feature Checklist -->
<section class="wrapper">
  <div class="container pt-2 pb-5 text-center">
    <p class="lead fs-18 lh-sm mb-4">
      No matter your Twitch level, our calculator gives you a fast, realistic estimate of your earning potential. Use it to plan your next stream, set goals, and benchmark your progress as you grow.
    </p>
    <div class="row justify-content-center">
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Latest RPM & CPM for every country and Twitch niche</li>
          <li>Mobile-friendly, fast, and secure—no login needed</li>
          <li>Actionable insights to boost your Twitch income</li>
          <li>SEO-optimized for streamers and brands</li>
          <li>Instant results—no signup or waiting</li>
        </ul>
      </div>
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Works for all follower, sub, and bit counts</li>
          <li>Easy to use on any device, anytime</li>
          <li>Updated with 2025 Twitch payout data</li>
          <li>Completely free, no hidden fees</li>
          <li>Trusted by Twitch streamers and sponsors worldwide</li>
        </ul>
      </div>
    </div>
    <div class="alert alert-success p-4 fs-17 mt-4">
      <strong>Ready to see your Twitch earning power?</strong> Enter your stats and get your estimate now!
    </div>
  </div>
</section>

<!-- WHY TWITCH MONEY CALCULATOR MATTERS -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">Why Estimate Your Twitch Earnings?</h2>
    <p class="lead fs-18 lh-sm mb-7">
      Calculating your Twitch earnings is more than curiosity—it’s about strategy. Whether you’re aiming for Affiliate, Partner, or full-time status, understanding your revenue helps you set goals, plan content, and unlock new monetization opportunities.
    </p>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Set Realistic Goals</h5>
          <p class="mb-0">Forecast your monthly and yearly Twitch income to plan hardware upgrades, marketing, or even going full-time. Knowing your numbers helps you make smart, confident decisions.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Understand Your Audience</h5>
          <p class="mb-0">Different countries and genres have different RPMs. Use the calculator to see how your topic and where your viewers are from affect your revenue.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Unlock New Revenue Streams</h5>
          <p class="mb-0">Add sponsorships, affiliate links, and merch to your income mix. The calculator helps you see how each stream impacts your total earnings.</p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Pro Tip:</strong> Streamers in finance, tech, and eSports often earn higher RPMs. Focus on high-engagement content and community building to maximize your income.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- CUSTOMER REVIEWS SECTION -->
<section class="wrapper" style="background-color:#f5faff;color:#23272b;">
  <div class="container py-7">
    <h2 class="display-6 mb-5 text-center" style="color:#212121;">Real Streamers, Real Results</h2>
    <div class="row gx-5 gy-4 justify-content-center">
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “As a mid-tier streamer, this calculator made it easy to forecast my ad and sub revenue for the year. The breakdown is super helpful for sponsorship proposals!”<br>
            <span class="fw-bold" style="color:#2586f7;">– Alex, Variety Streamer</span>
          </p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
          </div>
          <p>
            “The Twitch Money Calculator is my go-to before every brand deal. It’s fast, accurate, and the country RPMs really matter for international viewers.”<br>
            <span class="fw-bold" style="color:#2586f7;">– Priya, Tech Streamer</span>
          </p>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card shadow-sm p-4 h-100" style="background-color:#fff;color:#23272b;border:1px solid #e6e6e6;">
          <div class="mb-2 text-warning">
            <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
          </div>
          <p>
            “I’m a micro-streamer, and this tool gave me the confidence to pitch my stats to sponsors. The bits and donation breakdown is a game-changer.”<br>
            <span class="fw-bold" style="color:#2586f7;">– Lina, Music Streamer</span>
          </p>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- ORGANIC GROWTH TIPS -->
<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
    <h2 class="display-4 mb-3">Tips to Maximize Your Twitch Earnings</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="uil uil-check"></i><strong>Stream Consistently:</strong> Keep a regular schedule to build audience loyalty and boost your average viewers.</li>
          <li><i class="uil uil-check"></i><strong>Engage in Real Time:</strong> Respond to chat, use polls, and make viewers feel part of your stream.</li>
          <li><i class="uil uil-check"></i><strong>Collaborate:</strong> Co-streams and raids help you reach new communities and grow faster.</li>
          <li><i class="uil uil-check"></i><strong>Upgrade Your Setup:</strong> Better audio, video, and overlays improve viewer experience and retention.</li>
          <li><i class="uil uil-check"></i><strong>Promote Everywhere:</strong> Share your streams on social media, Discord, and YouTube to attract new viewers.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><i class="uil uil-check"></i><strong>Negotiate Smart:</strong> Use your calculator results to set fair sponsorship rates.</li>
          <li><i class="uil uil-check"></i><strong>Diversify:</strong> Add affiliate links, merch, and YouTube for more stable income.</li>
          <li><i class="uil uil-check"></i><strong>Analyze Trends:</strong> Track your RPM, CPM, and sub growth to spot what works best.</li>
          <li><i class="uil uil-check"></i><strong>Stay Informed:</strong> Follow Twitch news and updates to adapt your strategy.</li>
          <li><i class="uil uil-check"></i><strong>Invest in Yourself:</strong> Reinvest earnings in your channel for long-term growth.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Did you know?</strong> The top-earning streamers treat Twitch like a business—tracking stats, setting goals, and always learning.
        </div>
      </div>
    </div>
  </div>
</section>

<!-- FAQ SECTION -->
<section class="wrapper bg-gradient-primary">
  <div class="container pt-10 pt-md-12">
    <h2 class="display-4 mb-3">Frequently Asked Questions</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionLeft">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading1">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
                How does the Twitch Money Calculator work?
              </button>
            </h2>
            <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>The calculator uses your ad views, subscribers, bits, donations, country, and niche to estimate monthly and yearly Twitch earnings. It applies the latest RPM, CPM, and payout splits for 2025 to give you a realistic projection.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading2">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
                What is RPM on Twitch?
              </button>
            </h2>
            <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>RPM (Revenue Per Mille) is your real earnings per 1,000 ad views. It varies by country, niche, and stream quality. In 2025, RPMs range from $2–$10+ depending on your audience and content.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading3">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
                How much can I earn per 1,000 ad views on Twitch?
              </button>
            </h2>
            <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>Most streamers earn $2–$10 per 1,000 ad views. Premium niches and top countries (US, UK, Germany) can earn even more, especially with high engagement.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading4">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
                Can I earn money on Twitch without ads?
              </button>
            </h2>
            <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>Absolutely. Many streamers earn more from subs, bits, donations, and sponsorships than from ads. Diversifying your income is the best way to grow.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading5">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
                What are the requirements to monetize on Twitch?
              </button>
            </h2>
            <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordionLeft">
              <div class="accordion-body">
                <p>You need at least 50 followers, 500 total minutes broadcast, 7 unique broadcast days, and an average of 3+ concurrent viewers in the last 30 days to become an Affiliate. Partner and Partner Plus have higher requirements.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--/col-->
      <div class="col-lg-6 text-start">
        <div class="accordion" id="faqAccordionRight">
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading6">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
                Is this calculator free to use?
              </button>
            </h2>
            <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>Yes, the Twitch Money Calculator is 100% free, always up-to-date, and requires no login or signup.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading7">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
                Can I use this calculator for sponsorships?
              </button>
            </h2>
            <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>Yes! Use your estimated earnings to confidently negotiate sponsorship rates and brand deals with data-backed stats.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading8">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
                What is the best Twitch niche for high earnings?
              </button>
            </h2>
            <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>Finance, eSports, tech, and education are the highest-paying Twitch niches, especially with audiences in the US, UK, and Germany.</p>
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="faqHeading9">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
                Where can I learn more about Twitch monetization?
              </button>
            </h2>
            <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordionRight">
              <div class="accordion-body">
                <p>Check out our blog for in-depth guides on Twitch monetization, streaming growth, and influencer marketing for 2025 and beyond.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--/col-->
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Still have questions?</strong> Reach out to our team or explore our resources for more tips on maximizing your Twitch income.
        </div>
      </div>
    </div>
  </div>
</section>


</div>

</body>
</html>
<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
  var form = document.getElementById('tw-money-form');
  var loader = document.getElementById('modal-loader-overlay');
  var results = document.getElementById('tw-results-area');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      if (loader) loader.style.display = 'flex';
      if (results) results.innerHTML = '';
      var formData = new FormData(form);
      formData.append('ajax', '1');
      fetch(form.action, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.text())
      .then(html => {
        setTimeout(function() {
          if (loader) loader.style.display = 'none';
          results.innerHTML = html;
          results.style.display = 'flex';
        }, 2500);
      })
      .catch(function() {
        if (loader) loader.style.display = 'none';
        if (results) results.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
      });
    });
  }
});
</script>
  