<?php
function is_ajax_request() {
    return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
}

// --- Meta for SEO ---
$page_title = "TikTok Money Calculator: Real Earnings Estimator for Creators & Influencers";
$page_description = "Estimate your TikTok income with our advanced TikTok Money Calculator. Instantly see your potential earnings from views, followers, engagement, and niche. Accurate, free, and trusted by creators worldwide.";
$page_author = "GWAA";
$page_keywords = "TikTok Money Calculator, TikTok earnings, TikTok calculator, TikTok influencer income, TikTok revenue estimator, TikTok engagement rate, TikTok sponsored post, TikTok brand deals, TikTok creator tools";

// --- All ISO 3166-1 countries (reuse from your template) ---
$countries = [
    "AF" => "Afghanistan",
    "AX" => "Åland Islands",
    "AL" => "Albania",
    "DZ" => "Algeria",
    "AS" => "American Samoa",
    "AD" => "Andorra",
    "AO" => "Angola",
    "AI" => "Anguilla",
    "AQ" => "Antarctica",
    "AG" => "Antigua and Barbuda",
    "AR" => "Argentina",
    "AM" => "Armenia",
    "AW" => "Aruba",
    "AU" => "Australia",
    "AT" => "Austria",
    "AZ" => "Azerbaijan",
    "BS" => "Bahamas (the)",
    "BH" => "Bahrain",
    "BD" => "Bangladesh",
    "BB" => "Barbados",
    "BY" => "Belarus",
    "BE" => "Belgium",
    "BZ" => "Belize",
    "BJ" => "Benin",
    "BM" => "Bermuda",
    "BT" => "Bhutan",
    "BO" => "Bolivia (Plurinational State of)",
    "BQ" => "Bonaire, Sint Eustatius and Saba",
    "BA" => "Bosnia and Herzegovina",
    "BW" => "Botswana",
    "BV" => "Bouvet Island",
    "BR" => "Brazil",
    "IO" => "British Indian Ocean Territory (the)",
    "BN" => "Brunei Darussalam",
    "BG" => "Bulgaria",
    "BF" => "Burkina Faso",
    "BI" => "Burundi",
    "CV" => "Cabo Verde",
    "KH" => "Cambodia",
    "CM" => "Cameroon",
    "CA" => "Canada",
    "KY" => "Cayman Islands (the)",
    "CF" => "Central African Republic (the)",
    "TD" => "Chad",
    "CL" => "Chile",
    "CN" => "China",
    "CX" => "Christmas Island",
    "CC" => "Cocos (Keeling) Islands (the)",
    "CO" => "Colombia",
    "KM" => "Comoros (the)",
    "CD" => "Congo (the Democratic Republic of the)",
    "CG" => "Congo (the)",
    "CK" => "Cook Islands (the)",
    "CR" => "Costa Rica",
    "CI" => "Côte d'Ivoire",
    "HR" => "Croatia",
    "CU" => "Cuba",
    "CW" => "Curaçao",
    "CY" => "Cyprus",
    "CZ" => "Czechia",
    "DK" => "Denmark",
    "DJ" => "Djibouti",
    "DM" => "Dominica",
    "DO" => "Dominican Republic (the)",
    "EC" => "Ecuador",
    "EG" => "Egypt",
    "SV" => "El Salvador",
    "GQ" => "Equatorial Guinea",
    "ER" => "Eritrea",
    "EE" => "Estonia",
    "SZ" => "Eswatini",
    "ET" => "Ethiopia",
    "FK" => "Falkland Islands (the) [Malvinas]",
    "FO" => "Faroe Islands (the)",
    "FJ" => "Fiji",
    "FI" => "Finland",
    "FR" => "France",
    "GF" => "French Guiana",
    "PF" => "French Polynesia",
    "TF" => "French Southern Territories (the)",
    "GA" => "Gabon",
    "GM" => "Gambia (the)",
    "GE" => "Georgia",
    "DE" => "Germany",
    "GH" => "Ghana",
    "GI" => "Gibraltar",
    "GR" => "Greece",
    "GL" => "Greenland",
    "GD" => "Grenada",
    "GP" => "Guadeloupe",
    "GU" => "Guam",
    "GT" => "Guatemala",
    "GG" => "Guernsey",
    "GN" => "Guinea",
    "GW" => "Guinea-Bissau",
    "GY" => "Guyana",
    "HT" => "Haiti",
    "HM" => "Heard Island and McDonald Islands",
    "VA" => "Holy See (the)",
    "HN" => "Honduras",
    "HK" => "Hong Kong",
    "HU" => "Hungary",
    "IS" => "Iceland",
    "IN" => "India",
    "ID" => "Indonesia",
    "IR" => "Iran (Islamic Republic of)",
    "IQ" => "Iraq",
    "IE" => "Ireland",
    "IM" => "Isle of Man",
    "IL" => "Israel",
    "IT" => "Italy",
    "JM" => "Jamaica",
    "JP" => "Japan",
    "JE" => "Jersey",
    "JO" => "Jordan",
    "KZ" => "Kazakhstan",
    "KE" => "Kenya",
    "KI" => "Kiribati",
    "KP" => "Korea (the Democratic People's Republic of)",
    "KR" => "Korea (the Republic of)",
    "KW" => "Kuwait",
    "KG" => "Kyrgyzstan",
    "LA" => "Lao People's Democratic Republic (the)",
    "LV" => "Latvia",
    "LB" => "Lebanon",
    "LS" => "Lesotho",
    "LR" => "Liberia",
    "LY" => "Libya",
    "LI" => "Liechtenstein",
    "LT" => "Lithuania",
    "LU" => "Luxembourg",
    "MO" => "Macao",
    "MK" => "Republic of North Macedonia",
    "MG" => "Madagascar",
    "MW" => "Malawi",
    "MY" => "Malaysia",
    "MV" => "Maldives",
    "ML" => "Mali",
    "MT" => "Malta",
    "MH" => "Marshall Islands (the)",
    "MQ" => "Martinique",
    "MR" => "Mauritania",
    "MU" => "Mauritius",
    "YT" => "Mayotte",
    "MX" => "Mexico",
    "FM" => "Micronesia (Federated States of)",
    "MD" => "Moldova (the Republic of)",
    "MC" => "Monaco",
    "MN" => "Mongolia",
    "ME" => "Montenegro",
    "MS" => "Montserrat",
    "MA" => "Morocco",
    "MZ" => "Mozambique",
    "MM" => "Myanmar",
    "NA" => "Namibia",
    "NR" => "Nauru",
    "NP" => "Nepal",
    "NL" => "Netherlands (the)",
    "NC" => "New Caledonia",
    "NZ" => "New Zealand",
    "NI" => "Nicaragua",
    "NE" => "Niger (the)",
    "NG" => "Nigeria",
    "NU" => "Niue",
    "NF" => "Norfolk Island",
    "MP" => "Northern Mariana Islands (the)",
    "NO" => "Norway",
    "OM" => "Oman",
    "PK" => "Pakistan",
    "PW" => "Palau",
    "PS" => "Palestine, State of",
    "PA" => "Panama",
    "PG" => "Papua New Guinea",
    "PY" => "Paraguay",
    "PE" => "Peru",
    "PH" => "Philippines",
    "PN" => "Pitcairn",
    "PL" => "Poland",
    "PT" => "Portugal",
    "PR" => "Puerto Rico",
    "QA" => "Qatar",
    "RE" => "Réunion",
    "RO" => "Romania",
    "RU" => "Russian Federation",
    "RW" => "Rwanda",
    "BL" => "Saint Barthélemy",
    "SH" => "Saint Helena, Ascension and Tristan da Cunha",
    "KN" => "Saint Kitts and Nevis",
    "LC" => "Saint Lucia",
    "MF" => "Saint Martin (French part)",
    "PM" => "Saint Pierre and Miquelon",
    "VC" => "Saint Vincent and the Grenadines",
    "WS" => "Samoa",
    "SM" => "San Marino",
    "ST" => "Sao Tome and Principe",
    "SA" => "Saudi Arabia",
    "SN" => "Senegal",
    "RS" => "Serbia",
    "SC" => "Seychelles",
    "SL" => "Sierra Leone",
    "SG" => "Singapore",
    "SX" => "Sint Maarten (Dutch part)",
    "SK" => "Slovakia",
    "SI" => "Slovenia",
    "SB" => "Solomon Islands",
    "SO" => "Somalia",
    "ZA" => "South Africa",
    "GS" => "South Georgia and the South Sandwich Islands",
    "SS" => "South Sudan",
    "ES" => "Spain",
    "LK" => "Sri Lanka",
    "SD" => "Sudan",
    "SR" => "Suriname",
    "SJ" => "Svalbard and Jan Mayen",
    "SE" => "Sweden",
    "CH" => "Switzerland",
    "SY" => "Syrian Arab Republic",
    "TW" => "Taiwan",
    "TJ" => "Tajikistan",
    "TZ" => "Tanzania, United Republic of",
    "TH" => "Thailand",
    "TL" => "Timor-Leste",
    "TG" => "Togo",
    "TK" => "Tokelau",
    "TO" => "Tonga",
    "TT" => "Trinidad and Tobago",
    "TN" => "Tunisia",
    "TR" => "Turkey",
    "TM" => "Turkmenistan",
    "TV" => "Tuvalu",
    "UG" => "Uganda",
    "UA" => "Ukraine",
    "AE" => "United Arab Emirates",
    "GB" => "United Kingdom of Great Britain and Northern Ireland",
    "US" => "United States of America",
    "UY" => "Uruguay",
    "UZ" => "Uzbekistan",
    "VU" => "Vanuatu",
    "VE" => "Venezuela (Bolivarian Republic of)",
    "VN" => "Viet Nam",
    "EH" => "Western Sahara",
    "YE" => "Yemen",
    "ZM" => "Zambia",
    "ZW" => "Zimbabwe"
];


// --- Example RPM values by country (USD) (reuse from your template) ---
$country_rpm = [
    "AF" => 3.11,
    "AX" => 0.35,
    "AL" => 0.74,
    "DZ" => 2.57,
    "AS" => 0.35,
    "AD" => 0.35,
    "AO" => 0.15,
    "AI" => 0.45,
    "AQ" => 0.00,
    "AG" => 0.45,
    "AR" => 0.77,
    "AM" => 3.91,
    "AW" => 0.00,
    "AU" => 36.21,
    "AT" => 16.86,
    "AZ" => 0.59,
    "BS" => 0.35,
    "BH" => 0.35,
    "BD" => 0.44,
    "BB" => 0.35,
    "BY" => 0.35,
    "BE" => 5.60,
    "BZ" => 0.35,
    "BJ" => 0.35,
    "BM" => 0.35,
    "BT" => 0.35,
    "BO" => 0.35,
    "BQ" => 0.35,
    "BA" => 0.35,
    "BW" => 0.35,
    "BV" => 0.00,
    "BR" => 1.14,
    "IO" => 0.35,
    "BN" => 0.35,
    "BG" => 1.50,
    "BF" => 0.35,
    "BI" => 0.35,
    "CV" => 0.35,
    "KH" => 0.35,
    "CM" => 0.35,
    "CA" => 13.50,
    "KY" => 0.35,
    "CF" => 0.35,
    "TD" => 0.35,
    "CL" => 0.35,
    "CN" => 0.35,
    "CX" => 0.00,
    "CC" => 0.00,
    "CO" => 0.35,
    "KM" => 0.35,
    "CD" => 0.35,
    "CG" => 0.35,
    "CK" => 0.35,
    "CR" => 0.35,
    "CI" => 0.35,
    "HR" => 1.67,
    "CU" => 0.35,
    "CW" => 0.35,
    "CY" => 0.35,
    "CZ" => 2.75,
    "DK" => 6.38,
    "DJ" => 0.35,
    "DM" => 0.45,
    "DO" => 0.35,
    "EC" => 1.00,
    "EG" => 0.46,
    "SV" => 0.35,
    "GQ" => 0.35,
    "ER" => 0.35,
    "EE" => 0.35,
    "SZ" => 0.35,
    "ET" => 0.35,
    "FK" => 0.00,
    "FO" => 0.35,
    "FJ" => 0.35,
    "FI" => 14.90,
    "FR" => 3.90,
    "GF" => 0.35,
    "PF" => 0.35,
    "TF" => 0.00,
    "GA" => 0.35,
    "GM" => 0.35,
    "GE" => 0.35,
    "DE" => 38.85,
    "GH" => 0.35,
    "GI" => 0.35,
    "GR" => 2.00,
    "GL" => 0.35,
    "GD" => 0.45,
    "GP" => 0.35,
    "GU" => 0.35,
    "GT" => 0.35,
    "GG" => 0.35,
    "GN" => 0.35,
    "GW" => 0.35,
    "GY" => 0.35,
    "HT" => 0.35,
    "HM" => 0.00,
    "VA" => 0.00,
    "HN" => 0.35,
    "HK" => 2.85,
    "HU" => 1.80,
    "IS" => 0.35,
    "IN" => 0.83,
    "ID" => 0.74,
    "IR" => 5.67,
    "IQ" => 0.71,
    "IE" => 18.20,
    "IM" => 0.35,
    "IL" => 14.08,
    "IT" => 0.89,
    "JM" => 4.94,
    "JP" => 10.53,
    "JE" => 2.00,
    "JO" => 1.50,
    "KZ" => 1.77,
    "KE" => 0.35,
    "KI" => 0.35,
    "KP" => 0.00,
    "KR" => 8.88,
    "KW" => 6.56,
    "KG" => 1.23,
    "LA" => 5.09,
    "LV" => 6.60,
    "LB" => 1.70,
    "LS" => 0.35,
    "LR" => 2.00,
    "LY" => 4.69,
    "LI" => 1.00,
    "LT" => 6.86,
    "LU" => 0.35,
    "MO" => 1.25,
    "MK" => 1.27,
    "MG" => 0.50,
    "MW" => 0.35,
    "MY" => 1.40,
    "MV" => 2.01,
    "ML" => 8.41,
    "MT" => 5.34,
    "MH" => 0.35,
    "MQ" => 0.00,
    "MR" => 3.80,
    "MU" => 7.05,
    "YT" => 3.00,
    "MX" => 9.51,
    "FM" => 0.35,
    "MD" => 29.50,
    "MC" => 0.35,
    "MN" => 5.85,
    "ME" => 0.35,
    "MS" => 0.45,
    "MA" => 0.34,
    "MZ" => 6.78,
    "MM" => 1.22,
    "NA" => 2.00,
    "NR" => 0.35,
    "NP" => 2.14,
    "NL" => 17.77,
    "NC" => 1.33,
    "NZ" => 28.15,
    "NI" => 1.92,
    "NE" => 6.00,
    "NG" => 2.89,
    "NU" => 0.35,
    "NF" => 0.35,
    "MP" => 0.45,
    "NO" => 20.17,
    "OM" => 3.78,
    "PK" => 0.59,
    "PW" => 0.35,
    "PS" => 2.50,
    "PA" => 1.73,
    "PG" => 2.27,
    "PY" => 2.48,
    "PE" => 1.24,
    "PH" => 0.48,
    "PN" => 0.00,
    "PL" => 7.67,
    "PT" => 10.32,
    "PR" => 8.05,
    "QA" => 1.11,
    "RE" => 0.35,
    "RO" => 1.67,
    "RU" => 1.30,
    "RW" => 0.35,
    "BL" => 0.35,
    "SH" => 0.35,
    "KN" => 0.45,
    "LC" => 0.45,
    "MF" => 0.35,
    "PM" => 0.35,
    "VC" => 0.45,
    "WS" => 0.35,
    "SM" => 0.35,
    "ST" => 0.35,
    "SA" => 1.88,
    "SN" => 0.35,
    "RS" => 1.10,
    "SC" => 0.35,
    "SL" => 0.35,
    "SG" => 3.11,
    "SX" => 0.35,
    "SK" => 2.00,
    "SI" => 0.35,
    "SB" => 0.35,
    "SO" => 0.35,
    "ZA" => 1.46,
    "GS" => 0.00,
    "SS" => 0.35,
    "ES" => 2.69,
    "LK" => 0.55,
    "SD" => 0.35,
    "SR" => 0.35,
    "SJ" => 0.35,
    "SE" => 18.18,
    "CH" => 6.89,
    "SY" => 0.35,
    "TW" => 1.79,
    "TJ" => 0.35,
    "TZ" => 0.35,
    "TH" => 1.05,
    "TL" => 0.35,
    "TG" => 0.35,
    "TK" => 0.35,
    "TO" => 0.35,
    "TT" => 0.35,
    "TN" => 0.35,
    "TR" => 0.75,
    "TM" => 0.35,
    "TV" => 0.35,
    "UG" => 0.35,
    "UA" => 1.20,
    "AE" => 2.60,
    "GB" => 13.75,
    "US" => 13.00,
    "UY" => 0.35,
    "UZ" => 0.35,
    "VU" => 0.35,
    "VE" => 0.80,
    "VN" => 0.70,
    "EH" => 0.35,
    "YE" => 0.35,
    "ZM" => 0.35,
    "ZW" => 0.35
];


// --- Example RPM values by niche (USD) (reuse from your template) ---
$tiktok_niche_rpm = [
    // High RPM Niches
    "Finance & Investing" => 25.0,             // $15–$40
    "Making Money Online" => 18.0,             // $13–$25
    "Business / SEO / Blogging" => 20.0,       // $10–$30
    "Real Estate" => 18.0,                     // $13–$30
    "Law / Legal Commentary" => 20.0,          // $15–$30
    "Insurance" => 15.0,                       // $10–$20
    "Credit Cards & Loans" => 15.0,            // $10–$18
    "Investments & Crypto" => 18.0,            // $12–$25
    "Stock Market & Trading" => 25.0,          // $15–$30
    "Digital Marketing" => 13.0,               // $10–$18
    "Affiliate Marketing" => 14.0,             // $10–$20
    "Email Marketing" => 13.0,                 // $10–$20
    "SaaS & Software Reviews" => 12.0,         // $10–$18
    "Tech Reviews & Gadgets" => 10.0,          // $7–$15
    "Productivity & Tech Tutorials" => 9.0,    // $7–$12
    "Web Development" => 8.0,                  // $6–$12
    "Coding & Programming" => 10.0,            // $8–$15
    "AI & Machine Learning" => 12.0,           // $10–$18
    "Online Education / Study Tips" => 9.0,    // $7–$12
    "Science & Technology" => 8.0,             // $6–$10
    "Motivation & Philosophy" => 7.0,          // $5–$10
    "Career & Professional Development" => 8.0,// $6–$12

    // Medium RPM Niches
    "Health & Fitness" => 6.0,                 // $3–$10
    "Weight Loss & Diet" => 7.0,               // $5–$10
    "Yoga & Meditation" => 6.0,                // $4–$8
    "Bodybuilding" => 7.0,                     // $5–$10
    "Sports" => 5.0,                           // $3–$8
    "Automotive" => 6.0,                       // $3–$8
    "Travel & Lifestyle" => 6.0,               // $3–$10
    "Luxury Travel" => 8.0,                    // $6–$12
    "Food & Cooking" => 3.0,                   // $2–$5
    "Restaurant Reviews" => 4.0,               // $3–$6
    "Home Decor & Organization" => 4.0,        // $3–$6
    "DIY & Crafts" => 3.5,                     // $2–$5
    "Gardening & Homesteading" => 3.0,         // $2–$4
    "Parenting & Family" => 2.5,               // $2–$4
    "Pets & Animals" => 3.5,                   // $2–$8
    "Book Reviews & Literature" => 2.5,        // $2–$4
    "Animation & Motion Graphics" => 3.0,      // $2–$5
    "Educational Content" => 8.0,              // $6–$12
    "Science Experiments" => 5.0,              // $4–$8
    "Howto & Style" => 4.0,                    // $3–$6
    "Travel Vlogs" => 4.0,                     // $3–$7
    "Product Reviews" => 4.0,                  // $3–$6
    "Unboxing" => 3.0,                         // $2–$5
    "Life Hacks & Productivity" => 5.0,        // $4–$8
    "Motivation & Self-Improvement" => 6.0,    // $5–$10
    "Study With Me" => 4.0,                    // $3–$6
    "Test Preparation" => 6.0,                 // $5–$8
    "Career Advice" => 8.0,                    // $6–$12
    "Job Interview Tips" => 7.0,               // $5–$10
    "Fashion" => 3.5,                          // $2–$6
    "Fashion Try-ons & Hauls" => 4.0,          // $3–$7
    "Beauty & Makeup" => 4.0,                  // $3–$7
    "Shopping Hauls" => 3.0,                   // $2–$5
    "Minimalism & Organization" => 4.0,        // $3–$6
    "Sustainable Living & Eco-Friendly" => 4.0,// $3–$6
    "Interior Design" => 4.0,                  // $3–$6
    "Home Improvement & Renovation" => 5.0,    // $4–$8

    // Lower RPM Niches (high volume, lower RPM)
    "Music" => 1.0,                            // $0.5–$2
    "Educational Music" => 1.8,                // $1–$3
    "Gaming" => 2.0,                           // $1–$4
    "Mobile Gaming" => 2.0,                    // $1–$3
    "Grand Theft Auto / Open World Gaming" => 2.5,// $2–$4
    "Esports" => 3.0,                          // $2–$5
    "Fantasy Sports" => 3.0,                   // $2–$5
    "Comedy & Skits" => 1.5,                   // $1–$3
    "Entertainment" => 2.0,                    // $1–$3
    "People & Blogs" => 2.0,                   // $1–$3
    "Vlogging / Lifestyle" => 2.5,             // $1–$4
    "Reactions, Skits, Commentary" => 2.0,     // $1–$3
    "Short Movies" => 1.5,                     // $1–$3
    "Film & Animation" => 2.5,                 // $2–$4
    "News & Politics" => 2.0,                  // $1–$3
    "Nonprofits & Activism" => 1.0,            // $0.5–$2
    "Shows" => 1.5,                            // $1–$3
    "Movies" => 2.0,                           // $1–$3
    "General / No Niche" => 1.5,               // $1–$2

    // TikTok/Shorts/Other Social
    "TikTok Tutorials" => 3.0,                 // $2–$4
    "Instagram Growth" => 4.0,                 // $3–$6
    "YouTube Shorts" => 2.0,                   // $1–$3

    // Fallback
    "Other" => 1.5
];


// --- TikTok-specific niches (customize as needed) ---
$tiktok_niches = [

    "Finance & Investing",
    "Stock Market & Trading",
    "Business / SEO / Blogging",
    "Making Money Online",
    "Real Estate",
    "Law / Legal Commentary",
    "Insurance",
    "Credit Cards & Loans",
    "Investments & Crypto",
    "Digital Marketing",
    "Affiliate Marketing",
    "Dropshipping & Ecommerce",
    "SaaS & Software Reviews",
    "Tech Reviews & Gadgets",
    "Productivity & Tech Tutorials",
    "Web Development",
    "Coding & Programming",
    "AI & Machine Learning",
    "Online Education / Study Tips",
    "Education & Online Learning",
    "Science & Technology",
    "Motivation & Philosophy",
    "Career & Professional Development",
    "Job Interview Tips",
    "Test Preparation",
    "Language Learning",
    "True Crime",
    "History",
    "Health & Fitness",
    "Weight Loss & Diet",
    "Yoga & Meditation",
    "Bodybuilding",
    "Sports",
    "Automotive",
    "Car Reviews",
    "Automotive Repairs",
    "Mechanic Tips",
    "Street Racing",
    "Travel & Lifestyle",
    "Luxury Travel",
    "Budget Travel",
    "Travel Guides",
    "Food & Cooking",
    "Restaurant Reviews",
    "Street Food",
    "Cooking Challenges",
    "Home Decor & Organization",
    "DIY & Crafts",
    "Gardening & Homesteading",
    "Parenting & Family",
    "Parenting Tips",
    "Kids' Content",
    "Pets & Animals",
    "Pet Training",
    "Funny Animals",
    "Book Reviews & Literature",
    "Book Summaries",
    "Animation & Motion Graphics",
    "Educational Content",
    "Science Experiments",
    "Howto & Style",
    "Travel Vlogs",
    "Product Reviews",
    "Unboxing",
    "Life Hacks & Productivity",
    "Motivation & Self-Improvement",
    "Study With Me",
    "Minimalism & Organization",
    "Sustainable Living & Eco-Friendly",
    "Home Improvement & Renovation",
    "Interior Design",
    "Sewing & Crafts",
    "Building & Construction",
    "Music",
    "Educational Music",
    "Gaming",
    "Mobile Gaming",
    "Grand Theft Auto / Open World Gaming",
    "Esports",
    "Fantasy Sports",
    "Comedy & Skits",
    "Comedy",
    "Entertainment",
    "People & Blogs",
    "Vlogging / Lifestyle",
    "Reactions, Skits, Commentary",
    "Short Movies",
    "Film & Animation",
    "News & Politics",
    "Nonprofits & Activism",
    "Shows",
    "Movies",
    "General / No Niche",
    "Viral Challenges",
    "Pranks",
    "Reaction Videos",
    "Movie & TV Reviews",
    "Movie/TV Show Analysis",
    "Animation Tutorials",
    "TikTok Tutorials",
    "Instagram Growth",
    "YouTube Shorts",
    "Other"

];

// --- Define the $niches array for the dropdown ---
$niches = array_keys($tiktok_niche_rpm);




// Helper to get RPM
function get_rpm($country_code, $niche) {
    global $country_rpm, $tiktok_niche_rpm;
    $country_val = $country_rpm[$country_code] ?? ($country_rpm["default"] ?? 0);
    $niche_val = $tiktok_niche_rpm[$niche] ?? ($tiktok_niche_rpm["default"] ?? 0);
    return round(($country_val + $niche_val) / 2, 2);
}

// AJAX handler
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    global $tiktok_niche_rpm;

    $views = isset($_POST['tt_views']) ? (int)$_POST['tt_views'] : 0;
    $country = $_POST['tt_country'] ?? 'US';
    $niche = isset($_POST['tt_niche']) ? htmlspecialchars_decode($_POST['tt_niche']) : 'Other';
    // Use TikTok-specific niche RPM
    $country_val = $country_rpm[$country] ?? ($country_rpm["default"] ?? 0.5);
    $niche_val = $tiktok_niche_rpm[$niche] ?? $tiktok_niche_rpm["Other"];
    $rpm = round(max(($country_val + $niche_val) / 2, 0.1), 2);
    $estimated_earnings = ($views / 1000) * $rpm;
    $results = [
        'views' => number_format($views),
        'country' => $countries[$country] ?? htmlspecialchars($country),
        'niche' => $niche,
        'rpm' => '$' . number_format($rpm, 2),
        'earnings' => '$' . number_format($estimated_earnings, 2)
    ];
    ?>
    <div class="result-card">
      <div class="result-meta">Estimated Monthly TikTok Earnings</div>
      <div class="result-earnings"><?= $results['earnings'] ?></div>
      <div class="result-details">
        <div class="result-row">
          <span class="result-label">Monthly Views</span>
          <span class="result-value"><?= $results['views'] ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Country</span>
          <span class="result-value"><?= htmlspecialchars($results['country']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Niche</span>
          <span class="result-value"><?= htmlspecialchars($results['niche']) ?></span>
        </div>
        <div class="result-row">
          <span class="result-label">Estimated RPM</span>
          <span class="result-value"><?= $results['rpm'] ?></span>
        </div>
      </div>
    </div>
    <?php
    exit;

    
}


include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php';?>


<div class="content-wrapper">

  <!-- Loader Overlay -->
  <div id="modal-loader-overlay">
    <div class="loader-content">
      <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
      <span class="loader-text">Calculating Revenue...</span>
    </div>
  </div>

  <!-- HERO + CALCULATOR FORM -->
  <section class="wrapper">
    <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
      <div class="row">
        <div class="col-lg-9 col-xl-8 col-xxl-7 mx-auto" data-group="page-title">

        <h1 class="display-1 ls-sm fs-44 mb-4 px-md-8 px-lg-0">
          TikTok Money Calculator <span class="underline-3 style-1 primary"></span>
        </h1>
        <h3 class="lead fs-20 lh-sm mb-4 mt-5">
          Discover your real TikTok earning potential. Instantly estimate your monthly and yearly income from views, followers, engagement, and niche—no guesswork, just real numbers. This is the most advanced, up-to-date TikTok Money Calculator for creators, brands, and marketers.
        </h3>

          <form id="tt-money-form" method="POST" action="#">
            <div class="row g-3 align-items-center">
              <div class="col-md-4 mb-3 mb-md-0">
                <input
                  type="number"
                  class="form-control"
                  id="tt_views"
                  name="tt_views"
                  placeholder="Monthly Views"
                  min="0"
                  required
                  value="<?= isset($_POST['tt_views']) ? htmlspecialchars($_POST['tt_views']) : '' ?>"
                >
                <small class="form-text text-muted">Enter your average monthly TikTok views</small>
              </div>
              <div class="col-md-4 mb-3 mb-md-0">
                <select class="form-control" id="tt_country" name="tt_country" required>
                  <?php foreach ($countries as $code => $name): ?>
                    <option value="<?= htmlspecialchars($code) ?>" <?= (isset($_POST['tt_country']) && $_POST['tt_country'] == $code) ? 'selected' : '' ?>><?= htmlspecialchars($name) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Select your audience country</small>
              </div>
              <div class="col-md-4">
                <select class="form-control" id="tt_niche" name="tt_niche" required>
                  <?php foreach ($tiktok_niches as $n): ?>
                    <option value="<?= htmlspecialchars($n, ENT_QUOTES, 'UTF-8') ?>" <?= (isset($_POST['tt_niche']) && $_POST['tt_niche'] == $n) ? 'selected' : '' ?>><?= htmlspecialchars($n) ?></option>
                  <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Choose your TikTok content niche</small>
              </div>
            </div>
            <div class="mt-4"></div>
            <button
              class="btn mt-4"
              type="submit"
              id="tt-money-btn"
            >
              Calculate Earnings
            </button>
          </form>

          <div id="yt-results-area" class="mt-5 mb-4 d-flex justify-content-center" aria-live="polite"></div>

        </div>
      </div>
    </div>
  </section>

  <!-- PROCESS STEPS (CTA) -->
<section class="wrapper">
  <div class="container pt-2 pt-md-7 pb-7 pb-md-8 text-center">
    <h2 class="display-4 mb-3">How Does the TikTok Money Calculator Work?</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6 process-wrapper line mt-5">
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">01</span></span>
        <h4 class="mb-1">Input Your TikTok Stats</h4>
        <p class="mb-0">Enter your average monthly views, select your country, and choose your content niche. The more accurate your stats, the more precise your earnings estimate will be.</p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-primary pe-none mb-4"><span class="number">02</span></span>
        <h4 class="mb-1">Instant Earnings Estimate</h4>
        <p class="mb-0">Click calculate to see your estimated daily, monthly, and yearly TikTok revenue. The tool uses real RPM and CPM data for your country and niche, factoring in engagement and follower tier.</p>
      </div>
      <div class="col-md-6 col-lg-4">
        <span class="icon btn btn-circle btn-lg btn-soft-primary pe-none mb-4"><span class="number">03</span></span>
        <h4 class="mb-1">Optimize & Grow</h4>
        <p class="mb-0">Use your personalized results to set goals, negotiate brand deals, and unlock new monetization streams—whether you’re a nano-influencer or a global star.</p>
      </div>
    </div>
  </div>
</section>

<section class="wrapper">
  <div class="container pt-2 pb-5 text-center">
    <p class="lead fs-18 lh-sm mb-4">
      Our TikTok Money Calculator is designed for everyone—from aspiring creators and micro-influencers to established brands and agencies. See exactly how much you could earn per video, per month, or per year, and learn what it takes to reach your income goals.
    </p>
    <div class="row justify-content-center">
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Accurate RPMs and CPMs for every TikTok niche and country</li>
          <li>Mobile-friendly, fast, and secure—no login required</li>
          <li>Actionable tips to boost your TikTok earnings</li>
          <li>SEO-optimized for creators and influencers</li>
          <li>Instant results with no signup required</li>
        </ul>
      </div>
      <div class="col-md-6">
        <ul class="feature-checklist">
          <li>Works for all follower counts and engagement rates</li>
          <li>Easy to use on any device, anytime</li>
          <li>Updated regularly with the latest TikTok RPM data</li>
          <li>Completely free, no hidden fees</li>
          <li>Trusted by TikTokers and brands worldwide</li>
        </ul>
      </div>
    </div>
    <div class="alert alert-success p-4 fs-17 mt-4">
      <strong>Ready to unlock your TikTok earning power?</strong> Enter your stats and see how much you could make today!
    </div>
  </div>
</section>

<section class="wrapper bg-gradient-primary">
  <div class="container pt-8 pt-md-5 pb-5 pb-md-2">
    <h2 class="display-4 mb-3">How Is TikTok Income Calculated?</h2>
    <p class="lead fs-18 lh-sm mb-7">
      TikTok earnings are determined by several factors: your follower count, engagement rate, video views, content quality, niche, and country. The calculator uses industry benchmarks and real-world data to estimate your potential revenue from the Creator Fund, Creativity Program, sponsored content, and more.
    </p>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Follower Count</h5>
          <p class="mb-0">More followers generally mean more money. TikTokers are classified as nano, micro, mid-tier, macro, or mega-influencers. Each tier has different earning potential and appeal to brands.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Engagement Rate</h5>
          <p class="mb-0">Likes, comments, shares, and watch time are gold. High engagement signals a loyal, active audience, which attracts better sponsorships and higher RPMs.</p>
        </div>
      </div>
      <div class="col-md-6 col-lg-4">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Views Per Video</h5>
          <p class="mb-0">The more views your videos get, the more you can earn. Consistent, high-performing videos are the backbone of TikTok income—especially for the Creator Fund and Creativity Program.</p>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Did you know?</strong> TikTok pays between $0.02 and $0.04 per 1,000 views through the Creator Fund, but brand deals and sponsorships can pay much more—sometimes $10 to $100+ per 1,000 views in top niches.
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12 mt-4"><!-- Added mt-4 for extra separation -->
    <div class="row">
      <div class="col-12">
        <h2 class="display-4 mb-3">What Are the Best Niches for TikTok Earnings?</h2>
      </div>
    </div>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Finance & Investing:</strong> Highest CPMs, as banks and fintech brands pay top dollar for access to young investors.</li>
          <li><strong>Technology & Gadgets:</strong> Tech reviews, tutorials, and app demos attract high-paying advertisers.</li>
          <li><strong>Health & Fitness:</strong> Wellness, weight loss, and sports content are in constant demand.</li>
          <li><strong>Beauty & Fashion:</strong> Makeup, skincare, and clothing hauls are highly profitable for influencer marketing.</li>
          <li><strong>Education:</strong> Study tips, language learning, and science experiments get strong engagement and brand interest.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Travel & Lifestyle:</strong> Luxury and budget travel both attract sponsors, especially in tourism and hospitality.</li>
          <li><strong>Food & Cooking:</strong> While CPMs are lower, high-volume views and viral potential can lead to solid earnings.</li>
          <li><strong>Gaming:</strong> Esports and mobile gaming content are growing fast, with strong affiliate and sponsorship potential.</li>
          <li><strong>Comedy & Entertainment:</strong> Skits, pranks, and viral challenges can attract massive audiences and brand deals.</li>
          <li><strong>Parenting & Family:</strong> Brands in baby products and family services seek out engaged parenting creators.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Did you know?</strong> Finance and tech creators can earn up to 10x more per 1,000 views than food or general entertainment creators.
        </div>
      </div>
    </div>

  </div>
  
    
</section>

<section class="wrapper">
  <div class="container py-7">
    <h2 class="display-4 mb-5 text-left" style="color:#212121;">TikTok Influencer Tiers & Earnings</h2>
    <!-- First Row: Nano and Micro Influencers -->
    <div class="row gx-5 gy-4">
      <div class="col-md-6">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Nano Influencers (up to 10,000 followers)</h5>
          <p>
            Nano creators are everyday users with a tight-knit audience. They typically earn $5–$25 per post, but their high engagement can attract niche brands. Many nano influencers start monetizing via affiliate links, small sponsorships, and the Creator Fund.
          </p>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Micro Influencers (10,000–100,000 followers)</h5>
          <p>
            Micro-influencers are the backbone of TikTok’s creator economy. They earn $25–$125 per post, and their authenticity makes them highly valuable to brands. Micro creators often combine the Creator Fund, affiliate deals, and sponsored content for steady income.
          </p>
        </div>
      </div>
    </div>
    <!-- Second Row: Mid-Tier and Macro/Mega Influencers -->
    <div class="row gx-5 gy-4 mt-4">
      <div class="col-md-6">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Mid-Tier Influencers (100,000–500,000 followers)</h5>
          <p>
            Mid-tier creators are established voices in their niches. They often earn $125–$1,250 per post, with the potential for recurring brand partnerships, higher ad revenue, and even their own product lines. Their content quality and audience trust are key to maximizing income.
          </p>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card shadow-sm p-4 h-100">
          <h5 class="mb-2">Macro & Mega Influencers (500,000+ followers)</h5>
          <p>
            Macro and mega influencers command the highest rates—$1,250 to $2,500+ per post, and sometimes much more for celebrities. They attract global brands, exclusive sponsorships, and can monetize through merchandise, live gifts, and off-platform deals.
          </p>
        </div>
      </div>
    </div>
    <!-- Tip Alert -->
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-success p-4 fs-17">
          <strong>Tip:</strong> You don’t need millions of followers to earn real money on TikTok. Engagement, niche, and consistency matter more than raw numbers.
        </div>
      </div>
    </div>
  </div>
</section>



<section class="wrapper bg-gradient-primary">
  <div class="container pt-10 pt-md-12">
    <h2 class="display-4 mb-3">How to Maximize Your TikTok Earnings</h2>
    <div class="row gx-lg-8 gx-xl-12 gy-6">
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Post Consistently:</strong> Upload at least 3–5 times per week. The TikTok algorithm rewards regular, high-quality content.</li>
          <li><strong>Engage With Your Audience:</strong> Reply to comments, host live sessions, and use Q&A features to build loyalty.</li>
          <li><strong>Leverage TikTok Analytics:</strong> Switch to a Pro Account and use analytics to track your best-performing videos and audience demographics.</li>
          <li><strong>Collaborate:</strong> Partner with other creators for duets, challenges, and cross-promotions to reach new audiences.</li>
          <li><strong>Keep Up With Trends:</strong> Use trending sounds, hashtags, and challenges to boost your reach and discoverability.</li>
        </ul>
      </div>
      <div class="col-md-6 text-start">
        <ul class="icon-list bullet-bg bullet-soft-green fs-18 lh-lg">
          <li><strong>Negotiate Brand Deals:</strong> Don’t undersell yourself. Use your calculator results to set fair rates for sponsored content.</li>
          <li><strong>Diversify Income Streams:</strong> Combine Creator Fund, brand deals, affiliate links, live gifts, and merchandise for stable income.</li>
          <li><strong>Optimize Video Length:</strong> Longer, high-retention videos often earn higher payouts under TikTok’s Creativity Program.</li>
          <li><strong>Promote Across Platforms:</strong> Share your TikTok content on Instagram, YouTube, and Facebook to attract new followers and sponsors.</li>
          <li><strong>Stay Compliant:</strong> Follow TikTok’s community guidelines to avoid demonetization or account suspension.</li>
        </ul>
      </div>
    </div>
    <div class="row mt-5">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Expert Tip:</strong> Track your RPM and CPM over time. Test different content types and see what brings the best return for your niche and audience.
        </div>
      </div>
    </div>
  </div>
</section>

<section class="wrapper bg-light">
  <div class="container pt-8 pt-md-10 pb-8 pb-md-12">
    <h2 class="display-4 mb-3">Frequently Asked Questions About TikTok Earnings</h2>
    <div class="accordion accordion-wrapper" id="faqAccordion">
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading1">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="false" aria-controls="faqCollapse1">
            How much does TikTok pay per 1,000 views?
          </button>
        </div>
        <div id="faqCollapse1" class="accordion-collapse collapse" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordion">
          <div class="card-body">
            TikTok pays between $0.02 and $0.04 per 1,000 views through the Creator Fund. However, brand deals and sponsorships can pay much more—sometimes $10 to $100+ per 1,000 views in top niches.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading2">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
            What is RPM and CPM on TikTok?
          </button>
        </div>
        <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordion">
          <div class="card-body">
            RPM (Revenue Per Mille) is what creators actually earn per 1,000 views. CPM (Cost Per Mille) is what advertisers pay per 1,000 impressions. Your RPM depends on your niche, country, engagement, and monetization methods.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading3">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
            What are the requirements to monetize on TikTok?
          </button>
        </div>
        <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordion">
          <div class="card-body">
            You must be at least 18 years old, have at least 10,000 followers, and 100,000 video views in the last 30 days. You also need a Pro Account and must follow TikTok’s community guidelines.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading4">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
            How do brand deals work on TikTok?
          </button>
        </div>
        <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordion">
          <div class="card-body">
            Brands pay creators to promote products or services in their videos. Rates depend on your follower count, engagement, niche, and audience location. Use your calculator results to negotiate fair compensation.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading5">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
            Can I earn money on TikTok without the Creator Fund?
          </button>
        </div>
        <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordion">
          <div class="card-body">
            Absolutely. Many creators earn more from brand deals, affiliate marketing, live gifts, and merchandise than from the Creator Fund or Creativity Program.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading6">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
            What is the TikTok Creativity Program?
          </button>
        </div>
        <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordion">
          <div class="card-body">
            The Creativity Program is TikTok’s new monetization system, rewarding creators for longer, high-retention videos. It pays higher RPMs than the Creator Fund, especially for original, storytelling content.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading7">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
            How can I increase my TikTok earnings?
          </button>
        </div>
        <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordion">
          <div class="card-body">
            Focus on high-engagement content, collaborate with other creators, post consistently, and diversify your monetization streams. Use analytics to track what works best for your audience and niche.
          </div>
        </div>
      </div>
      <div class="card plain accordion-item">
        <div class="card-header" id="faqHeading8">
          <button class="collapsed" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
            Is the TikTok Money Calculator free to use?
          </button>
        </div>
        <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordion">
          <div class="card-body">
            Yes, our TikTok Money Calculator is 100% free, always up-to-date, and safe to use for all creators and marketers.
          </div>
        </div>
      </div>
    </div>
    <div class="row mt-6">
      <div class="col-lg-10 mx-auto">
        <div class="alert alert-primary p-4 fs-17">
          <strong>Still have questions?</strong> Reach out to our team or explore our blog for more guides on TikTok monetization, influencer marketing, and social media growth strategies.
        </div>
      </div>
    </div>
  </div>
</section>

</div>

<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
  var form = document.getElementById('tt-money-form');
  var loader = document.getElementById('modal-loader-overlay');
  var results = document.getElementById('yt-results-area');
  if (form) {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      if (loader) loader.style.display = 'flex';
      if (results) results.innerHTML = '';
      var formData = new FormData(form);
      formData.append('ajax', '1');
      fetch(form.action, {
        method: 'POST',
        body: formData,
      })
      .then(response => response.text())
      .then(html => {
        setTimeout(function() {
          if (loader) loader.style.display = 'none';
          results.innerHTML = html;
          results.style.display = 'flex';
        }, 2500);
      })
      .catch(function() {
        if (loader) loader.style.display = 'none';
        if (results) results.innerHTML = '<div class="alert alert-danger">An error occurred. Please try again.</div>';
      });
    });
  }
});
</script>
<style>
/* Loader Overlay */
#modal-loader-overlay {
    display: none;
    position: fixed;
    z-index: 1050;
    top: 0; left: 0; right: 0; bottom: 0;
    background: rgba(255,255,255,0.92);
    align-items: center;
    justify-content: center;
}
#modal-loader-overlay .loader-content {
    display: flex;
    align-items: center;
    flex-direction: column;
}
#modal-loader-overlay .spinner-border {
    width: 3rem;
    height: 3rem;
}
#modal-loader-overlay .loader-text {
    margin-top: 1rem;
    font-size: 1.2rem;
    color: #2586f7;
    font-weight: 500;
}

/* TikTok Calculator Form Inputs and Button */
form#tt-money-form input.form-control,
form#tt-money-form select.form-control {
    height: 56px;
    font-size: 18px;
    padding: 12px 16px;
    display: block;
    width: 100%;
    font-weight: 700;
    line-height: 2.0;
    color: #60697b;
    background-color: var(--bs-body-bg, #fff);
    background-clip: padding-box;
    border: 1px solid rgba(8, 60, 130, 0.07);
    border-radius: 0.4rem;
    box-shadow: 0 0 1.25rem rgba(30, 34, 40, 0.04);
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
form#tt-money-form button#tt-money-btn {
    height: 54px;
    font-size: 1.15rem;
    padding-top: 18px;
    padding-bottom: 8px;
    line-height: 1.2;
    background: linear-gradient(90deg, #3f78e0 0%, #6a82fb 100%);
    color: #fff;
    font-weight: 600;
    border-radius: 6px;
    width: 100%;
    max-width: 320px;
    margin: 14px auto 0;
}

/* Result Card Styling */
.result-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 8px 32px rgba(60,90,130,0.10), 0 1.5px 4px rgba(60,90,130,0.10);
  max-width: 420px;
  margin: 2rem auto 0 auto;
  padding: 2rem 2rem 1.5rem 2rem;
  display: flex;
  flex-direction: column;
  align-items: center;
  transition: box-shadow 0.2s;
}
.result-card:hover {
  box-shadow: 0 16px 48px rgba(60,90,130,0.13), 0 3px 8px rgba(60,90,130,0.13);
}
.result-earnings {
  font-size: 2.7rem;
  font-weight: 800;
  color: #19b34a;
  margin-bottom: 0.25rem;
  text-align: center;
  letter-spacing: -1px;
}
.result-meta {
  font-weight: bold;
  font-size: 1.3rem;
  color: #2a3a5c;
  margin-bottom: 0.75rem;
  padding-bottom: 0.25rem;
  border-bottom: 2px solid #3f78e0;
  letter-spacing: 0.02em;
  text-align: center;
  background: linear-gradient(90deg, #f6fafd 70%, #e6f0ff 100%);
  border-radius: 6px 6px 0 0;
}
.result-details {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: 0.7rem;
}
.result-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #f6fafd;
  border-radius: 9px;
  padding: 1rem 1.2rem;
  box-shadow: 0 0.5px 1.5px rgba(60,90,130,0.04);
  font-size: 1.11rem;
}
.result-label {
  font-weight: 700;
  color: #2a3a5c;
}
.result-value {
  font-weight: 500;
  color: #384c6c;
  text-align: right;
  word-break: break-word;
}

/* Responsive adjustments */
@media (max-width: 600px) {
  .result-card {
    max-width: 98vw;
    padding: 1.1rem 0.5rem 1.1rem 0.5rem;
    border-radius: 13px;
    margin: 1.2rem auto 0 auto;
  }
  .result-details {
    gap: 0.5rem;
  }
  .result-row {
    font-size: 1.08rem;
    padding: 0.85rem 0.7rem;
  }
  .result-earnings {
    font-size: 2.1rem;
  }
  .result-meta {
    font-size: 1rem;
  }
  #modal-loader-overlay {
    /* Ensure loader covers full viewport on mobile */
    align-items: center;
    justify-content: center;
  }
}

/* Feature checklist styling */
.feature-checklist {
  list-style: none;
  padding-left: 0;
  margin-bottom: 1.5rem;
}
.feature-checklist li {
  position: relative;
  padding-left: 2em;
  margin-bottom: 1.1em;
  font-size: 1.08rem;
  font-weight: 500;
  color: #23305c;
}
.feature-checklist li::before {
  content: "\2713";
  position: absolute;
  left: 0;
  top: 0.1em;
  color: #19b34a;
  font-size: 1.25em;
  font-weight: bold;
  line-height: 1;
}
@media (max-width: 767.98px) {
  .feature-checklist {
    margin-bottom: 1.2rem;
  }
  .row .col-md-6 {
    margin-bottom: 1.2rem;
  }
}

/* Fix for large numbers overflowing card body */
.result-card, .result-details, .result-row, .result-value {
  max-width: 100%;
  word-wrap: break-word;
  overflow-wrap: break-word;
  white-space: normal;
}
.result-earnings {
  word-break: break-all;
  overflow-wrap: break-word;
  white-space: normal;
  max-width: 100%;
  font-size: 2.2rem;
  text-align: center;
}
</style>
