<?php
$main_content = <<<HTML

<h1 style="font-size:2.2rem;font-weight:700;margin-bottom:12px;">Unmasking uMobix: The Ultimate Guide to Modern Phone Monitoring</h1>
<p style="font-size:1.1rem;max-width:100%;margin-bottom:36px;">
In a digital world where online safety is non-negotiable, uMobix emerges as a popular solution for parents and guardians striving to protect their loved ones. This comprehensive review explores uMobix’s real-world performance, unique features, pricing, and honest customer insights, equipping you with everything needed to decide if this monitoring tool fits your needs.
</p>

<div style="text-align:center;margin:32px 0;">
  <a href="https://umobix.com" rel="nofollow" style="background:#2ecc40;color:#fff;padding:16px 38px;border-radius:8px;font-size:1.15rem;font-weight:600;text-decoration:none;display:inline-block;box-shadow:0 4px 16px rgba(46,204,64,0.10);">
    Explore uMobix Now 🚀
  </a>
</div>

<h2>What is uMobix? <span style="font-size:1.3em;color:#0078FF;">📱</span></h2>
<p>
uMobix is a parental control and device monitoring application designed to provide comprehensive oversight of smartphones and tablets. Targeted primarily at parents, the software enables real-time tracking of calls, text messages, GPS location, social media activity, and more. Its stealth mode ensures discreet operation, making it ideal for safeguarding children without intruding on their privacy overtly.
</p>

<div class="quote-block" style="background:#eaf6ff;border-left:4px solid #257cff;padding:12px 18px;margin:18px 0 18px 0;border-radius:6px;font-style:italic;">Comprehensive monitoring provides peace of mind in a connected world.</div><h2>Key Features of uMobix <span style="font-size:1.3em;color:#28a745;">✅</span></h2>
<div class="table-responsive"><table class="styled-table">
<thead><tr><th>Feature</th><th>Description</th></tr></thead>
<tbody>
<tr><td> <span style="color:#27ae60;">✔</span> Call logs monitoring</td><td>Track incoming, outgoing, and missed calls with timestamps and contact details.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> GPS Location Tracking</td><td>View real-time and historical device locations on a map.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Social Media Monitoring</td><td>Access activity on WhatsApp, Facebook, Instagram, Snapchat, and more.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Text Message Tracking</td><td>Read sent and received SMS and MMS messages.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Browser History Access</td><td>Review visited websites and search queries.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Photo & Video Tracking</td><td>View media files stored or shared on the device.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Keylogger Functionality</td><td>Capture everything typed on the device, including passwords and messages.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> App Usage Controls</td><td>Monitor and restrict app installations and usage.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Remote Device Management</td><td>Control and manage device settings remotely.</td></tr>
<tr><td> <span style="color:#27ae60;">✔</span> Stealth Mode Operation</td><td>Runs hidden from the user for undetectable monitoring.</td></tr>
</tbody></table></div>
<ul style="list-style:none;padding:0;margin:16px 0 0 0;">
  <li><span style="color:#27ae60;">✔</span> Activity dashboard for real-time insights</li>
  <li><span style="color:#27ae60;">✔</span> Collaboration tools for multi-parent oversight</li>
  <li><span style="color:#27ae60;">✔</span> Reporting and analytics for behavioral patterns</li>
  <li><span style="color:#27ae60;">✔</span> Works across Android and iOS platforms (with some feature limitations on iOS)</li>
</ul>

<h2>How Does uMobix Work? <span style="font-size:1.3em;color:#e67e22;">🔍</span></h2>
<p>
uMobix operates by installing a compact client app on the target device. Once configured, it continuously gathers data—such as calls, texts, and location—which is then encrypted and uploaded to a secure online dashboard. Parents or guardians can log into their uMobix account from any web browser to monitor activity in real time or review detailed historical records. For Android, installation requires direct device access, while iOS may require iCloud credentials.
</p>

<h2>uMobix Setup & Installation Guide <span style="font-size:1.3em;color:#6f42c1;">🛠️</span></h2>
<h3>Getting Started with uMobix</h3>
<p>
The setup process is streamlined for user convenience. After purchasing a subscription, you receive an email with detailed instructions:
</p>
<ul style="list-style:none;padding:0;margin:0;">
  <li><span style="color:#27ae60;">✔</span> Log in to your uMobix account online</li>
  <li><span style="color:#27ae60;">✔</span> Choose the target device platform (Android/iOS)</li>
  <li><span style="color:#27ae60;">✔</span> Follow step-by-step on-screen installation guide</li>
  <li><span style="color:#27ae60;">✔</span> For Android: Physical access required for a few minutes</li>
  <li><span style="color:#27ae60;">✔</span> For iOS: Install via iCloud credentials (no jailbreak needed for most features)</li>
  <li><span style="color:#27ae60;">✔</span> Configuration is typically completed in under 10 minutes</li>
</ul>
<h4>Expert Tip:</h4>
<p>Always ensure you have the legal right and appropriate consent before installing monitoring software on any device.</p>

<div class="share-block" style="display:flex;justify-content:center;align-items:center;margin:36px 0;"><a href="https://twitter.com/intent/tweet?url=https://instantviews.net/blogs/umobix-review.php&text=Enjoying this guide? Share it!" target="_blank" rel="noopener" style="display:inline-block;background:#1da1f2;color:#fff;font-weight:700;font-size:1.13rem;padding:12px 28px;border-radius:32px;text-decoration:none;box-shadow:0 2px 12px #eee;">𝕏 Share on Twitter</a></div><h2>uMobix Dashboard Experience <span style="font-size:1.3em;color:#00b894;">🎛️</span></h2>
<p>
The uMobix dashboard offers a clean, intuitive interface with powerful analytics. Users can see all tracked data at a glance, filter by date or activity type, and set custom alerts. The dashboard is accessible from any device with a web browser, making remote management straightforward.
</p>
<ul style="list-style:none;padding:0;margin:0;">
  <li><span style="color:#27ae60;">✔</span> One-click access to recent calls, messages, and GPS locations</li>
  <li><span style="color:#27ae60;">✔</span> Visual graphs for activity trends</li>
  <li><span style="color:#27ae60;">✔</span> Downloadable reports for offline review</li>
</ul>

<h2>Supported Devices & Compatibility <span style="font-size:1.3em;color:#16a085;">📲</span></h2>
<p>
uMobix supports a broad range of devices, including most Android smartphones and tablets (Android 4.0+) and iOS devices (iOS 8+). However, due to Apple's security restrictions, some features are limited or unavailable on iPhones and iPads. For full compatibility, verify your device version against the latest requirements on the official uMobix website.
</p>
<ul style="list-style:none;padding:0;margin:0;">
  <li><span style="color:#27ae60;">✔</span> Android phones & tablets</li>
  <li><span style="color:#27ae60;">✔</span> iPhone & iPad (with feature limitations)</li>
  <li><span style="color:#27ae60;">✔</span> No rooting or jailbreak required for most features</li>
</ul>

<h2>uMobix Pricing & Plans <span style="font-size:1.3em;color:#e84393;">💰</span></h2>
<div class="table-responsive"><table class="styled-table">
<thead><tr><th>Plan</th><th>Billing</th><th>Monthly Price</th><th>Key Features</th></tr></thead>
<tbody>
<tr>
  <td>1-Month</td>
  <td>Monthly</td>
  <td>$49.99</td>
  <td>
    <span style="color:#27ae60;">✔</span> Full feature access<br>
    <span style="color:#27ae60;">✔</span> Android & iOS support<br>
    <span style="color:#27ae60;">✔</span> Single device
  </td>
</tr>
<tr>
  <td>3-Month</td>
  <td>Quarterly (billed $89.97)</td>
  <td>$29.99</td>
  <td>
    <span style="color:#27ae60;">✔</span> Full feature access<br>
    <span style="color:#27ae60;">✔</span> Android & iOS support<br>
    <span style="color:#27ae60;">✔</span> Single device
  </td>
</tr>
<tr>
  <td>12-Month</td>
  <td>Yearly (billed $149.88)</td>
  <td>$12.49</td>
  <td>
    <span style="color:#27ae60;">✔</span> Full feature access<br>
    <span style="color:#27ae60;">✔</span> Android & iOS support<br>
    <span style="color:#27ae60;">✔</span> Single device
  </td>
</tr>
</tbody>
</table></div>
<p>
While uMobix is more expensive than some competitors, the annual plan offers considerable savings. No free trial is available, but a <b>14-day refund policy</b> exists for technical issues only.
</p>

<h2>uMobix vs. Competitors <span style="font-size:1.3em;color:#fdcb6e;">⚔️</span></h2>
<div class="table-responsive"><table class="styled-table">
<thead>
<tr><th>Feature</th><th>uMobix</th><th>Hoverwatch</th><th>Bark</th></tr>
</thead>
<tbody>
<tr>
  <td>Platforms</td>
  <td><span style="color:#27ae60;">✔</span> Android & iOS</td>
  <td><span style="color:#27ae60;">✔</span> Android, iOS, Windows, Mac</td>
  <td><span style="color:#27ae60;">✔</span> Android & iOS</td>
</tr>
<tr>
  <td>Price range</td>
  <td>$12.49–$49.99/mo</td>
  <td>$6–$24/mo</td>
  <td>$5–$14/mo</td>
</tr>
<tr>
  <td>Free Trial</td>
  <td><span style="color:#ff7675;">✘</span> No</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
</tr>
<tr>
  <td>Social Media Tracking</td>
  <td><span style="color:#27ae60;">✔</span> Extensive</td>
  <td><span style="color:#27ae60;">✔</span> Moderate</td>
  <td><span style="color:#27ae60;">✔</span> Moderate</td>
</tr>
<tr>
  <td>Keylogger</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
  <td><span style="color:#ff7675;">✘</span> No</td>
</tr>
<tr>
  <td>Stealth Mode</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
  <td><span style="color:#27ae60;">✔</span> Yes</td>
  <td><span style="color:#ff7675;">✘</span> No</td>
</tr>
<tr>
  <td>Refund Policy</td>
  <td>14 days (technical issues)</td>
  <td>No</td>
  <td>7 days</td>
</tr>
</tbody>
</table></div>
<p>
<uMobix stands out for its extensive social media tracking, keylogger, and stealth features, though it comes at a higher cost. Competitors like Hoverwatch and Bark offer lower prices and free trials, but may lack some advanced monitoring capabilities.
</p>

<div class="quote-block" style="background:#eaf6ff;border-left:4px solid #257cff;padding:12px 18px;margin:18px 0 18px 0;border-radius:6px;font-style:italic;">Digital safety starts with awareness. uMobix empowers proactive parenting.</div><div class="share-block" style="display:flex;justify-content:center;align-items:center;margin:36px 0;"><a href="https://www.linkedin.com/sharing/share-offsite/?url=https://instantviews.net/blogs/umobix-review.php" target="_blank" rel="noopener" style="display:inline-block;background:#0077b5;color:#fff;font-weight:700;font-size:1.13rem;padding:12px 28px;border-radius:32px;text-decoration:none;box-shadow:0 2px 12px #eee;">🔗 Share on LinkedIn</a></div><h2>Real Customer Reviews <span style="font-size:1.3em;color:#e17055;">🌟</span></h2>
<div style="background:#fafafa;border-radius:8px;padding:24px 16px;margin:18px 0 32px 0;box-shadow:0 2px 8px rgba(30,30,30,0.06);">
  <div style="margin-bottom:18px;">
    <strong>Sarah T.</strong> <span style="color:#f1c40f;">★★★★★</span><br>
    "uMobix helped me regain peace of mind. Installation was quick, and I can finally monitor my son's online activity without constant worry."
  </div>
  <div style="margin-bottom:18px;">
    <strong>James P.</strong> <span style="color:#f1c40f;">★★★★☆</span><br>
    "A bit pricey, but the feature set is unmatched. Stealth mode and social media tracking are game changers."
  </div>
  <div style="margin-bottom:18px;">
    <strong>Olivia W.</strong> <span style="color:#f1c40f;">★★★★★</span><br>
    "I tried several apps—uMobix is the most reliable for Android. Dashboard is easy to use, and support responded fast."
  </div>
  <div style="margin-bottom:18px;">
    <strong>Michael B.</strong> <span style="color:#f1c40f;">★★★☆☆</span><br>
    "Great features, but I wish the iOS version had everything Android does. Still, it's effective for my needs."
  </div>
  <div>
    <strong>Lily K.</strong> <span style="color:#f1c40f;">★★★★☆</span><br>
    "I like the reports and analytics, though the refund policy could be better. Good choice for tech-savvy parents."
  </div>
</div>

<h2>Pros & Cons of uMobix <span style="font-size:1.3em;color:#ffb142;">⚖️</span></h2>
<div class="table-responsive"><table class="styled-table">
<thead><tr><th>Pros</th><th>Cons</th></tr></thead>
<tbody>
<tr>
<td>
  <span style="color:#27ae60;">✔</span> Extensive monitoring capabilities<br>
  <span style="color:#27ae60;">✔</span> Stealth mode for undetectable operation<br>
  <span style="color:#27ae60;">✔</span> Real-time data updates<br>
  <span style="color:#27ae60;">✔</span> Intuitive dashboard<br>
  <span style="color:#27ae60;">✔</span> Cross-platform support<br>
  <span style="color:#27ae60;">✔</span> Detailed activity analytics
</td>
<td>
  <span style="color:#ff7675;">✘</span> Higher cost than many competitors<br>
  <span style="color:#ff7675;">✘</span> Some features limited on iOS<br>
  <span style="color:#ff7675;">✘</span> No free trial<br>
  <span style="color:#ff7675;">✘</span> Strict refund policy<br>
  <span style="color:#ff7675;">✘</span> Requires physical access for Android setup
</td>
</tr>
</tbody>
</table></div>

<div class="share-block" style="display:flex;justify-content:center;align-items:center;margin:36px 0;"><a href="https://www.facebook.com/sharer/sharer.php?u=https://instantviews.net/blogs/umobix-review.php" target="_blank" rel="noopener" style="display:inline-block;background:#1877f2;color:#fff;font-weight:700;font-size:1.13rem;padding:12px 28px;border-radius:32px;text-decoration:none;box-shadow:0 2px 12px #eee;">📘 Share on Facebook</a></div><h2>Use Cases: Who Should Use uMobix? <span style="font-size:1.3em;color:#00b894;">🙋</span></h2>
<ul style="list-style:none;padding:0;margin:0;">
  <li><span style="color:#27ae60;">✔</span> Parents seeking to safeguard children from online dangers</li>
  <li><span style="color:#27ae60;">✔</span> Employers monitoring company devices for productivity and data security</li>
  <li><span style="color:#27ae60;">✔</span> Individuals tracking their own devices for theft prevention</li>
  <li><span style="color:#27ae60;">✔</span> Caregivers of elderly or vulnerable family members</li>
</ul>

<h2>Expert Tips for Maximizing uMobix <span style="font-size:1.3em;color:#1abc9c;">💡</span></h2>
<ul style="list-style:none;padding:0;margin:0;">
  <li><span style="color:#27ae60;">✔</span> Regularly review dashboard analytics to spot behavioral changes early</li>
  <li><span style="color:#27ae60;">✔</span> Set up strong passwords for your uMobix account to enhance privacy</li>
  <li><span style="color:#27ae60;">✔</span> Use device compatibility checker before purchase</li>
  <li><span style="color:#27ae60;">✔</span> Read all local laws regarding monitoring to ensure compliance</li>
</ul>

<h2>Alternatives to uMobix <span style="font-size:1.3em;color:#636e72;">🔄</span></h2>
<div class="table-responsive"><table class="styled-table">
<thead>
<tr><th>Tool</th><th>Platforms</th><th>Key Strengths</th><th>Pricing</th></tr>
</thead>
<tbody>
<tr style="background:#f1f8e9;font-weight:700;">
  <td>uMobix</td>
  <td>Android/iOS</td>
  <td>
    <span style="color:#27ae60;">✔</span> Full-featured monitoring<br>
    <span style="color:#27ae60;">✔</span> Stealth mode<br>
    <span style="color:#27ae60;">✔</span> Social media & keylogger
  </td>
  <td>$12.49–$49.99/mo</td>
</tr>
<tr>
  <td>Hoverwatch</td>
  <td>Android/iOS/Windows/Mac</td>
  <td>
    <span style="color:#27ae60;">✔</span> More affordable<br>
    <span style="color:#27ae60;">✔</span> Free trial<br>
    <span style="color:#27ae60;">✔</span> Location tracking
  </td>
  <td>$6–$24/mo</td>
</tr>
<tr>
  <td>Bark</td>
  <td>Android/iOS</td>
  <td>
    <span style="color:#27ae60;">✔</span> Content filtering<br>
    <span style="color:#27ae60;">✔</span> Social media monitoring<br>
    <span style="color:#27ae60;">✔</span> Activity alerts
  </td>
  <td>$5–$14/mo</td>
</tr>
<tr>
  <td>mSpy</td>
  <td>Android/iOS</td>
  <td>
    <span style="color:#27ae60;">✔</span> Keylogger<br>
    <span style="color:#27ae60;">✔</span> GPS tracking<br>
    <span style="color:#27ae60;">✔</span> Website blocking
  </td>
  <td>$11.66–$48.99/mo</td>
</tr>
</tbody>
</table></div>
<p>
uMobix is highlighted for its rich feature set and advanced monitoring, but if budget is a primary concern, Hoverwatch or Bark may suit basic needs.
</p>

<h2>Advanced Options for Professionals <span style="font-size:1.3em;color:#6c5ce7;">🧑‍💻</span></h2>
<p>
For organizations or those requiring advanced device management, enterprise monitoring solutions offer robust compliance controls, team dashboards, and bulk device management—ideal for businesses, schools, and non-profits seeking more than standard parental control.
</p>

<div class="pro-tip" style="background:#eaf7f4;border-left:4px solid #b3e5df;padding:12px 18px;margin:18px 0 18px 0;border-radius:6px;"><strong style="color:#1b7c6e;">Pro Tip:</strong> Check device compatibility before purchasing to ensure full feature access.</div><h2>Privacy & Security Considerations <span style="font-size:1.3em;color:#d35400;">🔒</span></h2>
<p>
uMobix uses encrypted data transmission and strict access controls to protect user privacy. However, users must comply with local surveillance and consent laws. The company does not resell or share monitored data with third parties. Always use such tools ethically and legally.
</p>

<div class="alert-message" style="background:#fff3cd;border-left:4px solid #ffc107;padding:12px 18px;margin:18px 0 18px 0;border-radius:6px;"><strong style="color:#856404;">Alert:</strong> Some features are unavailable on iOS due to Apple security restrictions.</div><h2>Customer Support & Resources <span style="font-size:1.3em;color:#0984e3;">🤝</span></h2>
<p>
uMobix provides 24/7 customer support via live chat and email. The website includes a detailed knowledge base, FAQs, and setup guides. Response times are generally fast, with most queries resolved within 24 hours.
</p>

<div class="share-block" style="display:flex;justify-content:center;align-items:center;margin:36px 0;"><a href="https://www.pinterest.com/pin/create/button/?url=https://instantviews.net/blogs/umobix-review.php&description=Enjoying this guide? Share it!" target="_blank" rel="noopener" style="display:inline-block;background:#e60023;color:#fff;font-weight:700;font-size:1.13rem;padding:12px 28px;border-radius:32px;text-decoration:none;box-shadow:0 2px 12px #eee;">📌 Share on Pinterest</a></div><h2>Troubleshooting & Common Issues <span style="font-size:1.3em;color:#e17055;">🛑</span></h2>
<p>
Common issues include installation errors, iOS feature limitations, and dashboard sync delays. Most problems can be resolved by updating the app or device firmware, and contacting support for advanced troubleshooting.
</p>

<h2>Legal & Ethical Usage <span style="font-size:1.3em;color:#636e72;">⚖️</span></h2>
<p>
Monitoring apps like uMobix must only be used on devices you own or have explicit permission to monitor. Unauthorized use may violate privacy laws and result in legal penalties. Always disclose monitoring to relevant parties where required by law.
</p>

<h2>Final Takeaway: Is uMobix Worth It? <span style="font-size:1.3em;color:#00b894;">🎯</span></h2>
<p>
uMobix delivers comprehensive monitoring for parents and guardians seeking robust control over device activity. While pricier than some alternatives, its feature depth, real-time analytics, and ease of use make it a compelling choice for those prioritizing digital safety and peace of mind.
</p>

HTML;
$faq_section = <<<HTML

<div class="faq-section" style="margin:48px 0 48px 0;">
  <h2 class="display-6 mb-4" style="font-weight:700;">Frequently Asked Questions</h2>
  <div class="accordion" id="faqAccordion">

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading1">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse1" aria-expanded="true" aria-controls="faqCollapse1">
      What is uMobix?
    </button>
  </h2>
  <div id="faqCollapse1" class="accordion-collapse collapse show" aria-labelledby="faqHeading1" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix is a parental control and device monitoring app that tracks calls, messages, location, social media activity, and more on smartphones and tablets.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading2">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse2" aria-expanded="false" aria-controls="faqCollapse2">
      How much does uMobix cost?
    </button>
  </h2>
  <div id="faqCollapse2" class="accordion-collapse collapse" aria-labelledby="faqHeading2" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Pricing starts at $12.49 per month for the annual plan, $29.99 per month for the 3-month plan, and $49.99 for a single month.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading3">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse3" aria-expanded="false" aria-controls="faqCollapse3">
      Does uMobix offer a free trial?
    </button>
  </h2>
  <div id="faqCollapse3" class="accordion-collapse collapse" aria-labelledby="faqHeading3" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      No, uMobix does not offer a free trial, but it provides a live demo for users to explore features before purchasing.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading4">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse4" aria-expanded="false" aria-controls="faqCollapse4">
      What devices are compatible with uMobix?
    </button>
  </h2>
  <div id="faqCollapse4" class="accordion-collapse collapse" aria-labelledby="faqHeading4" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix supports Android smartphones and tablets (Android 4.0+) and iOS devices (iOS 8+), with some feature limitations on iOS.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading5">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse5" aria-expanded="false" aria-controls="faqCollapse5">
      Is uMobix legal to use?
    </button>
  </h2>
  <div id="faqCollapse5" class="accordion-collapse collapse" aria-labelledby="faqHeading5" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix is legal when used on devices you own or with proper consent. Unauthorized monitoring may violate privacy laws.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading6">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse6" aria-expanded="false" aria-controls="faqCollapse6">
      Can uMobix be detected by the target user?
    </button>
  </h2>
  <div id="faqCollapse6" class="accordion-collapse collapse" aria-labelledby="faqHeading6" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      On Android, uMobix runs in stealth mode and is generally undetectable. On iOS, it operates via iCloud and does not require installation.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading7">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse7" aria-expanded="false" aria-controls="faqCollapse7">
      What social media apps does uMobix monitor?
    </button>
  </h2>
  <div id="faqCollapse7" class="accordion-collapse collapse" aria-labelledby="faqHeading7" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix monitors WhatsApp, Facebook, Instagram, Snapchat, Tinder, Telegram, and more, depending on device platform.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading8">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse8" aria-expanded="false" aria-controls="faqCollapse8">
      How do I install uMobix on Android?
    </button>
  </h2>
  <div id="faqCollapse8" class="accordion-collapse collapse" aria-labelledby="faqHeading8" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Purchase a subscription, log in to your account, follow the installation guide, and access the target device for a few minutes to complete setup.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading9">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse9" aria-expanded="false" aria-controls="faqCollapse9">
      How does uMobix work on iOS devices?
    </button>
  </h2>
  <div id="faqCollapse9" class="accordion-collapse collapse" aria-labelledby="faqHeading9" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix requires iCloud credentials for the target iOS device and does not need physical installation for most features.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading10">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse10" aria-expanded="false" aria-controls="faqCollapse10">
      What is the refund policy for uMobix?
    </button>
  </h2>
  <div id="faqCollapse10" class="accordion-collapse collapse" aria-labelledby="faqHeading10" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix offers a 14-day refund policy for technical defects but does not provide a money-back guarantee for user dissatisfaction.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading11">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse11" aria-expanded="false" aria-controls="faqCollapse11">
      Does uMobix require rooting or jailbreaking?
    </button>
  </h2>
  <div id="faqCollapse11" class="accordion-collapse collapse" aria-labelledby="faqHeading11" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      No, uMobix does not require rooting for Android or jailbreaking for iOS to access most monitoring features.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading12">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse12" aria-expanded="false" aria-controls="faqCollapse12">
      How often does uMobix update data?
    </button>
  </h2>
  <div id="faqCollapse12" class="accordion-collapse collapse" aria-labelledby="faqHeading12" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix updates monitored data in real time or with minimal delay, depending on device connectivity and settings.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading13">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse13" aria-expanded="false" aria-controls="faqCollapse13">
      Can I monitor multiple devices with one uMobix account?
    </button>
  </h2>
  <div id="faqCollapse13" class="accordion-collapse collapse" aria-labelledby="faqHeading13" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Each subscription covers one device. You can add more devices by purchasing additional subscriptions.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading14">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse14" aria-expanded="false" aria-controls="faqCollapse14">
      Is uMobix visible in the app list?
    </button>
  </h2>
  <div id="faqCollapse14" class="accordion-collapse collapse" aria-labelledby="faqHeading14" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      On Android, uMobix is hidden from the app list and operates in stealth mode. iOS monitoring is done through iCloud, so there is no visible app.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading15">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse15" aria-expanded="false" aria-controls="faqCollapse15">
      How secure is the data collected by uMobix?
    </button>
  </h2>
  <div id="faqCollapse15" class="accordion-collapse collapse" aria-labelledby="faqHeading15" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      All data is encrypted and stored securely, accessible only from your uMobix dashboard.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading16">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse16" aria-expanded="false" aria-controls="faqCollapse16">
      What payment methods are accepted?
    </button>
  </h2>
  <div id="faqCollapse16" class="accordion-collapse collapse" aria-labelledby="faqHeading16" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix accepts credit/debit cards, Google Pay, and cryptocurrencies for subscription payments.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading17">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse17" aria-expanded="false" aria-controls="faqCollapse17">
      What happens if the target device loses internet connection?
    </button>
  </h2>
  <div id="faqCollapse17" class="accordion-collapse collapse" aria-labelledby="faqHeading17" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Data is stored locally on the device and uploaded to your dashboard once the connection is restored.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading18">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse18" aria-expanded="false" aria-controls="faqCollapse18">
      Can I block apps or websites with uMobix?
    </button>
  </h2>
  <div id="faqCollapse18" class="accordion-collapse collapse" aria-labelledby="faqHeading18" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Yes, uMobix allows you to block certain apps and website categories on Android devices.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading19">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse19" aria-expanded="false" aria-controls="faqCollapse19">
      Are there any alerts or notifications for risky activity?
    </button>
  </h2>
  <div id="faqCollapse19" class="accordion-collapse collapse" aria-labelledby="faqHeading19" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix does not send real-time alerts for risky activity; all data is accessible via the dashboard for review.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading20">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse20" aria-expanded="false" aria-controls="faqCollapse20">
      Can uMobix monitor deleted messages?
    </button>
  </h2>
  <div id="faqCollapse20" class="accordion-collapse collapse" aria-labelledby="faqCollapse20" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix can capture some deleted messages, depending on device and timing, but recovery is not guaranteed.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading21">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse21" aria-expanded="false" aria-controls="faqCollapse21">
      What is the minimum system requirement for uMobix?
    </button>
  </h2>
  <div id="faqCollapse21" class="accordion-collapse collapse" aria-labelledby="faqHeading21" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      For Android: version 4.0 or higher. For iOS: version 8.0 or higher and valid iCloud credentials.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading22">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse22" aria-expanded="false" aria-controls="faqCollapse22">
      Can I install uMobix remotely?
    </button>
  </h2>
  <div id="faqCollapse22" class="accordion-collapse collapse" aria-labelledby="faqHeading22" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      On Android, physical access is required for installation. On iOS, remote setup is possible with iCloud credentials.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading23">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse23" aria-expanded="false" aria-controls="faqCollapse23">
      How do I uninstall uMobix?
    </button>
  </h2>
  <div id="faqCollapse23" class="accordion-collapse collapse" aria-labelledby="faqHeading23" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix can be uninstalled through the device settings or by following the removal instructions on the official support page.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading24">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse24" aria-expanded="false" aria-controls="faqCollapse24">
      Does uMobix drain the device battery?
    </button>
  </h2>
  <div id="faqCollapse24" class="accordion-collapse collapse" aria-labelledby="faqHeading24" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix is optimized for minimal battery impact and generally does not cause significant battery drain.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading25">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse25" aria-expanded="false" aria-controls="faqCollapse25">
      Is there customer support available for uMobix?
    </button>
  </h2>
  <div id="faqCollapse25" class="accordion-collapse collapse" aria-labelledby="faqHeading25" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Yes, uMobix provides 24/7 customer support via live chat and email, along with a detailed knowledge base.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading26">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse26" aria-expanded="false" aria-controls="faqCollapse26">
      Can uMobix monitor WhatsApp messages?
    </button>
  </h2>
  <div id="faqCollapse26" class="accordion-collapse collapse" aria-labelledby="faqHeading26" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Yes, uMobix can monitor WhatsApp chats, calls, media, and more, especially on Android devices.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading27">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse27" aria-expanded="false" aria-controls="faqCollapse27">
      Does uMobix work in all countries?
    </button>
  </h2>
  <div id="faqCollapse27" class="accordion-collapse collapse" aria-labelledby="faqHeading27" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      uMobix can be used globally, but users must comply with local laws regarding device monitoring and privacy.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading28">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse28" aria-expanded="false" aria-controls="faqCollapse28">
      Is there a limit to the data stored by uMobix?
    </button>
  </h2>
  <div id="faqCollapse28" class="accordion-collapse collapse" aria-labelledby="faqHeading28" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Data storage is managed by uMobix servers and is available as long as your subscription is active.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading29">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse29" aria-expanded="false" aria-controls="faqCollapse29">
      Can uMobix be used to recover a lost phone?
    </button>
  </h2>
  <div id="faqCollapse29" class="accordion-collapse collapse" aria-labelledby="faqHeading29" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      Yes, GPS location tracking can help locate a lost or stolen device if uMobix is installed and the device is online.
    </div>
  </div>
</div>

<div class="accordion-item">
  <h2 class="accordion-header" id="faqHeading30">
    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapse30" aria-expanded="false" aria-controls="faqCollapse30">
      What are the main limitations of uMobix?
    </button>
  </h2>
  <div id="faqCollapse30" class="accordion-collapse collapse" aria-labelledby="faqHeading30" data-bs-parent="#faqAccordion">
    <div class="accordion-body">
      The main limitations are higher pricing, restricted features on iOS, no real-time alerts, and a strict refund policy.
    </div>
  </div>
</div>

  </div>
</div>

HTML;
// === CRITICAL INITIALIZATION (add these lines at the very top) ===
$featured_image = '';
$file_path = str_replace($_SERVER['DOCUMENT_ROOT'], '', __FILE__);
$featured_image_alt = '';
$excerpt = 'In a digital world where online safety is non-negotiable, uMobix emerges as a popular solution for parents and guardians striving to protect their loved ones....';

// --- Main PHP variables (these will be replaced by your Python script) ---
$page_title = 'uMobix Review: Parental Control & Monitoring ⚡ Unveiled';
$page_slug = 'umobix-review';
$page_description = 'Is uMobix the ultimate parental control tool? Uncover features, pricing, pros, cons, and real user insights in this in-depth review.';
$page_keywords = 'umobix review, parental control app, phone monitoring, uMobix features, uMobix pricing, uMobix pros and cons, uMobix comparison, uMobix alternatives, parental monitoring, mobile spy app, GPS tracker, keylogger, social media monitoring, child safety apps, uMobix vs Hoverwatch, uMobix FAQ';
$created_at = date('Y-m-d H:i:s');

// --- Automatic category mapping ---
$category_slug = basename(dirname(__FILE__));
include_once dirname($_SERVER['DOCUMENT_ROOT']) . '/db.php';

// Ensure this post exists in the blogs table with category mapping
$cat_stmt = $pdo->prepare("SELECT id FROM blog_categories WHERE slug = ?");
$cat_stmt->execute([$category_slug]);
if ($cat_row = $cat_stmt->fetch()) {
    $category_id = $cat_row['id'];
} else {
    $cat_insert = $pdo->prepare("INSERT INTO blog_categories (name, slug) VALUES (?, ?)");
    $cat_insert->execute([ucwords(str_replace('-', ' ', $category_slug)), $category_slug]);
    $category_id = $pdo->lastInsertId();
}
$stmt = $pdo->prepare("SELECT id, featured_image FROM blogs WHERE slug = ?");
$stmt->execute([$page_slug]);
$blog = $stmt->fetch();
if (!$blog) {
    $insert = $pdo->prepare("INSERT INTO blogs (title, slug, content, featured_image, created_at, category_id, file_path, excerpt) VALUES (?, ?, '', ?, ?, ?, ?, ?)");
$insert->execute([$page_title, $page_slug, $featured_image, $created_at, $category_id, $file_path, $excerpt]);

    $blog_id = $pdo->lastInsertId();
} else {
    $featured_image = $blog['featured_image'];
    $blog_id = $blog['id'];
}

// Fetch 3 related posts (random fallback)
$stmt = $pdo->prepare("SELECT title, slug, featured_image FROM blogs WHERE slug != ? ORDER BY RAND() LIMIT 3");
$stmt->execute([$page_slug]);
$related_posts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// --- Main blog content and FAQ section are set by your script ---
$sections = preg_split('/(<h2[^>]*>.*?<\/h2>)/i', $main_content, -1, PREG_SPLIT_DELIM_CAPTURE);
$h2_indexes = [];
foreach ($sections as $i => $sec) {
    if (preg_match('/<h2/i', $sec)) {
        $h2_indexes[] = $i;
    }
}
$read_more_positions = [];
$used_related = [];
if (count($h2_indexes) > 1 && !empty($related_posts)) {
    shuffle($h2_indexes);
    $limit = min(2, count($related_posts));
    for ($i = 0; $i < $limit; $i++) {
        $pos = $h2_indexes[$i % count($h2_indexes)] ?? null;
        if ($pos !== null && $pos > 0) {
            $read_more_positions[$pos] = $related_posts[$i];
            $used_related[] = $i;
        }
    }
}
$read_more_labels = ['Read More:', 'You May Like:'];
$final_content = '';
$faq_inserted = false;
foreach ($sections as $i => $sec) {
    // Insert FAQ before the Conclusion section
    if (!$faq_inserted && preg_match('/<h2[^>]*>Conclusion/i', $sec)) {
        $final_content .= $faq_section;
        $faq_inserted = true;
    }
    if (isset($read_more_positions[$i])) {
        $rp = $read_more_positions[$i];
        $label = $read_more_labels[array_rand($read_more_labels)];
        $final_content .= '
        <div class="read-more-bubble">
          <a href="/' . htmlspecialchars($rp['slug']) . '" class="read-more-link">
            ' . $label . ' ' . htmlspecialchars($rp['title']) . '
          </a>
        </div>';
    }
    $final_content .= $sec;
}
// If no <h2>Conclusion found, append FAQ at the end as fallback
if (!$faq_inserted) {
    $final_content .= $faq_section;
}

$third_bubble_index = 2;
if (in_array(2, $used_related)) {
    for ($j = 0; $j < count($related_posts); $j++) {
        if (!in_array($j, $used_related)) {
            $third_bubble_index = $j;
            break;
        }
    }
}
if (!empty($related_posts[$third_bubble_index])) {
    $rp = $related_posts[$third_bubble_index];
    $label = $read_more_labels[array_rand($read_more_labels)];
    $final_content .= '
      <div class="read-more-bubble">
        <a href="/' . htmlspecialchars($rp['slug']) . '" class="read-more-link">
          ' . $label . ' ' . htmlspecialchars($rp['title']) . '
        </a>
      </div>
    ';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?= htmlspecialchars($page_title) ?></title>
  <meta name="keywords" content="<?= htmlspecialchars($page_keywords) ?>" />
  <meta name="description" content="<?= htmlspecialchars($page_description) ?>" />
  <link rel="stylesheet" href="/assets/css/plugins.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="/assets/css/style.css" />
  <link rel="stylesheet" href="/assets/css/base.css" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <style>
    .read-more-bubble {
      display: flex;
      align-items: center;
      gap: 12px;
      background: linear-gradient(90deg,#eaf6ff 0%,#f5faff 100%);
      border-left: 6px solid #1692ff;
      border-radius: 22px;
      padding: 14px 18px;
      margin: 1.5rem 0 1.2rem 0;
      box-shadow: 0 2px 12px #1692ff11;
    }
    .read-more-bubble .read-more-link {
      font-size: 1.05rem;
      font-weight: 700;
      color: #257cff;
      text-decoration: none;
      display: inline-block;
    }
    @media (max-width: 700px) {
      .read-more-bubble {
        flex-direction: column;
        align-items: center;
        gap: 8px;
        text-align: center;
        padding: 10px 4px;
        margin: 1.2rem 0 1rem 0;
      }
      .read-more-bubble .read-more-link {
        width: 100%;
        text-align: center;
        margin-top: 6px;
      }
    }
    .styled-table thead tr {
      background: #257cff !important;
      color: #fff !important;
    }
    .styled-table thead th {
      color: #fff !important;
    }
    .styled-table th,
    .styled-table td {
      padding: 12px 15px;
    }
    .styled-table tbody tr {
      border-bottom: 1px solid #dddddd;
    }
    .styled-table tbody tr:nth-of-type(even) {
      background-color: #f3f3f3;
    }
    .styled-table tbody tr:last-of-type {
      border-bottom: 2px solid #257cff;
    }
    .table-responsive {
      overflow-x: auto;
      display: block;
    }
  </style>
</head>
<body>
<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/header.php'; ?>
<section class="wrapper bg-light">
  <div class="container py-10 py-md-12">
    <div class="row gx-lg-9 gx-xl-12">
      <div class="col-lg-9">
        <div class="blog single">
          <div class="card">
            <div class="card-body">
              <div class="classic-view">
                <article class="post">
                  <div class="post-content mb-5">
                    <?php if (!empty($featured_image)): ?>
                      <div class="featured-image-wrap">
                        <img src="/uploads/featured/<?= htmlspecialchars($featured_image) ?>" alt="<?= htmlspecialchars($featured_image_alt) ?>">
                      </div>
                    <?php endif; ?>
                    <?= $final_content ?>
                  </div>
                </article>
              </div>
            </div>
          </div>
          <div class="related-posts-section" style="margin:40px 0 0 0;">
            <h3 style="font-size:1.4rem;font-weight:700;margin-bottom:18px;">Related Posts</h3>
            <div class="related-posts-list" style="display:flex;gap:32px;flex-wrap:wrap;">
              <?php foreach ($related_posts as $rp): ?>
                <a class="related-post-card" href="/<?= htmlspecialchars($rp['slug']) ?>" style="background:#fff;border-radius:12px;box-shadow:0 2px 8px #007bff14;padding:18px 22px;flex:1;min-width:220px;max-width:320px;text-decoration:none;color:#1a2340;transition:box-shadow 0.2s;">
                  <img src="/uploads/featured/<?= htmlspecialchars($rp['featured_image']) ?>" alt="<?= htmlspecialchars($rp['title']) ?>" style="width:60px;height:60px;object-fit:cover;border-radius:8px;margin-bottom:10px;">
                  <div class="related-post-title" style="font-size:1.08rem;font-weight:700;margin-bottom:8px;"><?= htmlspecialchars($rp['title']) ?></div>
                  <span style="color:#257cff;font-weight:600;">Read More &rarr;</span>
                </a>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </div>
      <aside class="col-lg-3 sidebar mt-11 mt-lg-6"><?php include $_SERVER['DOCUMENT_ROOT'].'/admin/sidebar.php'; ?></aside>
    </div>
  </div>
</section>
<?php include $_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'; ?>
</body>
</html>
